/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate.day;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RangeCleaner;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeManager;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeRecalculateDayManager;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TrafficRangeRecalculateDayManager
extends RangeRecalculateDayManager
implements RangeCleaner {
    public TrafficRangeRecalculateDayManager(Connection con, Date dateFrom, Date dateTo, int moduleId, RangeManager manager) throws SQLException {
        super(con, dateFrom, dateTo, moduleId, manager);
    }

    protected void initTableNames(Date dateFrom, int moduleId) {
        this.trafficRangeTableName = ServerUtils.getModuleTableName((String)"inet_tariff_traffic_range", (int)moduleId);
        this.trafficRangeDetailTableName = ServerUtils.getModuleMonthTableName((String)"inet_tariff_traffic_range_detail", (Date)dateFrom, (int)moduleId);
    }

    @Override
    public void removeAllExtraData(Date month, Set<Integer> cids, int idDivizor, int idRemainder, Set<Integer> affectedContracts) throws BGException, SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        String andCidPartWithAffected = SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts, "detail.");
        String query = " SELECT detail.contractId, detail.treeNodeId, detail.rangeKey, SUM(detail.amount) as amount, r.maxAmount FROM " + this.trafficRangeDetailTableName + " AS detail LEFT JOIN  " + this.trafficRangeTableName + " AS r ON r.contractId = detail.contractId AND r.treeNodeId = detail.treeNodeId  AND r.rangeKey = detail.rangeKey  WHERE 1=1 " + andCidPartWithAffected.replace("cid", "contractId") + " GROUP BY detail.contractId,detail.treeNodeId, detail.rangeKey";
        PreparedStatement ps = this.con.prepareStatement(query);
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, 1, cids, idDivizor, idRemainder);
        HashSet<Long> affectedKeys = new HashSet<Long>();
        HashSet<Long> affectedNodes = new HashSet<Long>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            long amount = rs.getLong("amount");
            long treeNodeId = rs.getLong("treeNodeId");
            long rangeKey = rs.getLong("rangeKey");
            int contractId = rs.getInt("contractId");
            long maxAmount = rs.getLong("amount");
            TrafficRange value = new TrafficRange(0, amount, maxAmount);
            TrafficRangeKey key = new TrafficRangeKey(treeNodeId, rangeKey);
            this.updateRangeTraffic(contractId, key, value);
            affectedKeys.add(key.getKey());
            affectedNodes.add(key.getTreeNodeId());
        }
        rs.close();
        ps.close();
        if (affectedNodes.size() == 0) {
            affectedNodes.add(-1L);
        }
        if (affectedKeys.size() == 0) {
            affectedKeys.add(-1L);
        }
        andCidPartWithAffected = SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts);
        int idx = 1;
        PreparedStatement deleteInvalidRangeTraffsForContractPS = this.con.prepareStatement("DELETE FROM " + this.trafficRangeTableName + " WHERE 1=1 " + andCidPartWithAffected.replace("cid", "contractId") + " AND yy = ? AND mm = ?  AND ( treeNodeId NOT IN (" + Utils.toString(affectedNodes) + ")  OR rangeKey not IN(" + Utils.toString(affectedKeys) + ") )");
        idx = SessionRecalculateTarifficationManager.setDivizorAndRemainder(deleteInvalidRangeTraffsForContractPS, idx, cids, idDivizor, idRemainder);
        deleteInvalidRangeTraffsForContractPS.setInt(idx++, yy);
        deleteInvalidRangeTraffsForContractPS.setInt(idx++, mm);
        deleteInvalidRangeTraffsForContractPS.executeUpdate();
        deleteInvalidRangeTraffsForContractPS.close();
    }
}

