/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class VoiceGeographicCodeDao
extends AbstractIdDao<VoiceGeographicCode> {
    static final String VOICE_CODE_DESTINATION_TABLENAME = "voice_code_destination";
    static final String VOICE_GEOCODE_TABLENAME = "voice_geographic_code";
    private String codeDestTableName;

    public VoiceGeographicCodeDao(Connection con, int moduleId) {
        super(con, moduleId, VOICE_GEOCODE_TABLENAME);
        this.codeDestTableName = this.getTableName(VOICE_CODE_DESTINATION_TABLENAME, moduleId, null);
    }

    protected VoiceGeographicCode getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRSImpl(rs, "");
    }

    private VoiceGeographicCode getFromRSImpl(ResultSet rs, String prefix) throws SQLException {
        return VoiceGeographicCode.builder().setId(rs.getInt(prefix + "id")).setCode(rs.getString(prefix + "code")).setOperatorId(rs.getInt(prefix + "operatorId")).setDateFrom(null).setDateTo(null).build();
    }

    protected VoiceGeographicCode getFromRSWithDestination(ResultSet rs) throws SQLException {
        VoiceGeographicCode result = this.getFromRSImpl(rs, "geocode.");
        this.setDestination(result, rs);
        return result;
    }

    private void setDestination(VoiceGeographicCode code, ResultSet rs) throws SQLException {
        code.setDestinationTitle(rs.getString("dest.title"));
        code.setDestinationId(rs.getInt("codeDest.destinationId"));
    }

    public List<VoiceGeographicCode> getVoiceGeographicCodeByDestinationId(int destinationId) throws BGException {
        ArrayList<VoiceGeographicCode> list = new ArrayList<VoiceGeographicCode>();
        String querySelect = "SELECT * FROM " + this.codeDestTableName + " codeDest  LEFT JOIN " + this.tableName + " geocode ON geocode.id=codeDest.codeId WHERE `destinationId`=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);){
            psSelect.setInt(1, destinationId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    public Map<Integer, Integer> getDestinationLinkCountMap(Set<Integer> destionationIds) throws SQLException {
        HashMap<Integer, Integer> links = new HashMap<Integer, Integer>();
        String query = "SELECT `destinationId`, COUNT(*) FROM " + this.codeDestTableName + (String)(destionationIds != null && !destionationIds.isEmpty() ? " WHERE `destinationId` IN ( " + Utils.toString(destionationIds) + " ) " : "") + " GROUP BY `destinationId`";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                links.put(rs.getInt(1), rs.getInt(2));
            }
        }
        return links;
    }

    public int getId(String code, int operatorId) throws SQLException {
        String query = "SELECT id FROM " + this.tableName + " WHERE code=? ";
        query = operatorId > 0 ? query + " AND operatorId=?" : query + " AND operatorId IS NULL";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, code);
            if (operatorId > 0) {
                ps.setInt(index++, operatorId);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
            }
        }
        return -1;
    }

    protected void updateImpl(VoiceGeographicCode voiceGeographicCode) throws SQLException {
        String querySet = "code=?, operatorId=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)voiceGeographicCode, querySet);){
            int index = 1;
            ps.setString(index++, voiceGeographicCode.getCode());
            if (voiceGeographicCode.getOperatorId() > 0) {
                ps.setInt(index++, voiceGeographicCode.getOperatorId());
            } else {
                ps.setNull(index++, 4);
            }
            this.executeUpdate((Id)voiceGeographicCode, index, ps);
        }
        this.updateLink(voiceGeographicCode);
    }

    private void updateLink(VoiceGeographicCode voiceGeographicCode) throws SQLException {
        Objects.requireNonNull(voiceGeographicCode);
        String query = "DELETE FROM " + this.codeDestTableName + " WHERE codeId=" + voiceGeographicCode.getId();
        try (Statement st = this.con.createStatement();){
            st.execute(query);
        }
        query = "INSERT INTO " + this.codeDestTableName + " SET codeId=?, destinationId=?, dateFrom=?, dateTo=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, voiceGeographicCode.getId());
            ps.setInt(index++, voiceGeographicCode.getDestinationId());
            ps.setDate(index++, null);
            ps.setDate(index++, null);
            ps.executeUpdate();
        }
    }

    public List<VoiceGeographicCode> list(int codeId, int operatorId) throws SQLException {
        return this.list(null, codeId, operatorId);
    }

    private List<VoiceGeographicCode> list(String code, int codeId, int operatorId) throws SQLException {
        ArrayList<VoiceGeographicCode> result = new ArrayList<VoiceGeographicCode>();
        String destinationTableName = this.getTableName("voice_destination", this.moduleId, null);
        String query = "SELECT codeId, destinationId, dateFrom, dateTo, geocode.*, dest.title FROM " + this.codeDestTableName + " codeDest LEFT JOIN " + this.tableName + " geocode ON geocode.id=codeDest.codeId LEFT JOIN " + destinationTableName + " dest ON dest.id=codeDest.destinationId WHERE 1=1";
        if (codeId > 0) {
            query = query + " AND codeDest.codeId=" + codeId;
        }
        if (!Utils.isEmptyString((String)code)) {
            query = query + " AND geocode.code=" + code;
        }
        query = query + " AND geocode.operatorId" + (String)(operatorId > 0 ? "=" + operatorId : " IS NULL");
        query = query + " ORDER BY code";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getFromRSWithDestination(rs));
            }
        }
        return result;
    }

    public Map<String, List<VoiceGeographicCode>> codeMap(String code, int operatorId) throws SQLException {
        List<Object> list;
        HashMap<String, List<VoiceGeographicCode>> result = new HashMap<String, List<VoiceGeographicCode>>();
        for (VoiceGeographicCode item : this.list(code, -1, operatorId)) {
            list = (ArrayList<VoiceGeographicCode>)result.get(item.getCode());
            if (list == null) {
                list = new ArrayList<VoiceGeographicCode>();
                result.put(item.getCode(), list);
            }
            list.add(item);
        }
        for (String key : result.keySet()) {
            list = (List)result.get(key);
            list = VoiceCommonUtils.getDateSortedNormalizeList(list);
            result.put(key, list);
        }
        return result;
    }

    public VoiceGeographicCode get(String code, int codeId, int operatorId) throws SQLException {
        boolean correct = false;
        VoiceGeographicCode result = null;
        String query = "SELECT * FROM " + this.codeDestTableName + " codeDest LEFT JOIN " + this.tableName + " geocode ON geocode.id=codeDest.codeId WHERE 1=1 ";
        if (Utils.notBlankString((String)code)) {
            query = query + " AND geocode.code=?";
            correct = true;
        } else if (codeId > 0) {
            query = query + " AND geocode.id=" + codeId;
            correct = true;
        }
        if (!correct) {
            return result;
        }
        query = query + " AND geocode.operatorId" + (String)(operatorId > 0 ? "=" + operatorId : " IS NULL");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            if (Utils.notBlankString((String)code)) {
                ps.setString(index++, code);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRSWithDestination(rs);
                }
            }
        }
        return result;
    }

    public int delete(List<Integer> codes) throws SQLException {
        int result;
        block15: {
            result = -1;
            if (codes.size() == 0) {
                return 0;
            }
            try (PreparedStatement linkPs = this.con.prepareStatement("DELETE FROM " + this.codeDestTableName + " WHERE codeId IN (" + Utils.toString(codes) + ") ");
                 PreparedStatement codePs = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id IN (" + Utils.toString(codes) + ") ");){
                linkPs.executeUpdate();
                result = codePs.executeUpdate();
            }
            catch (SQLException e) {
                int errorCode = e.getErrorCode();
                if (errorCode != 1451) break block15;
                throw new BGRuntimeException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0434\u0438\u043d \u0438\u0437 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043e\u0434\u043e\u0432, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u043e\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u043a\u0430\u0440\u0442\u0430\u0445 \u0446\u0435\u043d/\u043a\u0430\u0440\u0442\u0430\u0445 \u0437\u043e\u043d!");
            }
        }
        return result;
    }

    public void update(VoiceGeographicCode voiceGeographicCode) throws SQLException {
        super.update((Object)voiceGeographicCode);
    }

    public void replaceDestination(int sourceDestinationId, int targetDestinationId) throws SQLException {
        String queryUpdate = "UPDATE " + this.codeDestTableName + " SET destinationId=? WHERE destinationId=?";
        try (PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            psUpdate.setInt(1, targetDestinationId);
            psUpdate.setInt(2, sourceDestinationId);
            psUpdate.executeUpdate();
        }
    }
}

