/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.modules.dba.client.ConfigureTreeNode;
import ru.bitel.bgbilling.modules.dba.client.ServiceConfigConfigure;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class ConfigureTree {
    private JTree viewableTree;
    private ServiceConfigConfigure panel;
    private ConfigureTreeNode rootNode;

    public ConfigureTree(ServiceConfigConfigure servicePanel) {
        this.panel = servicePanel;
        this.rootNode = new ConfigureTreeNode(this);
        this.rootNode.setType(1);
        this.viewableTree = new JTree(this.rootNode);
        ConfigureTreeRenderer renderer = new ConfigureTreeRenderer();
        this.viewableTree.setCellRenderer(renderer);
        this.viewableTree.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.viewableTree.setRowHeight(20);
        ActionListener al = e -> this.panel.editItem();
        JMenuItem editItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        editItem.setActionCommand("editItem");
        editItem.addActionListener(al);
        JPopupMenu menu = new JPopupMenu();
        menu.add(editItem);
        BGSwingUtilites.handleMouseClicked((Component)this.viewableTree, e -> this.tableMouseClicked(menu, (MouseEvent)e));
    }

    private void tableMouseClicked(JPopupMenu menu, MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            this.viewableTree.setSelectionPath(this.viewableTree.getPathForLocation(event.getX(), event.getY()));
            ConfigureTreeNode selectedNode = (ConfigureTreeNode)this.viewableTree.getLastSelectedPathComponent();
            if (selectedNode != null && selectedNode.getType() == 4) {
                menu.show(this.viewableTree, event.getX(), event.getY());
            }
        }
    }

    public ConfigureTreeNode getRootNode() {
        return this.rootNode;
    }

    public JTree getViewableTree() {
        return this.viewableTree;
    }

    public void loadTree(Document doc) throws Exception {
        this.rootNode.removeAllChildren();
        Element tableRef = XMLUtils.getElement((Document)doc, (String)"table_ref");
        this.rootNode.setRef(tableRef);
        Element tableConf = XMLUtils.getElement((Document)doc, (String)"table_conf");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        NodeList itemList = tableConf.getElementsByTagName("item");
        int size = itemList.getLength();
        for (int i = 0; i < size; ++i) {
            Element item = (Element)itemList.item(i);
            String key = item.getAttribute("mid") + "_" + item.getAttribute("tid");
            String data = item.getAttribute("data");
            dataMap.put(key, data);
        }
        this.rootNode.setConfigMap(dataMap);
        this.rootNode.loadNode();
        this.viewableTree.expandPath(new TreePath(this.rootNode.getPath()));
    }

    public ConfigureTreeNode getSelectedNode() {
        ConfigureTreeNode result = null;
        TreePath path = this.viewableTree.getSelectionPath();
        if (path != null) {
            result = (ConfigureTreeNode)path.getLastPathComponent();
        }
        return result;
    }

    private static class ConfigureTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final Color selectionColor = Color.red;

        private ConfigureTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel comp = new JLabel("...");
            if (value instanceof ConfigureTreeNode) {
                ConfigureTreeNode node = (ConfigureTreeNode)value;
                comp = node.getView();
                ((Component)comp).setForeground(Color.black);
            }
            if (selected) {
                ((Component)comp).setForeground(selectionColor);
            }
            comp.repaint();
            return comp;
        }
    }
}

