/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.common.io.DatagramChannelListener;
import ru.bitel.common.logging.BGNestedContext;

public abstract class FlowListener
extends DatagramChannelListener {
    private final int socketRCVBUF;
    private final String nestedContext;
    private volatile boolean directMemory = true;

    public FlowListener(String host, int port, int byteBufferCapacity, int socketRCVBUF, String nestedContext) {
        super(host, port, byteBufferCapacity, 0);
        this.socketRCVBUF = socketRCVBUF;
        this.nestedContext = nestedContext;
    }

    public FlowListener(int port, int byteBufferCapacity, int socketRCVBUF, String nestedContext) {
        super(port, byteBufferCapacity);
        this.socketRCVBUF = socketRCVBUF;
        this.nestedContext = nestedContext;
    }

    @Override
    public void init() {
        try {
            if (this.socketRCVBUF > 1024) {
                this.channel.socket().setReceiveBufferSize(this.socketRCVBUF);
            }
            super.init();
            this.channel.socket().setBroadcast(false);
        }
        catch (SocketException e) {
            throw new RuntimeException("Error init SocketListener on port=" + this.port, e);
        }
    }

    @Override
    public void run() {
        if (this.nestedContext != null) {
            BGNestedContext.push(this.nestedContext);
        }
        if (!this.inited) {
            throw new IllegalStateException("ChannelListener not inited");
        }
        ArrayList<FlowPacket> packetList = new ArrayList<FlowPacket>(100);
        while (true) {
            try {
                while (true) {
                    int n;
                    if ((n = this.selector.select(10L)) > 0) {
                        Set<SelectionKey> keys = this.selector.selectedKeys();
                        Iterator<SelectionKey> iter = keys.iterator();
                        while (iter.hasNext()) {
                            SelectionKey key = iter.next();
                            iter.remove();
                            SelectableChannel c = key.channel();
                            if (!key.isReadable() || c != this.channel) continue;
                            if (this.directByteBuffer.capacity() - this.directByteBuffer.position() < this.maxPacketSize) {
                                if (this.directMemory) {
                                    try {
                                        this.directByteBuffer = ByteBuffer.allocateDirect(this.byteBufferCapacity);
                                    }
                                    catch (OutOfMemoryError oom) {
                                        this.directMemory = false;
                                        this.getLogger().error(oom.getMessage(), (Throwable)oom);
                                        this.directByteBuffer = ByteBuffer.allocate(this.byteBufferCapacity);
                                    }
                                } else {
                                    this.directByteBuffer = ByteBuffer.allocate(this.byteBufferCapacity);
                                }
                            }
                            this.directByteBuffer.mark();
                            SocketAddress clientAddress = this.channel.receive(this.directByteBuffer);
                            if (clientAddress == null) continue;
                            this.directByteBuffer.limit(this.directByteBuffer.position());
                            this.directByteBuffer.reset();
                            ByteBuffer buffer = this.directByteBuffer.slice();
                            this.directByteBuffer.position(this.directByteBuffer.limit());
                            this.directByteBuffer.limit(this.directByteBuffer.capacity());
                            packetList.add(new FlowPacket(clientAddress, buffer));
                        }
                        if (packetList.size() < 100) continue;
                        this.flush(System.currentTimeMillis(), packetList);
                        packetList = new ArrayList(100);
                        continue;
                    }
                    if (packetList.size() <= 0) continue;
                    this.flush(System.currentTimeMillis(), packetList);
                    packetList = new ArrayList(100);
                }
            }
            catch (ClosedSelectorException e) {
                this.getLogger().info(this.getClass().getSimpleName() + " shutdown.");
                return;
            }
            catch (Exception e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    public abstract void flush(long var1, List<FlowPacket> var3);

    public Thread startListener() {
        if (!this.inited) {
            throw new IllegalStateException("ChannelListener not inited");
        }
        Thread result = new Thread((Runnable)this, this.getClass().getSimpleName());
        result.start();
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString()).append(' ').append('[');
        this.toString(result);
        result.append(']');
        return result.toString();
    }

    protected void toString(StringBuilder result) {
        DecimalFormat df = new DecimalFormat("###,###,###,###");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        df.setDecimalFormatSymbols(dfs);
        result.append("recv_socket_buf_size: ");
        try {
            result.append(df.format(this.channel.socket().getReceiveBufferSize()));
        }
        catch (SocketException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        result.append("; recv_buf_size: ").append(df.format(this.byteBufferCapacity));
    }
}

