/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.table;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseTariffGroup;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseTariffGroupPrice;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseTariffRange;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseTariffGroupDao;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseTariffGroupPriceDao;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseTariffRangeDao;
import ru.bitel.common.Utils;

public class TableTariffGroupPrice
extends BGTableInfoBase {
    public TableTariffGroupPrice() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b", (String)"title").setWidth(-1), BGUTableColumn.buildColumnTextLeft((String)"\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d", (String)"tariffRange").setMaxWidth(-1), BGUTableColumn.buildColumnDecimal((String)"\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c (unlim)", (String)"unlimCost").setMaxWidth(200), BGUTableColumn.buildColumnId()};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ArrayList<BGUTableRowData> list = new ArrayList<BGUTableRowData>();
        int productId = Utils.parseInt((String)tableParams.get("productId"));
        if (productId > 0) {
            ServerContext serverContext = (ServerContext)ServerContext.get();
            Connection con = serverContext.getConnection();
            List<LicenseTariffRange> licenseTariffRanges = new LicenseTariffRangeDao(con, moduleId).list();
            List<LicenseTariffGroup> licenseTariffGroups = new LicenseTariffGroupDao(con, moduleId).list();
            List<LicenseTariffGroupPrice> tariffGroupPrices = new LicenseTariffGroupPriceDao(con, moduleId).list(productId);
            for (LicenseTariffGroup tariffGroup : licenseTariffGroups) {
                LicenseTariffGroupPrice tariffGroupPrice = tariffGroupPrices.stream().filter(a -> a.getTariffGroupId() == tariffGroup.getId()).findFirst().orElse(new LicenseTariffGroupPrice(0).setProductId(productId).setTariffGroupId(tariffGroup.getId()));
                String tariffRange = licenseTariffRanges.stream().filter(a -> a.getId() == tariffGroupPrice.getTariffRangeId()).findFirst().map(a -> a.getTitle()).orElse("??? [ID#" + tariffGroupPrice.getTariffRangeId() + "]");
                BGUTableRowData rowData = new BGUTableRowData().addValue("title", tariffGroup.getTitle()).addValue("tariffRange", tariffRange).addValue("unlimCost", tariffGroupPrice.getUnlimCost().toPlainString()).addValue(this.getId(tariffGroupPrice.getId()));
                list.add(rowData);
            }
        }
        return list;
    }
}

