/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLHistoryList;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.HistoryKeepPeriodType;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.SqlHistoryRequest;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.SqlHistoryUserConfig;
import ru.bitel.bgbilling.plugins.sqleditor.common.service.SqlHistoryService;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.SearchResult;

public class SQLHistoryPanel
extends JPanel {
    private SqlHistoryService sqlHistoryService;
    private SQLHistoryList sqlList;
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages panelPages = new BGControlPanelPages();
    private HistoryConfiguratePanel historyConfiguratePanel;

    public SQLHistoryPanel(ClientContext clientContext, SQLHistoryList sqlList) throws BGException {
        this.setLayout(new GridBagLayout());
        this.panelPages.init();
        this.sqlList = sqlList;
        this.sqlHistoryService = (SqlHistoryService)clientContext.getPort(SqlHistoryService.class);
        this.historyConfiguratePanel = new HistoryConfiguratePanel(this.sqlHistoryService.getHistoryUserConfig());
        this.add((Component)this.historyConfiguratePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 5, 0, 5), 0, 0));
        this.add((Component)this.recordCountLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.panelPages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.sqlList), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 5, 0, 5), 0, 0));
        this.panelPages.addToHandler(a -> this.reloadList());
        this.reloadList();
    }

    public void saveHistoryRequest(SqlHistoryRequest historyRequest) {
        try {
            SqlHistoryUserConfig sqlHistoryUserConfig = this.sqlHistoryService.getHistoryUserConfig();
            if (sqlHistoryUserConfig != null && sqlHistoryUserConfig.isSaveInDatabase()) {
                this.sqlHistoryService.updateSqlHistoryRequest(historyRequest);
            }
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    public void reloadList() {
        try {
            SearchResult searchResult = this.sqlHistoryService.getUserRequestList(this.panelPages.getPage());
            List requestList = searchResult.getList();
            this.panelPages.setPage(searchResult.getPage());
            this.sqlList.setData(requestList);
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public SqlHistoryService getSqlHistoryService() {
        return this.sqlHistoryService;
    }

    private final class HistoryConfiguratePanel
    extends JPanel {
        JCheckBox saveHistoryForUser;
        JRadioButton keepAllTime = new JRadioButton("\u0432\u0441\u0451 \u0432\u0440\u0435\u043c\u044f");
        JRadioButton keepOneWeek = new JRadioButton("\u043d\u0435\u0434\u0435\u043b\u044e");
        JRadioButton keepOneMonth = new JRadioButton("\u043c\u0435\u0441\u044f\u0446");
        SqlHistoryUserConfig historyUserConfig;
        List<JRadioButton> keepButtons = List.of(this.keepAllTime, this.keepOneMonth, this.keepOneWeek);
        ActionListener updateHistoryUserConfig = e -> {
            if (this.historyUserConfig == null) {
                this.historyUserConfig = new SqlHistoryUserConfig();
            }
            Object source = e.getSource();
            if (this.saveHistoryForUser.isSelected()) {
                this.historyUserConfig.setSaveInDatabase(true);
                if (source instanceof JCheckBox) {
                    this.keepAllTime.setSelected(true);
                    this.keepOneMonth.setSelected(false);
                    this.keepOneWeek.setSelected(false);
                } else if (source instanceof JRadioButton) {
                    this.keepButtons.forEach(b -> b.setSelected(source == b));
                }
            } else {
                this.historyUserConfig.setSaveInDatabase(false);
                this.keepButtons.forEach(b -> b.setSelected(false));
            }
            if (this.keepAllTime.isSelected()) {
                this.historyUserConfig.setKeepPeriod(HistoryKeepPeriodType.ALL_TIME);
            } else if (this.keepOneMonth.isSelected()) {
                this.historyUserConfig.setKeepPeriod(HistoryKeepPeriodType.MONTH);
            } else if (this.keepOneWeek.isSelected()) {
                this.historyUserConfig.setKeepPeriod(HistoryKeepPeriodType.WEEK);
            } else {
                this.historyUserConfig.setKeepPeriod(null);
            }
            try {
                SQLHistoryPanel.this.sqlHistoryService.updateHistoryUserConfig(this.historyUserConfig);
                this.historyUserConfig = SQLHistoryPanel.this.sqlHistoryService.getHistoryUserConfig();
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        };

        HistoryConfiguratePanel(SqlHistoryUserConfig historyUserConfig) {
            this.historyUserConfig = historyUserConfig;
            SQLHistoryPanel.this.panelPages.init();
            this.setLayout(new GridBagLayout());
            BGSwingUtilites.wrapEmptyBorder((JComponent)this);
            this.saveHistoryForUser = new JCheckBox("\u0425\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e \u0432 \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445: ");
            this.saveHistoryForUser.addChangeListener(changeEvent -> this.setEnabledRadioButtons(this.saveHistoryForUser.isSelected()));
            List.of(this.saveHistoryForUser, this.keepAllTime, this.keepOneMonth, this.keepOneWeek).forEach(btn -> btn.addActionListener(this.updateHistoryUserConfig));
            GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)this.saveHistoryForUser, constraints);
            this.add((Component)this.keepAllTime, constraints);
            this.add((Component)this.keepOneMonth, constraints);
            this.add((Component)this.keepOneWeek, constraints);
            this.init();
        }

        private void init() {
            boolean isSaveInDatabase = this.historyUserConfig != null ? this.historyUserConfig.isSaveInDatabase() : false;
            this.saveHistoryForUser.setSelected(isSaveInDatabase);
            this.setEnabledRadioButtons(isSaveInDatabase);
            if (isSaveInDatabase && this.historyUserConfig != null) {
                switch (this.historyUserConfig.getKeepPeriod()) {
                    case ALL_TIME: {
                        this.keepAllTime.setSelected(true);
                        break;
                    }
                    case MONTH: {
                        this.keepOneMonth.setSelected(true);
                        break;
                    }
                    case WEEK: {
                        this.keepOneWeek.setSelected(true);
                    }
                }
            } else {
                this.keepAllTime.setSelected(false);
                this.keepOneMonth.setSelected(false);
                this.keepOneWeek.setSelected(false);
            }
        }

        private void setEnabledRadioButtons(boolean isSelected) {
            this.keepAllTime.setEnabled(isSelected);
            this.keepOneMonth.setEnabled(isSelected);
            this.keepOneWeek.setEnabled(isSelected);
        }
    }
}

