/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLink;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLinkBlock;
import ru.bitel.bgbilling.modules.bill.common.bean.link.BillLinkBlockType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;

public class BillLinkDao
extends AbstractDao<BillLink> {
    public BillLinkDao(Connection con, int moduleId) {
        super(con, "bill_link", moduleId);
    }

    public List<BillLink> list() throws BGException {
        return this.list(null, "title", new Object[0]);
    }

    public BillLink get(int id) throws BGException {
        return (BillLink)this.get("id=?", new Object[]{id});
    }

    protected BillLink getFromRS(ResultSet rs) throws SQLException, BGException {
        BillLink billLink = new BillLink();
        billLink.setId(rs.getInt("id"));
        billLink.setTitle(rs.getString("title"));
        billLink.setUserId(rs.getInt("user_id"));
        billLink.setLastModified((Date)rs.getTimestamp("lm"));
        billLink.setData(rs.getString("data"));
        this.parseData(billLink);
        return billLink;
    }

    protected void updateImpl(BillLink billLink) throws BGException, SQLException {
        if (billLink != null) {
            boolean update = billLink.getId() > 0;
            String query = new StringBuffer(update ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET title=?, user_id=?, data=?").append(update ? " WHERE id=?" : "").toString();
            int index = 1;
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                ps.setString(index++, billLink.getTitle());
                ps.setInt(index++, billLink.getUserId());
                ps.setString(index++, this.getData(billLink));
                if (update) {
                    ps.setInt(index++, billLink.getId());
                }
                ps.executeUpdate();
                if (!update) {
                    billLink.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
            }
        }
    }

    private String getData(BillLink billLink) {
        StringBuffer data = new StringBuffer();
        if (billLink != null) {
            JSONObject dataJsonObject = new JSONObject();
            JSONArray blocks = new JSONArray();
            for (BillLinkBlock billLinkBlock : billLink.getLinkBlocks()) {
                blocks.put((Object)new JSONObject((Object)billLinkBlock));
            }
            dataJsonObject.put("blocks", (Object)blocks);
            data.append(dataJsonObject.toString(2));
        }
        return data.toString();
    }

    private void parseData(BillLink billLink) {
        JSONObject dataJsonObject;
        JSONArray blocks;
        if (billLink != null && !billLink.getData().isEmpty() && (blocks = (dataJsonObject = new JSONObject(billLink.getData())).optJSONArray("blocks")) != null) {
            for (int index = 0; index < blocks.length(); ++index) {
                JSONObject jsonObject = blocks.getJSONObject(index);
                BillLinkBlock billLinkBlock = new BillLinkBlock();
                billLinkBlock.setKey(jsonObject.optString("key"));
                billLinkBlock.setTitle(jsonObject.optString("title"));
                billLinkBlock.setData(jsonObject.optString("data"));
                billLinkBlock.setType(BillLinkBlockType.valueOf((String)jsonObject.optString("type")));
                JSONArray properties = jsonObject.optJSONArray("billLinkProperties");
                if (properties != null) {
                    // empty if block
                }
                billLink.getLinkBlocks().add(billLinkBlock);
            }
        }
    }
}

