/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.task;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.StatusEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.StatusEventManager;

public class Locker
extends TaskBase {
    private int forgiveHours;

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Cerbercrypt. \u0417\u0430\u0434\u0430\u0447\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0434\u043e\u043b\u0436\u043d\u0438\u043a\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    protected boolean initTask() {
        boolean result = true;
        this.forgiveHours = this.taskSetup.getInt("forgive.hours", 2);
        return result;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection conSlave = this.setup.getDBSlaveConnectionFromPool();){
            this.getLogger().info("Forgive hours = " + this.forgiveHours + "; mid = " + this.moduleId);
            this.getLogger().info("Lock updating...");
            this.updateBalanceLocks(con, conSlave, this.getOperatingTime());
        }
        catch (Exception e) {
            this.getLogger().error("error Locker task", (Throwable)e);
            this.error = e;
        }
    }

    private void updateBalanceLocks(Connection con, Connection conSlave, Calendar time) throws SQLException, BGException {
        CardPacketManager cardPacketManager = new CardPacketManager(conSlave, this.moduleId);
        List<CardPacket> cardPacketList = cardPacketManager.getActiveCardPacketList(time, (Integer)null);
        StatusEventManager eventManager = new StatusEventManager(con, this.moduleId);
        Map<Integer, Packet> packetMap = new PacketManager(conSlave, this.moduleId).getPacketMap();
        StatusEvent lockEvent = new StatusEvent().setStatus(2).setUserId(0);
        if (time.get(11) <= this.forgiveHours) {
            lockEvent.setTime(time);
            this.getLogger().debug("Locking by current day...");
        } else {
            Calendar nextDay = (Calendar)time.clone();
            nextDay.add(6, 1);
            lockEvent.setTime(nextDay);
            this.getLogger().debug("Locking by next day...");
        }
        BalanceUtils bu = new BalanceUtils(conSlave);
        for (CardPacket cardPacket : cardPacketList) {
            boolean active;
            Contract contract = ContractDao.getContract((Connection)conSlave, (int)cardPacket.getContractId());
            if (contract == null) {
                this.getLogger().error("Contract not found for " + cardPacket.toString());
                continue;
            }
            Packet packet = packetMap.get(cardPacket.getPacketId());
            if (packet == null) {
                this.getLogger().error("Packet not found for " + cardPacket.toString());
                continue;
            }
            if (packet.isVirtualCinema()) {
                this.getLogger().debug("Skip virtualcinema-packet cardpacket on contract " + contract.getId() + " [" + contract.getTitle() + "]; " + cardPacket.toString());
                continue;
            }
            if (packet.getFree()) {
                this.getLogger().debug("Skip free-packet cardpacket on contract " + contract.getId() + " [" + contract.getTitle() + "]; " + cardPacket.toString());
                continue;
            }
            BigDecimal rest = bu.getBalance(time.getTime(), cardPacket.getContractId());
            boolean bl = active = rest.compareTo(contract.getBalanceLimit()) >= 0;
            if (!active && cardPacket.getStatus() == 1) {
                this.getLogger().info("Lock cardpacket on contract " + contract.getId() + " [" + contract.getTitle() + "]; balance=" + String.valueOf(rest) + "; limit=" + String.valueOf(contract.getBalanceLimit()) + "; " + cardPacket.toString() + "...");
                lockEvent.setCardPacketId(cardPacket.getId());
                eventManager.addEvent(cardPacket, lockEvent);
                continue;
            }
            this.getLogger().debug("Skip cardpacket on contract " + contract.getId() + " [" + contract.getTitle() + "]; balance=" + String.valueOf(rest) + "; limit=" + String.valueOf(contract.getBalanceLimit()) + "; " + cardPacket.toString());
        }
        bu.close();
    }

    public List<TaskParameter> taskParameters() {
        ArrayList<TaskParameter> taskParameters = new ArrayList<TaskParameter>();
        taskParameters.add(new TaskParameter().setKey("forgive.hours").setTitle("forgive.hours").setDefaultValue("2"));
        return taskParameters;
    }
}

