/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.email.server.bean.Forward;

public class ForwardManager
extends AbstarctDaoConstant {
    public ForwardManager(Connection con, int moduleId) {
        super(con, "email_forward", moduleId);
    }

    public int getForwardCount(int accountID) {
        int result = 0;
        String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE aid=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, accountID);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Forward> getForwardList(int accountID) {
        ArrayList<Forward> result = new ArrayList<Forward>();
        try {
            Forward forward = null;
            String query = "SELECT * FROM " + this.tableName + " WHERE aid=? ORDER BY email";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, accountID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                forward = new Forward();
                this.loadForwardFromRS(forward, rs);
                result.add(forward);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updateForwardList(int accountID, List<Forward> forwardList) {
        String query = "DELETE FROM " + this.tableName + " WHERE aid=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, accountID);
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO " + this.tableName + " ( aid, email ) VALUES (?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, accountID);
            for (Forward forward : forwardList) {
                ps.setString(2, forward.getEmail());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadForwardFromRS(Forward forward, ResultSet rs) throws SQLException {
        forward.setAccountId(rs.getInt("aid"));
        forward.setEmail(rs.getString("email"));
    }
}

