/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.event.Level;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionLog;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionAutoRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.ip.HourlyAutoConnectionSet;
import ru.bitel.bgbilling.apps.inet.accounting.ip.HourlyCallConnectionSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuleRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceInterfaceIndexDao;

public class FlowAgentInterface
extends BGLogger {
    private final Accounting accounting;
    public final int agentDeviceId;
    public final int iface;
    public volatile Set<Integer> deviceIds;
    public volatile List<DeviceInterfaceIndexDao.DeviceInterfaceIndexItem> ifaceIndexList;
    public HourlyCallConnectionSet sessionSetCall;
    public HourlyAutoConnectionSet sessionSetAuto;
    private final long lockTimeout;

    public FlowAgentInterface(Accounting accounting, int agentDeviceId, InetDeviceRuntime device, int iface, List<Integer> deviceIds) throws BGException {
        this.accounting = accounting;
        this.agentDeviceId = agentDeviceId;
        this.iface = iface;
        this.sessionSetCall = new HourlyCallConnectionSet(accounting, this);
        this.sessionSetAuto = new HourlyAutoConnectionSet(accounting, this);
        this.lockTimeout = device.config.getLong("flow.serv.lockTimeout", device.config.getLong("serv.lockTimeout", 20L));
        this.load(deviceIds);
    }

    public void load(List<Integer> deviceIds) throws BGException {
        this.deviceIds = new HashSet<Integer>(deviceIds);
    }

    public InetConnectionRuntime getConnection(IpAddress address, int direction, Long hour, long millis) {
        InetConnectionRuntime connectionRuntime = this.sessionSetCall.getSession(address, hour, millis, this.lockTimeout);
        if (connectionRuntime == null) {
            connectionRuntime = this.sessionSetAuto.getSession(address, hour);
            if (connectionRuntime != null) {
                try {
                    connectionRuntime.inetServRuntime.tryLockEx(this.lockTimeout, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                if (connectionRuntime.connection == null) {
                    try {
                        InetServTypeRuntime servTypeRuntime = connectionRuntime.inetServRuntime.getInetServTypeRuntime();
                        switch (direction) {
                            case 2: {
                                if (!servTypeRuntime.flowActiveFilterIn) break;
                                connectionRuntime.inetServRuntime.unlock();
                                return null;
                            }
                            case 1: {
                                if (!servTypeRuntime.flowActiveFilterOut) break;
                                connectionRuntime.inetServRuntime.unlock();
                                return null;
                            }
                        }
                        this.accounting.connectionAutoStart((InetConnectionAutoRuntime)connectionRuntime, millis);
                    }
                    catch (Exception ex) {
                        connectionRuntime.inetServRuntime.unlock();
                        this.logError(ex);
                        return null;
                    }
                }
            } else {
                return null;
            }
        }
        return connectionRuntime;
    }

    public InetConnectionRuntime getConnectionWithTimeout(IpAddress address, Long hour, long millis) {
        InetConnectionRuntime connectionRuntime = this.sessionSetCall.getSessionWithTimeout(address, hour, millis);
        return connectionRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processFlow(Data flow, Long hour, long millis, IpAddress srcAddress, int direction, int iface, IpAddress dstAddress, int port, int diffServ, long octets, boolean runtime) {
        InetConnectionRuntime connectionRuntime = runtime ? this.getConnection(srcAddress, direction, hour, millis) : this.getConnectionWithTimeout(srcAddress, hour, millis);
        if (connectionRuntime == null) {
            return false;
        }
        try {
            InetServ rootInetServ;
            int inetServInterfaceId;
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Found session " + connectionRuntime.sessionId + " for direction: " + direction);
            }
            if (runtime && connectionRuntime.trySplitSession(this.accounting, hour, millis)) {
                ConnectionSet connectionSet = ((DefaultContext)ThreadContext.get(DefaultContext.class)).getConnectionSet();
                connectionSet.commit();
            }
            InetServTypeRuntime inetServType = connectionRuntime.inetServRuntime.inetServTypeRef.get();
            AtomicReference<TrafficTypeLinkRuntime> trafficTypeLinkRef = inetServType.trafficTypeLinkRuntimeRef;
            if (trafficTypeLinkRef == null) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("TrafficType for inetServType:" + inetServType.inetServType.getId() + " not set.");
                }
                boolean bl = false;
                return bl;
            }
            TrafficTypeLinkRuntime trafficTypeLink = trafficTypeLinkRef.get();
            TrafficTypeLinkRuleRuntime rule = trafficTypeLink.getRule(this.agentDeviceId, direction, iface, dstAddress, port, diffServ, millis, inetServInterfaceId = this.agentDeviceId == (rootInetServ = connectionRuntime.inetServRuntime.getRootInetServRuntime(this.accounting).getInetServ()).getDeviceId() ? rootInetServ.getInterfaceId() : -1);
            if (rule == null) {
                ConnectionLog.log(connectionRuntime, Level.WARN, "TrafficType not found for " + direction + " " + String.valueOf(flow));
                boolean bl = false;
                return bl;
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Found trafficType " + rule.trafficTypeId);
            }
            connectionRuntime.addTraffic(this.agentDeviceId, hour, rule.trafficTypeId, octets);
            if (runtime) {
                this.updateTime(inetServType, connectionRuntime, direction, millis);
            }
        }
        catch (BGException ex) {
            this.logError(ex);
        }
        finally {
            connectionRuntime.inetServRuntime.unlock();
        }
        return true;
    }

    private void updateTime(InetServTypeRuntime inetServType, InetConnectionRuntime connectionRuntime, int direction, long millis) {
        switch (direction) {
            case 2: {
                if (!inetServType.flowActiveFilterIn) break;
                return;
            }
            case 1: {
                if (!inetServType.flowActiveFilterOut) break;
                return;
            }
        }
        long lastFlowTime = millis / 1000L;
        if (connectionRuntime.lastFlowTime < lastFlowTime) {
            connectionRuntime.lastFlowTime = lastFlowTime;
            connectionRuntime.updateTime(millis);
        }
    }

    public String toString() {
        return this.agentDeviceId + "-" + this.iface;
    }
}

