/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAccountingPeriod;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestriction;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaOptionsModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAccountingPeriodDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetAccountingPeriodActivateEvent;
import ru.bitel.bgbilling.modules.inet.server.event.InetAccountingPeriodModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetAccountingPeriodList;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServOptionList;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.restriction.InetServRestrictionAccountRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.restriction.InetServRestrictionRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.restriction.InetServRestrictionTimeRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.AbstractPeriodItemSet;
import ru.bitel.common.util.SetCache;

public class InetServRuntime {
    private static final Logger logger = LogManager.getLogger();
    public static final SetCache<Integer> DEVICE_OPTIONS_SET_CACHE = new SetCache(128);
    public final Integer inetServId;
    private volatile InetServ inetServ;
    volatile long dateFromMillis;
    volatile long dateToMillis;
    public final AtomicReference<InetServTypeRuntime> inetServTypeRef;
    public final ContractRuntime contractRuntime;
    private volatile TariffModuleTreeSet tariffTreeSet;
    public volatile InetServOptionList inetServOptionsList;
    private volatile InetAccountingPeriodList accountingPeriodList;
    private volatile InetServRestrictionRuntime[] restrictions;
    private static final ParameterMap EMPTY_PARAMETER_MAP = new Preferences();
    private ParameterMap config;
    public Set<Integer> inetOptions;
    public long inetOptionsMillis;
    public volatile int accountingPeriodId = -1;
    public volatile long accountingPeriodMillisFrom;
    public volatile long accountingPeriodMillisTo;
    private volatile List<InetConnectionRuntime> sessions;
    private volatile InetServRuntime parentInetServRuntime;
    volatile ContractStatusList contractSuspendPeriods;

    public InetServRuntime(int inetServId, AtomicReference<InetServTypeRuntime> servTypeRef, ContractRuntime contractRuntime) {
        this.inetServId = inetServId;
        this.inetServTypeRef = servTypeRef;
        this.contractRuntime = contractRuntime;
    }

    public void addSession(InetConnectionRuntime session) {
        assert (this.isHeldByCurrentThread());
        List<InetConnectionRuntime> sessions = this.sessions;
        if (sessions == null) {
            sessions = new ArrayList<InetConnectionRuntime>(1);
            sessions.add(session);
            this.sessions = sessions;
        } else {
            ArrayList<InetConnectionRuntime> newSessions = new ArrayList<InetConnectionRuntime>(sessions.size() + 1);
            newSessions.addAll(sessions);
            newSessions.add(session);
            this.sessions = newSessions;
        }
    }

    public void removeSession(InetConnectionRuntime session) {
        assert (this.isHeldByCurrentThread());
        List<InetConnectionRuntime> sessions = this.sessions;
        ArrayList<InetConnectionRuntime> newSessions = new ArrayList<InetConnectionRuntime>(sessions);
        newSessions.remove((Object)session);
        this.sessions = newSessions.size() == 0 ? null : newSessions;
    }

    public List<InetConnectionRuntime> getConnectionList() {
        List<InetConnectionRuntime> sessions = this.sessions;
        return sessions != null ? sessions : Collections.emptyList();
    }

    public Set<Integer> getOptions(long millis) {
        return this.inetServOptionsList.items(millis);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("ContractId: ");
        result.append(this.getInetServ().getContractId());
        result.append("; status: ");
        result.append(this.contractRuntime.getStatus());
        result.append("; servId: ");
        result.append(this.inetServId);
        result.append("\n\t");
        result.append(String.valueOf(this.getInetServ()));
        result.append("\n\t");
        result.append("Options [");
        for (AbstractPeriodItemSet.PeriodItem option : this.inetServOptionsList.items()) {
            result.append(option.id);
            result.append(":");
            result.append(TimeUtils.formatPeriod((Date)new Date(option.timeFrom), (Date)new Date(option.timeTo)));
            result.append("; ");
        }
        result.append("] ");
        result.append(this.tariffTreeSet);
        result.append("\n\t");
        result.append("Device state: ");
        result.append(this.getInetServ().getDeviceState());
        result.append("; optionSet:");
        result.append(Utils.toString((Iterable)this.getInetServ().getDeviceOptions()));
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInetServ(InetServ inetServ) {
        this.lock();
        try {
            List identifierList;
            InetServ oldInetServ = this.inetServ;
            if (oldInetServ != null) {
                inetServ.setDeviceState(oldInetServ.getDeviceState());
                inetServ.setDeviceOptions(oldInetServ.getDeviceOptions());
            } else {
                inetServ.setDeviceOptions(DEVICE_OPTIONS_SET_CACHE.intern(inetServ.getDeviceOptions()));
            }
            inetServ.setComment(null);
            inetServ.setContractTitle(null);
            inetServ.setContractComment(null);
            inetServ.setDeviceTitle(null);
            inetServ.setInterfaceTitle(null);
            inetServ.setTypeTitle(null);
            inetServ.setAccessCodeTitle(null);
            if ("".equals(inetServ.getLogin())) {
                inetServ.setLogin("");
            }
            if ("".equals(inetServ.getPassword())) {
                inetServ.setPassword("");
            }
            if ((identifierList = inetServ.getIdentifierList()) != null && identifierList != Collections.EMPTY_LIST && identifierList.size() == 0) {
                inetServ.setIdentifierList(Collections.emptyList());
            }
            if ("".equals(inetServ.getConfig())) {
                inetServ.setConfig("");
            }
            this.inetServ = inetServ;
            GregorianCalendar utilCalendar = new GregorianCalendar();
            this.dateFromMillis = InetUtils.dateFrom(inetServ.getDateFrom(), utilCalendar);
            this.dateToMillis = InetUtils.dateTo(inetServ.getDateTo(), utilCalendar);
            String config = inetServ.getConfig();
            this.config = Utils.isBlankString((String)config) ? EMPTY_PARAMETER_MAP : new Preferences(config, "\n");
        }
        finally {
            this.unlock();
        }
    }

    public ParameterMap getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceStateAndOptions(short deviceState, Set<Integer> deviceOptionSet) {
        this.lock();
        try {
            InetServ inetServ = this.inetServ;
            if (deviceState != InetServState.STATE_NULL.getCode()) {
                inetServ.setDeviceState(deviceState);
            }
            if (deviceOptionSet != null) {
                inetServ.setDeviceOptions(DEVICE_OPTIONS_SET_CACHE.intern(deviceOptionSet));
            }
        }
        finally {
            this.unlock();
        }
    }

    public InetServ getInetServ() {
        return this.inetServ;
    }

    protected InetAccountingPeriodList getAccountingPeriodList() {
        return this.accountingPeriodList;
    }

    protected void setAccountingPeriodList(InetAccountingPeriodList accountingPeriodList) {
        this.lock();
        try {
            this.accountingPeriodList = accountingPeriodList;
        }
        finally {
            this.unlock();
        }
    }

    public AbstractPeriodItemSet.PeriodItem getAccountingPeriod(InetApplication inetApplication, ConnectionSet connectionSet, long millis, boolean reload) throws Exception {
        return this.getAccountingPeriod(inetApplication, connectionSet, millis, reload, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractPeriodItemSet.PeriodItem getAccountingPeriod(InetApplication inetApplication, ConnectionSet connectionSet, long millis, boolean reload, boolean[] reloaded) throws Exception {
        InetAccountingPeriodList accountingPeriodList;
        if (logger.isDebugEnabled()) {
            logger.debug("Trying to get accounting period from ServRuntime");
        }
        if ((accountingPeriodList = this.accountingPeriodList) != null && !reload) {
            if (logger.isDebugEnabled()) {
                logger.debug("ServRuntime: accountingPeriodList size = {}", (Object)accountingPeriodList.size());
                Set items = accountingPeriodList.items(millis);
                logger.debug("accounting period ids in accountingPeriodList: {}", (Object)Utils.toString((Iterable)items));
            }
            InetDeviceRuntime inetDeviceRuntime = inetApplication.deviceMap.get(this.getInetServ().getDeviceId());
            boolean isForceReload = inetDeviceRuntime.config.getBoolean("force.accounting.period.reload", false);
            AbstractPeriodItemSet.PeriodItem item = accountingPeriodList.item(millis);
            if (!isForceReload || item != null) {
                return item;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("force realtime reload option (force.accounting.period.reload) is true.");
            }
        }
        this.lock();
        try {
            logger.debug("ServRuntime doesn't contain accounting period. Try to get from database");
            InetAccountingPeriodDao periodDao = new InetAccountingPeriodDao(connectionSet.getConnection(), inetApplication.moduleId, 0);
            Date nowDate = new Date(millis);
            GregorianCalendar utilCalendar = new GregorianCalendar();
            List<InetAccountingPeriod> periodList = periodDao.list(this.contractRuntime.contractId, nowDate);
            if (logger.isDebugEnabled()) {
                logger.debug("database period list size = " + periodList.size());
                periodList.forEach(n -> logger.debug("period item " + String.valueOf(n)));
            }
            accountingPeriodList = InetAccountingPeriodList.newInstance(periodList, utilCalendar);
            this.setAccountingPeriodList(accountingPeriodList);
        }
        finally {
            this.unlock();
        }
        if (reloaded != null) {
            reloaded[0] = true;
        }
        return accountingPeriodList.item(millis);
    }

    private InetAccountingPeriod accountingPeriodActivate(InetApplication inetApplication, Connection con, int contractId, long now) throws Exception {
        this.lock();
        try {
            InetAccountingPeriod period;
            InetAccountingPeriodDao periodDao = new InetAccountingPeriodDao(con, inetApplication.moduleId, 0);
            PreparedStatement ps = con.prepareStatement("SELECT mid FROM contract_module WHERE cid=? AND mid=? FOR UPDATE");
            ps.setInt(1, contractId);
            ps.setInt(2, inetApplication.moduleId);
            ps.executeQuery();
            ps.close();
            Date nowDate = new Date(now);
            Date lastDate = Date.from(ZonedDateTime.now().minusDays(2L).toInstant());
            List<InetAccountingPeriod> list = periodDao.list(contractId, lastDate, true);
            InetAccountingPeriod lastPeriod = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                lastPeriod = list.get(i);
                if (!TimeUtils.timeInRange((Date)nowDate, (Date)lastPeriod.getDateFrom(), (Date)lastPeriod.getDateTo())) continue;
                try {
                    if (!con.getAutoCommit()) {
                        con.commit();
                    }
                }
                catch (SQLException ex) {
                    throw new BGException((Throwable)ex);
                }
                GregorianCalendar utilCalendar = new GregorianCalendar();
                InetAccountingPeriodList accountingPeriodList = this.accountingPeriodList;
                this.accountingPeriodList = accountingPeriodList.update(lastPeriod, utilCalendar);
                InetAccountingPeriod inetAccountingPeriod = lastPeriod;
                return inetAccountingPeriod;
            }
            logger.debug("Accounting period not found. Try to activate new.");
            boolean lightweighCheck = inetApplication instanceof Accounting && AccountingWorker.isPeriodicAccountingWorker();
            InetAccountingPeriodActivateEvent e = new InetAccountingPeriodActivateEvent(inetApplication.moduleId, contractId, 0, lastPeriod, lightweighCheck);
            e = (InetAccountingPeriodActivateEvent)EventProcessor.getInstance().request((Event)e, 2000L);
            if (e == null) {
                throw new BGException("Timeout of processing InetAccountingPeriodActivateEvent!");
            }
            if (logger.isDebugEnabled()) {
                InetAccountingPeriod accountingPeriod = e.getAccountingPeriod();
                logger.debug("Period from InetAccountingPeriodActivateEvent " + (String)(accountingPeriod == null ? " is null" : " is " + String.valueOf(accountingPeriod)));
            }
            GregorianCalendar utilCalendar = new GregorianCalendar();
            if (e.isProcessed()) {
                period = e.getAccountingPeriod();
                if (period == null || period.getDateFrom() == null || period.getDateTo() == null) {
                    InetAccountingPeriod inetAccountingPeriod = null;
                    return inetAccountingPeriod;
                }
                if (!e.isUseSeconds()) {
                    utilCalendar.setTime(period.getDateFrom());
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                    period.setDateFrom(utilCalendar.getTime());
                    utilCalendar.setTime(period.getDateTo());
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                    ((Calendar)utilCalendar).add(5, 1);
                    ((Calendar)utilCalendar).add(14, -1);
                    period.setDateTo(utilCalendar.getTime());
                }
            } else {
                period = new InetAccountingPeriod();
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                if (inetApplication.accountingPeriodActivateFromMonthStart) {
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                    utilCalendar.set(5, 1);
                }
                period.setDateFrom(utilCalendar.getTime());
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                utilCalendar.set(5, 1);
                ((Calendar)utilCalendar).add(2, 1);
                ((Calendar)utilCalendar).add(14, -1);
                period.setDateTo(utilCalendar.getTime());
            }
            if (period.getId() <= 0) {
                period.setContractId(contractId);
                periodDao.update(period);
            }
            try {
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            InetAccountingPeriodList accountingPeriodList = this.accountingPeriodList;
            if (logger.isDebugEnabled()) {
                logger.debug("accountingPeriodActivate:Updating accounting period in ServRuntime");
            }
            this.accountingPeriodList = accountingPeriodList.update(period, utilCalendar);
            inetApplication.accountingPeriodActivatedEP.publish((Event)new InetAccountingPeriodModifiedEvent(inetApplication.accountingPeriodActivatedEP, contractId, 0, null, period));
            InetAccountingPeriod inetAccountingPeriod = period;
            return inetAccountingPeriod;
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.unlock();
        }
    }

    public AbstractPeriodItemSet.PeriodItem accountingPeriodCheck(InetApplication inetApplication, ConnectionSet connectionSet, long millis, boolean reload, boolean activate) throws Exception {
        boolean[] reloaded;
        AbstractPeriodItemSet.PeriodItem result;
        if (logger.isDebugEnabled()) {
            logger.debug("app.id={} => accountingPeriodCheck for inetServId={}", (Object)inetApplication.applicationId, (Object)this.inetServId);
        }
        if ((result = this.getAccountingPeriod(inetApplication, connectionSet, millis, false, reloaded = new boolean[1])) == null && reload && !reloaded[0]) {
            result = this.getAccountingPeriod(inetApplication, connectionSet, millis, true, reloaded);
        }
        if (result == null) {
            boolean realtime = true;
            if (inetApplication instanceof Accounting) {
                realtime = ((Accounting)inetApplication).realtime;
            }
            if (realtime) {
                result = this.getAccountingPeriod(inetApplication, connectionSet, System.currentTimeMillis(), false, null);
            }
        }
        if (result == null && activate) {
            InetServ inetServ = this.getInetServ();
            if (inetServ.getStatus() != InetServStatus.STATUS_ON) {
                logger.info("Acct period: inetServ[id=" + inetServ.getId() + "] status not active (accessCode=" + inetServ.getAccessCode() + ").");
            } else if (!StatusCache.getInstance().isModuleActiveStatus(inetApplication.moduleId, this.contractRuntime.getStatus())) {
                logger.info("Acct period: inetServ[id=" + inetServ.getId() + "] contract status not active.");
            } else {
                InetAccountingPeriod accountingPeriod = this.accountingPeriodActivate(inetApplication, connectionSet.getConnection(), this.contractRuntime.contractId, millis);
                if (accountingPeriod != null) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    result = new AbstractPeriodItemSet.PeriodItem(accountingPeriod.getId(), InetUtils.dateFrom(accountingPeriod.getDateFrom(), calendar), InetUtils.dateTo(accountingPeriod.getDateTo(), calendar));
                } else {
                    logger.debug("Accounting period not found for inetServ:" + this.inetServId);
                }
            }
        }
        if (result != null) {
            this.accountingPeriodId = result.id;
            this.accountingPeriodMillisFrom = result.timeFrom;
            this.accountingPeriodMillisTo = result.timeTo;
        } else {
            this.accountingPeriodId = 0;
            this.accountingPeriodMillisFrom = -1L;
            this.accountingPeriodMillisTo = -1L;
        }
        return result;
    }

    public InetServ getParentInetServ(InetApplication application) {
        return this.getParentInetServRuntime(application).getInetServ();
    }

    public InetServRuntime getParentInetServRuntime(InetApplication application) {
        InetServRuntime parentInetServRuntime = this.parentInetServRuntime;
        if (parentInetServRuntime == null) {
            int parentId = this.inetServ.getParentId();
            if (parentId > 0) {
                this.parentInetServRuntime = application.getInetServRuntimeMap().get(parentId);
                parentInetServRuntime = this.parentInetServRuntime;
                if (parentInetServRuntime == null) {
                    parentInetServRuntime = this;
                    logger.error("Parent InetServRuntime not found with id=" + parentId);
                }
            } else {
                parentInetServRuntime = this.parentInetServRuntime = this;
            }
        }
        return parentInetServRuntime;
    }

    public InetServRuntime getRootInetServRuntime(InetApplication application) {
        InetServRuntime parentInetServRuntime = this.parentInetServRuntime;
        if (parentInetServRuntime == null) {
            int parentId = this.inetServ.getParentId();
            if (parentId > 0) {
                this.parentInetServRuntime = application.getInetServRuntimeMap().get(parentId);
                parentInetServRuntime = this.parentInetServRuntime;
                if (parentInetServRuntime == null) {
                    parentInetServRuntime = this;
                    logger.error("Parent InetServRuntime not found with id=" + parentId);
                }
            } else {
                parentInetServRuntime = this.parentInetServRuntime = this;
            }
        }
        if (parentInetServRuntime == this) {
            return this;
        }
        return parentInetServRuntime.getParentInetServRuntime(application);
    }

    public ContractStatusList getContractSuspendPeriods() {
        return this.contractSuspendPeriods;
    }

    public final void lock() {
        this.contractRuntime.lock();
    }

    public final boolean tryLock() {
        return this.contractRuntime.tryLock();
    }

    public final boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.contractRuntime.tryLock(timeout, unit);
    }

    public final void tryLockEx(long timeout, TimeUnit unit) throws InterruptedException {
        this.contractRuntime.tryLockEx(timeout, unit);
    }

    public final void unlock() {
        this.contractRuntime.unlock();
    }

    public final boolean isHeldByCurrentThread() {
        return this.contractRuntime.isHeldByCurrentThread();
    }

    public long getDateFromMillis() {
        return this.dateFromMillis;
    }

    public long getDateToMillis() {
        return this.dateToMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRestrictionList(List<InetServRestriction> restrictionList) {
        if (restrictionList.size() == 0) {
            this.lock();
            try {
                this.restrictions = null;
            }
            finally {
                this.unlock();
            }
            return;
        }
        ArrayList<InetServRestrictionRuntime> result = new ArrayList<InetServRestrictionRuntime>();
        GregorianCalendar utilCalendar = new GregorianCalendar();
        for (InetServRestriction r : restrictionList) {
            switch (r.getType()) {
                case 10: 
                case 11: 
                case 12: 
                case 20: 
                case 21: 
                case 22: {
                    result.add(new InetServRestrictionAccountRuntime(this, r, utilCalendar));
                    break;
                }
                case 0: {
                    if (r.getConfig() == null) break;
                    result.add(new InetServRestrictionTimeRuntime(this, r, utilCalendar));
                    break;
                }
            }
        }
        this.lock();
        try {
            this.restrictions = result.toArray(new InetServRestrictionRuntime[result.size()]);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.unlock();
        }
    }

    public boolean hasRestrictions() {
        return this.restrictions != null && this.restrictions.length > 0;
    }

    public int checkRestrictions(InetTariffWorkerContext workerContext, InetApplication application, InetConnectionRuntime connectionRuntime, InetTariffRequest req) throws BGException {
        InetServRestrictionRuntime[] restrictions = this.restrictions;
        if (restrictions == null) {
            return AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
        }
        Integer timeResult = null;
        block3: for (InetServRestrictionRuntime restriction : restrictions) {
            Integer res = restriction.test(workerContext, application, this, connectionRuntime, req);
            if (res == null) continue;
            switch (restriction.getType()) {
                case 0: {
                    if (res.intValue() == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                        timeResult = res;
                        continue block3;
                    }
                    if (timeResult != null && timeResult.intValue() == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) continue block3;
                    timeResult = res;
                    continue block3;
                }
                default: {
                    if (res.intValue() == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) continue block3;
                    return res;
                }
            }
        }
        if (timeResult != null) {
            return timeResult;
        }
        return AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
    }

    public boolean isAddressAllInterface(InetApplication application) {
        return this.getRootInetServRuntime((InetApplication)application).inetServTypeRef.get().inetServType.isAddressAllInterface();
    }

    public boolean processOptionsModified(Accounting accounting, long now, Set<Integer> inetOptions, String source) throws BGException {
        long div;
        if (this.inetOptions != null && this.inetOptions.equals(inetOptions) && (div = now - this.inetOptionsMillis) < TimeUnit.HOURS.toMillis(3L)) {
            return false;
        }
        this.inetOptions = inetOptions.size() > 0 ? inetOptions : Collections.emptySet();
        this.inetOptionsMillis = now;
        if (logger.isInfoEnabled()) {
            logger.info("Sending event to modify serv[" + this.inetServId + "] options to: " + Utils.toString(inetOptions));
        }
        InetSaOptionsModifyEvent inetSaOptionsModifyEvent = new InetSaOptionsModifyEvent(accounting.moduleId, 0, this.getParentInetServ(accounting), inetOptions);
        inetSaOptionsModifyEvent.setSource((String)(source != null ? source + ":" : "") + InetServRuntime.class.getSimpleName());
        EventProcessor.getInstance().publish((Event)inetSaOptionsModifyEvent);
        return true;
    }

    public InetServTypeRuntime getInetServTypeRuntime() {
        return this.inetServTypeRef.get();
    }

    public TariffModuleTreeSet getTariffTreeSet() {
        return this.tariffTreeSet;
    }

    public void setTariffTreeSet(TariffModuleTreeSet tariffTreeSet) {
        this.tariffTreeSet = tariffTreeSet;
    }

    public int ipInRange(InetServRuntimeMap servRuntimeMap, Date time, byte[] address) {
        if (this.ipInRange(address)) {
            return this.inetServ.getIpResourceId();
        }
        List<InetServRuntime> children = servRuntimeMap.listChildren(this.inetServId);
        if (children == null || children.size() == 0) {
            return 0;
        }
        long millis = time.getTime();
        for (InetServRuntime child : children) {
            if (child.dateFromMillis != 0L && child.dateFromMillis > millis || child.dateToMillis != 0L && child.dateToMillis < millis || !child.ipInRange(address)) continue;
            return child.inetServ.getIpResourceId();
        }
        return 0;
    }

    public boolean ipInRange(byte[] addressCon) {
        assert (addressCon != null);
        byte[] addressServFrom = this.inetServ.getAddressFrom();
        if (addressServFrom == null || addressServFrom.length != addressCon.length) {
            return false;
        }
        InetServTypeRuntime servTypeRuntime = this.inetServTypeRef.get();
        if (servTypeRuntime.radiusNoAddress) {
            return false;
        }
        if (addressCon.length == 4 && servTypeRuntime.radiusDelegetedPrefix) {
            return false;
        }
        InetServType servType = servTypeRuntime.inetServType;
        switch (servType.getAddressType()) {
            case DYNAMIC_OR_SINGLE: 
            case SINGLE_IPV4: 
            case NONE_OR_SINGLE: {
                return addressServFrom != null && Arrays.equals(addressCon, addressServFrom);
            }
            case DYNAMIC_OR_RANGE: 
            case RANGE: 
            case NET: {
                byte[] addressServTo = this.inetServ.getAddressTo();
                return addressServFrom != null && addressServTo != null && IpAddress.ipInRange((byte[])addressCon, (byte[])addressServFrom, (byte[])addressServTo);
            }
        }
        return false;
    }

    public InetServOptionList getInetServOptionsList() {
        return this.inetServOptionsList;
    }
}

