/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.ip;

import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.CopyOnWriteArrayMap;

final class CallConnectionAddressSet
extends CopyOnWriteArrayMap<IpAddress, InetConnectionRuntime> {
    private static final Logger logger = LogManager.getLogger();

    public CallConnectionAddressSet(List<InetConnectionRuntime> list) {
        super(256);
        this.addAll(list);
    }

    protected InetConnectionRuntime[] newArray(int size) {
        return new InetConnectionRuntime[size];
    }

    protected InetConnectionRuntime[] newArray(InetConnectionRuntime r) {
        return new InetConnectionRuntime[]{r};
    }

    public boolean add(IpAddress key, InetConnectionRuntime value) {
        if (value == null) {
            logger.error("InetConnectionRuntime is null!", (Throwable)new RuntimeException());
            return false;
        }
        return super.add((Object)key, (Object)value);
    }

    public void addAll(List<InetConnectionRuntime> list) {
        for (InetConnectionRuntime connectionRuntime : list) {
            if (connectionRuntime == null) {
                logger.error("InetConnectionRuntime is null!", (Throwable)new RuntimeException());
                continue;
            }
            IpAddress ipAddress = new IpAddress(connectionRuntime.connection.getInetAddressBytes());
            InetConnectionRuntime[] sessions = (InetConnectionRuntime[])this.arrayMap.get(ipAddress);
            if (sessions == null) {
                sessions = new InetConnectionRuntime[]{connectionRuntime};
            } else {
                InetConnectionRuntime[] newSessions = new InetConnectionRuntime[sessions.length + 1];
                System.arraycopy(sessions, 0, newSessions, 0, sessions.length);
                newSessions[sessions.length] = connectionRuntime;
                sessions = newSessions;
            }
            this.arrayMap.put(ipAddress, sessions);
        }
    }

    public InetConnectionRuntime get(IpAddress address, long millis, long lockTimeout) {
        InetConnectionRuntime[] sessions = (InetConnectionRuntime[])this.arrayMap.get(address);
        if (sessions != null) {
            for (int i = sessions.length - 1; i >= 0; --i) {
                InetConnectionRuntime connectionRuntime = sessions[i];
                if (!connectionRuntime.lockIfSessionActive(millis, lockTimeout)) continue;
                return connectionRuntime;
            }
        }
        return null;
    }

    public InetConnectionRuntime getWithTimeout(IpAddress address, long millis) {
        InetConnectionRuntime[] sessions = (InetConnectionRuntime[])this.arrayMap.get(address);
        if (sessions != null) {
            InetConnectionRuntime connectionRuntime;
            int i;
            for (i = 0; i < sessions.length; ++i) {
                connectionRuntime = sessions[i];
                Date sessionStart = connectionRuntime.sessionStart;
                Date sessionStop = connectionRuntime.sessionStop;
                if (sessionStart.getTime() > millis || sessionStop != null && sessionStop.getTime() < millis) continue;
                connectionRuntime.inetServRuntime.lock();
                return connectionRuntime;
            }
            for (i = 0; i < sessions.length; ++i) {
                int initiationType;
                connectionRuntime = sessions[i];
                long connectionFinishTimoutMillis = connectionRuntime.getConnectionFinishTimeoutMillis();
                if (connectionFinishTimoutMillis == 0L || (initiationType = connectionRuntime.inetServRuntime.inetServTypeRef.get().inetServType.getSessionInitiationType()) != 0) continue;
                Date sessionStart = connectionRuntime.sessionStart;
                Date sessionStop = connectionRuntime.sessionStop;
                if (sessionStart.getTime() > millis || sessionStop != null && sessionStop.getTime() + connectionFinishTimoutMillis < millis) continue;
                connectionRuntime.inetServRuntime.lock();
                return connectionRuntime;
            }
        }
        return null;
    }
}

