/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff.range;

import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeManager;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeDao;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeLoader;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.InetTrafficRangeDao;
import ru.bitel.common.sql.ConnectionSet;

public class TrafficRangeManager
extends RangeManager {
    public TrafficRangeManager(int moduleId, boolean realtime) throws BGException {
        super(moduleId, realtime);
        this.tablename = "inet_tariff_traffic_range_" + moduleId;
    }

    public long addRangedTraffic(TariffWorkerContext workerContext, InetConnectionRuntime connectionRuntime, int contractTariffOptionId, long treeNodeId, int mode, int type, Calendar time, long maxAmount, long amount, TrafficRangeLoader trafficRangeLoader, Date dateFrom, Date dateTo) throws BGException {
        this.getLogger().debug("addRangedTraffic(TrafficRangeManager)");
        TrafficRangeEntry rangedTrafficEntry = connectionRuntime.rangedTraffic;
        if (rangedTrafficEntry == null) {
            connectionRuntime.rangedTraffic = this.getRangedTrafficEntry(connectionRuntime.contractId);
        }
        long key = TrafficRangeKey.getKey((int)mode, (int)type, (int)connectionRuntime.accountingPeriodId, (int)contractTariffOptionId, (Calendar)time);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("key = {}", (Object)key);
            this.getLogger().debug("contractId = {}", (Object)connectionRuntime.contractId);
            this.getLogger().debug("treeNodeId = {}", (Object)treeNodeId);
            this.getLogger().debug("maxAmount = {}", (Object)maxAmount);
            this.getLogger().debug("amount = {}", (Object)amount);
        }
        return super.addRangedTraffic(connectionRuntime.rangedTraffic, workerContext, connectionRuntime.contractId, treeNodeId, key, maxAmount, amount, trafficRangeLoader);
    }

    public long addRangedTraffic(TariffWorkerContext workerContext, InetConnectionRuntime connectionRuntime, long treeNodeId, long rangeKey, long maxAmount, long amount, TrafficRangeLoader trafficRangeLoader) throws BGException {
        if (connectionRuntime.rangedTraffic == null) {
            connectionRuntime.rangedTraffic = this.getRangedTrafficEntry(connectionRuntime.contractId);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("rangeKey = {}", (Object)rangeKey);
            this.getLogger().debug("contractId = {}", (Object)connectionRuntime.contractId);
            this.getLogger().debug("treeNodeId = {}", (Object)treeNodeId);
            this.getLogger().debug("maxAmount = {}", (Object)maxAmount);
            this.getLogger().debug("amount = {}", (Object)amount);
        }
        return this.addRangedTraffic(connectionRuntime.rangedTraffic, workerContext, connectionRuntime.contractId, treeNodeId, rangeKey, maxAmount, amount, trafficRangeLoader);
    }

    protected TrafficRangeDao getTrafficRangeDao(ConnectionSet connectionSet) throws BGException {
        return new InetTrafficRangeDao(connectionSet.getConnection(), this.moduleId);
    }
}

