/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import bitel.billing.module.admin.TransferManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamAddressEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntityType;

public class DirectoryNewAddressEditorTab
extends AbstractBGUPanel<ClientContext, BGUPanel> {
    String selected;
    String whoseParam = "contract";
    JLabel recordCountLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: 0");
    BGTableModel<String[][]> tableModel;
    private JList<BGUListItem> objectAddressParamList;
    private JList<BGUListItem> contractAddressParamList;
    BGControlPanelPages pagePanel = new BGControlPanelPages();

    @Override
    protected void build() {
        super.build();
        this.setDataToAddressCustom();
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.build());
        new AbstractBGUPanel.BGActionEdit(e -> {
            if (this.tableModel.getSelectedRow() == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                return;
            }
            ContractParamEditorData data = new ContractParamEditorData();
            data.setClientContext((ClientContext)this.getContext());
            data.setContractId(Utils.parseInt(this.tableModel.getValueFromSelectedRow("cid")));
            data.setParameterId(Utils.parseInt(this.tableModel.getValueFromSelectedRow("pid")));
            if (this.whoseParam.equals("contract")) {
                data.setEntityType(EntityType.CONTRACT_PARAMETER);
            } else if (this.whoseParam.equals("object")) {
                data.setObjectId(Utils.parseInt(this.tableModel.getValueFromSelectedRow("objectId")));
                data.setEntityType(EntityType.OBJECT_PARAMETER);
            }
            new ContractParamAddressEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0410\u0434\u0440\u0435\u0441\"", data).open();
            this.showAddressCustom();
        });
    }

    @Override
    protected void jbInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getAddressParams(), (Component)this.getAddressCustomPanel(), 200L), "Center");
    }

    private JPanel getAddressParams() {
        this.contractAddressParamList = new JList();
        this.contractAddressParamList.setSelectionMode(0);
        this.contractAddressParamList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                this.objectAddressParamList.removeSelectionInterval(0, 100);
                this.whoseParam = "contract";
                this.showAddressCustom();
            }
        });
        this.objectAddressParamList = new JList();
        this.objectAddressParamList.setSelectionMode(0);
        this.objectAddressParamList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                this.contractAddressParamList.removeSelectionInterval(0, this.contractAddressParamList.getModel().getSize());
                this.whoseParam = "object";
                this.showAddressCustom();
            }
        });
        JPanel addressParams = new JPanel(new GridBagLayout());
        addressParams.setBorder(new BGTitleBorder("\u0410\u0434\u0440\u0435\u0441\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        addressParams.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        addressParams.add((Component)new JScrollPane(this.contractAddressParamList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 0, 5), 0, 0));
        addressParams.add((Component)new JLabel("\u041e\u0431\u044a\u0435\u043a\u0442\u043e\u0432:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        addressParams.add((Component)new JScrollPane(this.objectAddressParamList), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        return addressParams;
    }

    private JPanel getAddressCustomPanel() {
        this.tableModel = new BGTableModel<String[][]>("address"){

            @Override
            protected void initColumns() {
                this.addColumn("", 0, 0, 0, "cid");
                this.addColumn("", 0, 0, 0, "objectId");
                this.addColumn("", 0, 0, 0, "pid");
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 (\u041e\u0431\u044a\u0435\u043a\u0442)", 100, 150, 200, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0410\u0434\u0440\u0435\u0441", 0, -1, -1, "address", true, HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 0, -1, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
            }
        };
        BGUTable addressTable = new BGUTable(this.tableModel);
        addressTable.setSelectionMode(0);
        BGSwingUtilites.handleMouseClicked(addressTable, e -> this.addressTableMouseClicked(addressTable, (MouseEvent)e));
        this.pagePanel.addToHandler(a -> this.showAddressCustom());
        JPanel addressCustomTablePanel = new JPanel(new GridBagLayout());
        addressCustomTablePanel.add((Component)new JScrollPane(addressTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u041d\u043e\u0432\u044b\u0435 \u0430\u0434\u0440\u0435\u0441\u0430:"){
            {
                this.setFont(new Font("Dialog", 1, 18));
            }
        }, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.recordCountLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 20), 0, 0));
        topPanel.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 13, new Insets(0, 0, 0, 0), 0, 0));
        JPanel addressCustomPanel = new JPanel(new GridBagLayout());
        addressCustomPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        addressCustomPanel.add((Component)addressCustomTablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return addressCustomPanel;
    }

    private void addressTableMouseClicked(BGUTable addressTable, MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
            this.performAction("edit");
        } else if (this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(event) && addressTable.getSelectedRow() == addressTable.rowAtPoint(event.getPoint())) {
            this.getPopupMenu().show(addressTable, event.getX(), event.getY());
        }
    }

    @Override
    protected void getPopupMenuItems() {
        this.popupMenu.add("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440").addActionListener(e -> {
            String[][] selectedRow = this.tableModel.getSelectedRow();
            if (selectedRow != null && selectedRow instanceof String[][]) {
                String[][] rowData;
                for (String[] cellData : rowData = selectedRow) {
                    int contractId;
                    if (cellData == null || cellData.length <= 1 || !"cid".equals(cellData[0]) || (contractId = Utils.parseInt(cellData[1], 0)) <= 0) continue;
                    BGClientBase.getFrame().getTabbedPane().addContractEditorTab(contractId);
                }
            }
        });
    }

    private void showAddressCustom() {
        BGUListItem item = null;
        if (this.whoseParam.equals("contract")) {
            item = this.contractAddressParamList.getSelectedValue();
        } else if (this.whoseParam.equals("object")) {
            item = this.objectAddressParamList.getSelectedValue();
        }
        if (item != null) {
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("AddressCustomEditor").setPage(this.pagePanel).setAttribute("pid", item.getId()).setAttribute("whoseParam", this.whoseParam);
            this.selected = item.getAttribute("id").toString();
            Document doc = TransferManager.getDocument(request);
            ClientUtils.checkStatus(doc);
            if (ClientUtils.checkStatus(doc)) {
                try {
                    Element tableElement = XMLUtils.selectElement(doc, "/data/table");
                    ArrayList<String[][]> rows = new ArrayList<String[][]>();
                    for (Element rowElement : XMLUtils.selectElements(tableElement, "//data/row")) {
                        String[][] data = new String[][]{{"address", rowElement.getAttribute("address")}, {"cid", rowElement.getAttribute("contractId")}, {"pid", rowElement.getAttribute("parameterId")}, {"comment", rowElement.getAttribute("comment")}, {"title", rowElement.getAttribute("title")}, {"objectId", rowElement.getAttribute("objectId")}};
                        rows.add(data);
                    }
                    this.tableModel.setData(rows);
                    this.pagePanel.setPageInfo(tableElement);
                    this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + tableElement.getAttribute("recordCount"));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        }
    }

    private void setDataToAddressCustom() {
        Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("AddressCustomInit");
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            try {
                ClientUtils.buildList(this.contractAddressParamList, (Node)XMLUtils.selectElement(doc, "//params/contract_address"), this.selected);
                ClientUtils.buildList(this.objectAddressParamList, (Node)XMLUtils.selectElement(doc, "//params/object_address"), this.selected);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }
}

