/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventKey;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerThreadContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventProcessorException;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.worker.ThreadContext;

final class LocalEventProcessor
extends BGLogger {
    private final Setup setup;
    private final String applicationName;
    final ConcurrentMap<LocalEventKey, CopyOnWriteArrayList<EventListener<? super Event>>> local;

    public LocalEventProcessor(Setup setup, String applicationName, LocalEventProcessor old) {
        this.setup = setup;
        this.applicationName = applicationName;
        this.local = old != null ? old.local : new ConcurrentHashMap<LocalEventKey, CopyOnWriteArrayList<EventListener<? super Event>>>();
    }

    <E extends Event> boolean addListener(EventListener<? super E> l, Class<E> clazz, int moduleId, int pluginId, boolean update) throws BGException {
        int index;
        CopyOnWriteArrayList newList;
        LocalEventKey key;
        CopyOnWriteArrayList<EventListener<? super E>> listeners;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("addListener for {}", (Object)clazz.getName());
        }
        if ((listeners = (CopyOnWriteArrayList<EventListener<? super E>>)this.local.get(key = new LocalEventKey(clazz, moduleId, pluginId))) == null && (listeners = this.local.putIfAbsent(key, newList = new CopyOnWriteArrayList())) == null) {
            listeners = newList;
        }
        if (update && (index = listeners.indexOf(l)) >= 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Updating listener " + String.valueOf(l) + " to " + String.valueOf(key));
            }
            listeners.set(index, l);
            return true;
        }
        this.getLogger().debug("Add listener {} to {}, map size: {}", new Object[]{l, key, this.local.size()});
        listeners.add(l);
        return false;
    }

    void removeListener(EventListener<?> l, Collection<String> exceptKeys) throws BGException {
        Iterator iter = this.local.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            CopyOnWriteArrayList listeners = (CopyOnWriteArrayList)e.getValue();
            if (exceptKeys.contains(((LocalEventKey)e.getKey()).toString()) || !listeners.remove(l) || listeners.size() != 0) continue;
            iter.remove();
        }
    }

    <E extends Event> E request(E e) throws EventProcessorException {
        LocalEventKey key2;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Event request: {}", e);
        }
        LocalEventKey key = new LocalEventKey(e.getClass(), e.getModuleId(), e.getPluginId());
        this.request0(e, key);
        if (e.getModuleId() >= 0) {
            key2 = new LocalEventKey(e.getClass(), -1, e.getPluginId());
            this.request0(e, key2);
        }
        if (e.getPluginId() >= 0) {
            key2 = new LocalEventKey(e.getClass(), e.getModuleId(), -1);
            this.request0(e, key2);
        }
        return e;
    }

    private <E extends Event> void request0(E e, LocalEventKey key) throws EventProcessorException {
        List listeners = (List)this.local.get(key);
        if (listeners != null) {
            ThreadContext parent = ThreadContext.get();
            if (!(parent instanceof ServerContext)) {
                throw new EventProcessorException("Local event must be generated in ServerContext!");
            }
            EventListenerThreadContext ctx = new EventListenerThreadContext((ServerContext)parent, this.applicationName);
            try {
                for (EventListener l : listeners) {
                    l.notify(e, ctx);
                }
            }
            catch (Exception ex) {
                throw new EventProcessorException(ex);
            }
        }
    }

    public List<EventKey> getListeningEventKeys() {
        ArrayList<EventKey> events = new ArrayList<EventKey>();
        for (LocalEventKey c : this.local.keySet()) {
            events.add(new EventKey(c.clazz, c.moduleId, c.pluginId, null));
        }
        return events;
    }

    static class LocalEventKey {
        final Class<? extends Event> clazz;
        final int moduleId;
        final int pluginId;
        private String toString = null;

        public LocalEventKey(Class<? extends Event> clazz, int moduleId, int pluginId) {
            this.clazz = clazz;
            this.moduleId = moduleId;
            this.pluginId = pluginId;
        }

        public final int hashCode() {
            return this.clazz.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LocalEventKey) {
                LocalEventKey other = (LocalEventKey)obj;
                return this.clazz.equals(other.clazz) && this.moduleId == other.moduleId && this.pluginId == other.pluginId;
            }
            return false;
        }

        public String toString() {
            if (this.toString == null) {
                String query = EventProcessor.getQuery(this.moduleId, this.pluginId, null);
                this.toString = query != null ? "BG.LocalEvent." + this.clazz.getName() + " WHERE " + query : "BG.LocalEvent." + this.clazz.getName();
            }
            return this.toString;
        }
    }
}

