/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseCoordinates;

public class HouseCoordinatesDao
extends AbstarctDaoConstant {
    private static final String TABLE_NAME = "house_coordinates";

    public HouseCoordinatesDao(Connection con) {
        super(con);
    }

    public HouseCoordinates getCoordinatesByHouseId(int houseId) throws SQLException {
        String query = "SELECT * FROM house_coordinates WHERE house_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, houseId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    HouseCoordinates houseCoordinates = new HouseCoordinates(rs.getInt("house_id"), rs.getDouble("latitude"), rs.getDouble("longitude"));
                    return houseCoordinates;
                }
            }
        }
        return null;
    }

    public void save(HouseCoordinates coordinates) throws SQLException {
        boolean isUpdate = this.isUpdate(coordinates.getHouseId());
        String prefix = isUpdate ? "UPDATE " : "INSERT INTO ";
        String query = prefix + "house_coordinates SET latitude=?, longitude=?" + (isUpdate ? " WHERE house_id=?" : ", house_id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDouble(1, coordinates.getLatitude());
            ps.setDouble(2, coordinates.getLongitude());
            ps.setInt(3, coordinates.getHouseId());
            ps.executeUpdate();
        }
    }

    private boolean isUpdate(int houseId) throws SQLException {
        String query = "SELECT * FROM house_coordinates WHERE house_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            boolean bl;
            block12: {
                ps.setInt(1, houseId);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    public void delete(int houseId) throws SQLException {
        String query = "DELETE FROM house_coordinates WHERE house_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, houseId);
            ps.executeUpdate();
        }
    }
}

