/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.npay.server.calculate.AmountDetail;
import ru.bitel.bgbilling.modules.npay.server.calculate.AmountDetailCache;
import ru.bitel.common.Utils;

public class NpayDetailDao
extends AbstarctDaoConstant {
    public NpayDetailDao(Connection con, int moduleId, Date date) {
        super(con, "npay_detail", moduleId, date);
    }

    public void createTable() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS " + this.tableName + "( `id` int(11) NOT NULL AUTO_INCREMENT,`cid` INT NOT NULL,`mid` INT NOT NULL,`eid` INT NOT NULL,`sid` INT NOT NULL,`treeId` INT NOT NULL,`col` DECIMAL(20,5) NOT NULL,`summa` DECIMAL(15,2) NOT NULL, PRIMARY KEY (`id`),KEY `cid_mid_eid` (`cid`, `mid`, `eid`),KEY `sid` (`sid`),KEY `treeId` (`treeId`),KEY `mid` (`mid`) )";
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public void delete(List<Integer> contractIds, List<Integer> serviceIds) throws SQLException {
        Objects.requireNonNull(serviceIds, "serviceIds must be not null");
        if (serviceIds.isEmpty()) {
            return;
        }
        String query = "DELETE FROM " + this.tableName + " WHERE sid IN (" + Utils.toString(serviceIds) + ") ";
        if (contractIds != null && !contractIds.isEmpty()) {
            query = query + " AND cid IN (" + String.valueOf(contractIds) + ")";
        }
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public void insert(AmountDetailCache amountDetailCache) throws SQLException {
        String query = "INSERT INTO " + this.tableName + " SET cid=?, mid=?, eid=?, sid=?, treeId=?, col=?, summa=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int count = 0;
            for (AmountDetail detail : amountDetailCache.getAmounts()) {
                ps.setInt(1, detail.cid);
                ps.setInt(2, detail.mid);
                ps.setInt(3, detail.eid);
                ps.setInt(4, detail.sid);
                ps.setInt(5, detail.tree);
                ps.setBigDecimal(6, detail.col);
                ps.setBigDecimal(7, detail.cost);
                ps.addBatch();
                if (++count != 1000) continue;
                ps.executeBatch();
                count = 0;
            }
            if (count > 0) {
                ps.executeBatch();
            }
        }
    }
}

