/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.inbuild;

import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Contract
extends BGJasperReport {
    public Report_Contract() {
        this.id = "kernel_contract_contract";
    }

    @Override
    public void fillReportToStream(OutputStream out) throws BGException {
        try {
            int face;
            BGReportFilter filter = this.createBGReportFilter();
            String gr = filter.getStringParam("gr");
            String mask = filter.getStringParam("mask");
            int listParameterPid = Utils.parseInt((String)filter.getStringParam("listParameter_pid"), (int)0);
            String listParameterValues = filter.getStringParam("listParameter_values");
            Calendar dateParameterDate1 = TimeUtils.parseCalendar((String)filter.getStringParam("dateParameter_date1"), (String)"dd.MM.yyyy");
            Calendar dateParameterDate2 = TimeUtils.parseCalendar((String)filter.getStringParam("dateParameter_date2"), (String)"dd.MM.yyyy");
            String dateParameterParameters = filter.getStringParam("dateParameter_parameters");
            int mode = Utils.parseInt((String)filter.getStringParam("mode"), (int)0);
            int hiddenFilter = Utils.parseInt((String)filter.getStringParam("hf"), (int)0);
            StringBuffer query = new StringBuffer("SELECT title, ").append(" DATE_FORMAT( " + (mode == 0 || mode == 2 ? "date1" : "date2") + ", '%d.%m.%Y' ) ").append("AS date, gr, comment ").append(" FROM contract ");
            if (listParameterPid > 0 && Utils.notBlankString((String)listParameterValues)) {
                query.append("LEFT JOIN contract_parameter_type_7 as list ON list.cid=contract.id AND list.pid=" + listParameterPid + " ");
            }
            if (Utils.notBlankString((String)dateParameterParameters)) {
                query.append("LEFT JOIN contract_parameter_type_6 as date ON date.cid=contract.id AND date.pid IN (" + dateParameterParameters + ")");
                query.append(" AND( ? IS NULL OR date.val>=?  ) ");
                query.append(" AND ( ? IS NULL OR date.val<=? )");
            }
            query.append(" WHERE true");
            if (mode == 0) {
                query.append(" AND NOT ( date1 IS NULL )");
                query.append(" AND ( ? IS NULL OR date1>=? )");
                query.append(" AND ( ? IS NULL OR date1<=? )");
            } else if (mode == 1) {
                query.append(" AND NOT ( date2 IS NULL )");
                query.append(" AND ( ? IS NULL OR date2>=? )");
                query.append(" AND ( ? IS NULL OR date2<=? )");
            } else {
                query.append(" AND ( ? IS NULL OR date2 IS NULL OR date2>=? )");
                query.append(" AND ( ? IS NULL OR date1 IS NULL OR date1<=? )");
            }
            long grMask = Utils.enumToMask((String)gr);
            String groupMode = filter.getStringParam("group_mode");
            if (grMask > 0L && Utils.notEmptyString((String)groupMode)) {
                if (groupMode.equals("or")) {
                    query.append(" AND gr&").append(grMask).append(">0");
                } else {
                    query.append(" AND gr&").append(grMask).append("=").append(grMask);
                }
            }
            query.append((String)((face = Utils.parseInt((String)filter.getStringParam("face"), (int)0)) != 0 ? " AND fc=" + (face - 1) : ""));
            switch (hiddenFilter) {
                case 1: {
                    query.append(" AND del=0");
                    break;
                }
                case 2: {
                    query.append(" AND del=1");
                }
            }
            query.append((String)(Utils.notEmptyString((String)mask) ? " AND title REGEXP '" + mask + "'" : ""));
            if (listParameterPid > 0 && Utils.notBlankString((String)listParameterValues)) {
                query.append(" AND list.val IN (" + listParameterValues + ")");
            }
            if (Utils.notBlankString((String)dateParameterParameters)) {
                query.append(" AND date.cid IS NOT NULL");
            }
            query.append(" ORDER BY title ");
            HashMap<String, Object> params = new HashMap<String, Object>();
            BGDataSource bgDataSource = new BGDataSource();
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                int i = 1;
                if (Utils.notBlankString((String)dateParameterParameters)) {
                    ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)dateParameterDate1));
                    ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)dateParameterDate1));
                    ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)dateParameterDate2));
                    ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)dateParameterDate2));
                }
                java.sql.Date date1 = TimeUtils.convertDateToSqlDate((Date)TimeUtils.parseDate((String)filter.getStringParam("date1"), (String)"dd.MM.yyyy"));
                java.sql.Date date2 = TimeUtils.convertDateToSqlDate((Date)TimeUtils.parseDate((String)filter.getStringParam("date2"), (String)"dd.MM.yyyy"));
                ps.setDate(i++, date1);
                ps.setDate(i++, date1);
                ps.setDate(i++, date2);
                ps.setDate(i++, date2);
                String text = switch (mode) {
                    case 0 -> "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0435 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434: ";
                    case 1 -> "\u0417\u0430\u043a\u0440\u044b\u0442\u044b\u0435 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434: ";
                    case 2 -> "\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0432 \u043f\u0435\u0440\u0438\u043e\u0434: ";
                    default -> "";
                };
                params.put("addInfo", text + TimeUtils.formatPeriod((Date)date1, (Date)date2));
                HashMap<Integer, Integer> groupCount = new HashMap<Integer, Integer>();
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        row.put("col1", rs.getString("title") + " (" + rs.getString("comment") + ") ");
                        row.put("col2", rs.getString("date"));
                        bgDataSource.addRow(row);
                        long groups = rs.getLong("gr");
                        this.addGroupCounts(groupCount, groups);
                    }
                }
                params.put("sum1", String.valueOf(bgDataSource.rows()));
            }
            this.fillReportToStream(this.id, out, params, bgDataSource);
        }
        catch (Exception ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0451\u0442\u0430", (Throwable)ex);
        }
    }

    private void addGroupCounts(HashMap<Integer, Integer> counts, long group) {
        for (int i = 0; i < 32; ++i) {
            if ((group & (long)(1 << i)) <= 0L) continue;
            Integer key = i;
            Integer cnt = counts.get(key);
            int new_cnt = cnt == null ? 1 : cnt + 1;
            counts.put(key, new_cnt);
        }
    }
}

