/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.kernel;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_ActSverki
extends BGJasperReport {
    public Report_ActSverki() {
        this.id = "kernel_act_sverki";
    }

    @Override
    public void fillReportToStream(OutputStream out) throws Exception {
        BGReportFilter filter = this.createBGReportFilter();
        Setup setup = Setup.getSetup();
        int pid_inn = setup.getInt("report.act_sverki.inn.parameter.id", 0);
        int billModuleId = setup.getInt("report.act_sverki.bill.module.id", 0);
        String city = setup.get("report.act_sverki.city");
        String orgName = setup.get("report.act_sverki.org.name");
        String orgInn = setup.get("report.act_sverki.org.inn");
        Calendar monthFrom = TimeUtils.parseCalendar((String)filter.getStringParam("month_from"), (String)"dd.MM.yyyy");
        Calendar dateTo = TimeUtils.parseCalendar((String)filter.getStringParam("date_to"), (String)"dd.MM.yyyy");
        Calendar monthTo = (Calendar)dateTo.clone();
        if (monthTo.get(5) != monthTo.getActualMaximum(5)) {
            monthTo.add(2, -1);
        }
        int cid = Utils.parseInt((String)filter.getStringParam("contract"));
        try {
            ResultSet rs;
            PreparedStatement ps;
            Object query;
            BGDataSource bgDataSource = new BGDataSource();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("city", city);
            params.put("orgInn", orgInn);
            params.put("orgName", orgName);
            Calendar nextMonth = (Calendar)monthTo.clone();
            nextMonth.add(6, 1);
            params.put("dateFrom", TimeUtils.formatDate((Calendar)monthFrom));
            params.put("dateTo", TimeUtils.formatDate((Calendar)dateTo));
            Contract contract = ContractDao.getContract((Connection)this.con, (int)cid);
            if (contract != null) {
                params.put("clientTitle", contract.getComment());
                params.put("contractNumber", contract.getTitle());
                params.put("contractDate", TimeUtils.formatDate((Date)contract.getDateFrom()));
            }
            BigDecimal inRest = BigDecimal.ZERO;
            try (BalanceUtils balanceUtils = new BalanceUtils(this.con);
                 ContractDao contractDao = new ContractDao(this.con, this.userId);){
                contractDao.optContractParameterTextAsString(cid, pid_inn).ifPresent(a -> params.put("contractINN", a));
                inRest = balanceUtils.getBalanceSumma1(TimeUtils.convertCalendarToDate((Calendar)monthFrom), cid);
                if (inRest.compareTo(BigDecimal.ZERO) <= 0) {
                    params.put("inRestDebet", Utils.formatBigDecimalSumm((BigDecimal)inRest.abs()));
                    params.put("inRestCredit", "");
                } else {
                    params.put("inRestDebet", "");
                    params.put("inRestCredit", Utils.formatBigDecimalSumm((BigDecimal)inRest.abs()));
                }
            }
            BigDecimal fullActSum = BigDecimal.ZERO;
            BigDecimal fullPaySum = BigDecimal.ZERO;
            TreeMap<String, ArrayList<String[]>> docTreeMap = new TreeMap<String, ArrayList<String[]>>();
            String tableName = "bill_invoice_data_" + billModuleId;
            if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                query = "SELECT yy, mm, format_number, summ FROM " + tableName + " WHERE cid=? ORDER BY yy, mm";
                ps = this.con.prepareStatement((String)query);
                ps.setInt(1, cid);
                rs = ps.executeQuery();
                while (rs.next()) {
                    int yy = rs.getInt(1);
                    int mm = rs.getInt(2);
                    BigDecimal summ = rs.getBigDecimal(4);
                    Calendar month = new GregorianCalendar(yy, mm, 1);
                    if (!TimeUtils.dateBeforeOrEq((Calendar)monthFrom, (Calendar)month) || !TimeUtils.dateBeforeOrEq((Calendar)month, (Calendar)monthTo)) continue;
                    month = TimeUtils.getEndMonth((Calendar)month);
                    String actDate = TimeUtils.format((Calendar)month, (String)"yyyy-MM-dd");
                    String actNum = rs.getString(3);
                    String actSum = Utils.formatBigDecimalSumm((BigDecimal)summ);
                    ArrayList<String[]> dateDocs = (ArrayList<String[]>)docTreeMap.get(actDate);
                    if (dateDocs == null) {
                        dateDocs = new ArrayList<String[]>();
                        docTreeMap.put(actDate, dateDocs);
                    }
                    dateDocs.add(new String[]{"\u0421\u0447.\u0444.\u2116" + actNum + " \u043e\u0442 " + TimeUtils.formatDate((Calendar)month), actSum, ""});
                    fullActSum = fullActSum.add(summ);
                }
                rs.close();
                ps.close();
            }
            query = "SELECT dt, summa FROM contract_payment WHERE cid=? AND dt>=? AND dt<=? ORDER BY dt";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, cid);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)monthFrom));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)dateTo));
            rs = ps.executeQuery();
            while (rs.next()) {
                BigDecimal summ = rs.getBigDecimal(2);
                String payDate = TimeUtils.format((Date)rs.getDate(1), (String)"yyyy-MM-dd");
                String paySum = Utils.formatBigDecimalSumm((BigDecimal)summ);
                ArrayList<String[]> dateDocs = (ArrayList<String[]>)docTreeMap.get(payDate);
                if (dateDocs == null) {
                    dateDocs = new ArrayList<String[]>();
                    docTreeMap.put(payDate, dateDocs);
                }
                dateDocs.add(new String[]{"\u041e\u043f\u043b\u0430\u0442\u0430 " + TimeUtils.formatDate((Date)rs.getDate(1)), "", paySum});
                fullPaySum = fullPaySum.add(summ);
            }
            rs.close();
            ps.close();
            for (List docList : docTreeMap.values()) {
                for (String[] line : docList) {
                    HashMap<String, Object> map = new HashMap<String, Object>(3);
                    bgDataSource.addRow(map);
                    map.put("doc.text", line[0]);
                    map.put("doc.debet", line[1]);
                    map.put("doc.credit", line[2]);
                }
            }
            params.put("sumDebet", Utils.formatBigDecimalSumm((BigDecimal)fullActSum));
            params.put("sumCredit", Utils.formatBigDecimalSumm((BigDecimal)fullPaySum));
            BigDecimal outRest = inRest.add(fullPaySum).subtract(fullActSum);
            if (outRest.compareTo(BigDecimal.ZERO) <= 0) {
                params.put("outRestDebet", Utils.formatBigDecimalSumm((BigDecimal)outRest.abs()));
                params.put("outRestCredit", "");
                params.put("debtor", params.get("clientTitle"));
                params.put("debted", orgName);
            } else {
                params.put("debtor", orgName);
                params.put("debted", params.get("clientTitle"));
                params.put("outRestDebet", "");
                params.put("outRestCredit", Utils.formatBigDecimalSumm((BigDecimal)outRest.abs()));
            }
            params.put("debt", Utils.formatBigDecimalSumm((BigDecimal)outRest.abs()));
            this.fillReportToStream("kernel_act_sverki", out, params, bgDataSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

