/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sberbank.server.event.worker;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.sberbank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.sberbank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.sberbank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.sberbank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.sberbank.server.event.SberbankAutopaymentEvent;
import ru.bitel.bgbilling.modules.sberbank.server.event.SberbankCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.Utils;

public class SberbankAutopaymentEventWorker
extends EventWorker {
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;
    private long sleepTimeout = 500L;

    public SberbankAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), SberbankAutopaymentEvent.class, moduleId, -1, null);
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.sleepTimeout = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getLong("sberbank.autopayment.event.worker.sleep.timeout", 500L);
        this.getLogger().info("Starting SberbankAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "sberbank-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        SberbankAutopaymentEvent event = (SberbankAutopaymentEvent)((Object)task);
        int contractId = event.getContractId();
        try {
            Contract contract;
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            BigDecimal sum = Optional.ofNullable(event.getSum()).orElse(autopayment.getSum());
            if (autopayment != null && autopayment.getMode() == event.getMode() && (contract = ContractDao.getContract((Connection)((EventListenerContext)this.context).getConnection(), (int)contractId)) != null) {
                String customerAddress = ContractUtils.getCustomerAddress((Connection)((EventListenerContext)this.context).getConnection(), (int)this.moduleId, (int)contractId);
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                Transaction transaction = this.transactionManager.registerOrder(contractId, contract.getTitle(), customerAddress, sum, dataMap, true, true, "");
                String result = this.transactionManager.paymentOrderBinding(transaction, autopayment);
                if (result != null) {
                    Map parameterMap = Utils.stringToPairsHash((String)result.replace("\n", ";"));
                    if ("0".equals(parameterMap.get("errorCode"))) {
                        this.getLogger().debug("publish SberbankCheckEvent");
                        EventProcessor.getInstance().publish((Event)new SberbankCheckEvent(this.moduleId, contractId, true));
                    } else {
                        transaction.setStatus(TransactionStatus.ERROR.getCode());
                        TransactionManager.addTransactionParameters(transaction, result);
                        this.transactionManager.update(transaction);
                    }
                }
                try {
                    Thread.sleep(this.sleepTimeout);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return null;
    }
}

