/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.shop.common.bean.ContractStockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.Warehouse;
import ru.bitel.bgbilling.plugins.shop.common.bean.WarehouseOperationEntry;
import ru.bitel.bgbilling.plugins.shop.common.bean.WarehouseOperationType;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseOperationService;
import ru.bitel.bgbilling.plugins.shop.server.dao.ContractStockItemDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.WarehouseDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.WarehouseOperationEntryDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.shop.common.service.WarehouseOperationService")
public class WarehouseOperationServiceImpl
extends AbstractService
implements WarehouseOperationService {
    private StockItemDao stockItemDao;
    private WarehouseDao warehouseDao;
    private ContractStockItemDao contractStockItemDao;
    private WarehouseOperationEntryDao warehouseOperationDao;

    @PostConstruct
    public void init() {
        this.stockItemDao = new StockItemDao(this.getConnection(), this.moduleId);
        this.warehouseDao = new WarehouseDao(this.getConnection(), this.moduleId);
        this.contractStockItemDao = new ContractStockItemDao(this.getConnection(), this.moduleId);
        this.warehouseOperationDao = new WarehouseOperationEntryDao(this.getConnection(), this.moduleId);
    }

    public void transferToWarehouse(int stockItemId, int warehouseFrom, int warehouseTo) throws BGException {
        this.tryCall(() -> {
            StockItem stockItem = (StockItem)this.stockItemDao.get(stockItemId);
            if (stockItem == null) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u043e\u0432\u0430\u0440\u0430 \u0441\u043a\u043b\u0430\u0434\u0430 \u0441 ID=" + stockItemId);
            }
            Warehouse warehouse = (Warehouse)this.warehouseDao.get(warehouseFrom);
            if (warehouse.getId() != stockItem.getWarehouseId()) {
                throw new Exception(String.format("\u0422\u043e\u0432\u0430\u0440 \u0441 ID=%s \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0441\u043a\u043b\u0430\u0434\u0443 \u0441 ID=%s", stockItemId, warehouseFrom));
            }
            stockItem.setWarehouseId(((Warehouse)this.warehouseDao.get(warehouseTo)).getId());
            this.stockItemDao.update(stockItem);
            this.addHistoryEntry(WarehouseOperationType.TRANSFER_TO_WAREHOUSE, 0, warehouseFrom, warehouseTo, stockItemId, stockItem.getType().getTitle());
        });
    }

    public void transferToContract(int stockItemId, int contractId, Date dateFrom, Date dateTo) throws BGException {
        this.tryCall(() -> {
            int alreadyAddedCid = this.contractStockItemDao.getContractIdByStockItem(stockItemId, new Date());
            if (alreadyAddedCid > 0) {
                throw new Exception(String.format("\u0422\u043e\u0432\u0430\u0440 ID=%s \u0443\u0436\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 ID=%s", stockItemId, alreadyAddedCid));
            }
            StockItem stockItem = (StockItem)this.stockItemDao.get(stockItemId);
            if (stockItem == null) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u043e\u0432\u0430\u0440 \u0441 ID=" + stockItemId);
            }
            if (TimeUtils.dateBefore((Date)dateFrom, (Date)new Date())) {
                throw new Exception("\u0414\u0430\u0442\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u043e\u0432\u0430\u0440\u0430 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u043c!");
            }
            ContractStockItem contractStockItem = new ContractStockItem().setStockItem(stockItem).setContractId(contractId).setUserId(this.userId).setDateFrom(dateFrom).setDateTo(dateTo);
            this.contractStockItemDao.update(contractStockItem);
            stockItem.setContractId(contractId);
            this.stockItemDao.update(stockItem);
            this.addHistoryEntry(WarehouseOperationType.ADD_TO_CONTRACT, contractId, stockItem.getWarehouseId(), 0, stockItemId, stockItem.getType().getTitle());
        });
    }

    public SearchResult<ContractStockItem> contractStockItemList(Page page, int contractId, Date dateFrom, Date dateTo) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(page);
            searchResult.setList(new ArrayList());
            if (dateFrom != null || dateTo != null) {
                if (dateFrom == null || dateTo != null && dateFrom.after(dateTo)) {
                    throw new Exception("\u041d\u0435 \u0432\u0435\u0440\u043d\u043e \u0437\u0430\u0434\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434!");
                }
                searchResult.setPeriod(new Period(dateFrom, dateTo));
            }
            this.contractStockItemDao.list((SearchResult<ContractStockItem>)searchResult, contractId);
            return searchResult;
        });
    }

    public SearchResult<WarehouseOperationEntry> warehouseOperationList(SearchResult<WarehouseOperationEntry> searchResult) throws BGException {
        this.warehouseOperationDao.searchOperations(searchResult);
        return searchResult;
    }

    public void returnStockItemToWarehouse(int stockItemId) throws BGException {
        this.tryCall(() -> {
            ContractStockItem entry = this.contractStockItemDao.getByStockItemId(stockItemId).orElseThrow(() -> new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u0442\u043e\u0432\u0430\u0440\u0430 ID=" + stockItemId));
            entry.setUserId(this.userId);
            entry.setDateTo(new Date());
            this.contractStockItemDao.update(entry);
            StockItem stockItem = (StockItem)this.stockItemDao.get(stockItemId);
            int fromContractId = stockItem.getContractId();
            stockItem.setContractId(0);
            this.stockItemDao.update(stockItem);
            this.addHistoryEntry(WarehouseOperationType.REMOVE_FROM_CONTRACT, fromContractId, stockItem.getWarehouseId(), 0, stockItemId, stockItem.getType().getTitle());
        });
    }

    public void stockItemAdded(StockItem stockItem) throws BGException {
        this.addHistoryEntry(WarehouseOperationType.ADD_TO_WAREHOUSE, 0, stockItem.getWarehouseId(), 0, stockItem.getId(), stockItem.getType().getTitle());
    }

    public void stockItemDeleted(@WebParam(name="stockItem") StockItem stockItem) throws BGException {
        this.addHistoryEntry(WarehouseOperationType.REMOVE_FROM_WAREHOUSE, 0, stockItem.getWarehouseId(), 0, stockItem.getId(), stockItem.getType().getTitle());
    }

    protected void addHistoryEntry(WarehouseOperationType operationType, int contractId, int warehouseFrom, int warehouseTo, int stockItemId, String stockItemTypeTitle) throws BGException {
        this.tryCall(() -> {
            WarehouseOperationEntry entry = new WarehouseOperationEntry(operationType).setContractId(contractId).setWarehouseFromId(warehouseFrom).setWarehouseToId(warehouseTo).setStockItemId(stockItemId).setStockItemTypeTitle(stockItemTypeTitle).setUserId(this.userId);
            this.warehouseOperationDao.update(entry);
        });
    }
}

