/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.apps.voice.accounting.bean.SessionAccountAmount;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionFilter;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionAccountReportItem;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDestinationReportItem;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetail;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionDetailReportItem;
import ru.bitel.bgbilling.modules.voice.common.bean.report.SessionServiceReportItem;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionAccountLogDao;
import ru.bitel.bgbilling.modules.voice.server.tariff.range.VoiceTrafficRangeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;

public class VoiceSessionLogDao
extends AbstractDao<VoiceSession> {
    public static final String TABLE_VOICE_SESSION_LOG = "voice_session_log";
    private final String sessionAccountTableName;
    private static final ExecutorService SERVICE = Executors.newFixedThreadPool(1);
    private List<String> FIELDS = Arrays.asList("contractId", "accountId", "sessionStart", "sessionStop", "sessionCost", "hour", "callingStationId", "calledStationId", "e164CallingStationId", "e164CalledStationId", "lastActive", "deviceId", "sessionTime", "sessionTimeRound", "identifier", "destinationId", "callType ", "acctSessionId", "parentId", "type", "fromPort", "toPort", "codeId", "costMapItemId", "serviceId", "minuteCost", "cdrCallCost", "cdrCallOperCost");

    public VoiceSessionLogDao(Connection con, int moduleId, Date date) {
        super(con, TABLE_VOICE_SESSION_LOG, moduleId, date);
        this.sessionAccountTableName = this.getTableName("voice_session_account_log", moduleId, date);
    }

    protected VoiceSessionLogDao(Connection con, int moduleId, String tableName) {
        super(con, tableName, moduleId);
        this.sessionAccountTableName = this.getTableName("voice_session_account", moduleId, null);
    }

    protected VoiceSession getFromRS(ResultSet rs) throws SQLException, BGException {
        return VoiceSessionLogDao.getSessionFromRs(rs);
    }

    public static VoiceSession getSessionFromRs(ResultSet rs) throws SQLException {
        return new VoiceSession().setId(rs.getLong("id")).setContractId(rs.getInt("contractId")).setAccountId(rs.getInt("accountId")).setServiceId(rs.getInt("serviceId")).setCallingStationId(rs.getString("callingStationId")).setE164CallingStationId(rs.getString("e164CallingStationId")).setCalledStationId(rs.getString("calledStationId")).setE164CalledStationId(rs.getString("e164CalledStationId")).setSessionStart((Date)rs.getTimestamp("sessionStart")).setSessionStop((Date)rs.getTimestamp("sessionStop")).setSessionTime(rs.getLong("sessionTime")).setFromPort(rs.getString("fromPort")).setToPort(rs.getString("toPort")).setCdrCallCost(rs.getBigDecimal("cdrCallCost")).setCdrCallOperCost(rs.getBigDecimal("cdrCallOperCost")).setAcctSessionId(rs.getString("acctSessionId")).setRoundedSessionTime(rs.getLong("sessionTimeRound")).setSessionCost(rs.getBigDecimal("sessionCost")).setLastActive((Date)rs.getTimestamp("lastActive")).setDeviceId(rs.getInt("deviceId")).setIdentifier(rs.getString("identifier")).setDestinationId(rs.getInt("destinationId")).setCallType(rs.getShort("callType")).setHour((Date)rs.getTimestamp("hour")).setParentId(rs.getLong("parentId")).setType(rs.getInt("type")).setCodeId(rs.getInt("codeId")).setCostMapItemId(rs.getInt("costMapItemId")).setMinuteCost(rs.getBigDecimal("minuteCost"));
    }

    protected void updateImpl(VoiceSession session) throws BGException, SQLException {
        String query;
        Object fieldPart = this.getFieldPart();
        if (session.getId() > 0L) {
            query = " UPDATE " + this.tableName + (String)fieldPart + " WHERE id = ?";
        } else {
            fieldPart = (String)fieldPart + ", id = ? ";
            long id = this.getNextSessionId();
            session.setId(id);
            query = " INSERT INTO " + this.tableName + (String)fieldPart;
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int idx = 1;
            idx = this.setPsParams(session, ps, idx);
            ps.setLong(idx++, session.getId());
            ps.executeUpdate();
            if (session.getId() <= 0L) {
                session.setId(ServerUtils.lastInsertLongId((PreparedStatement)ps));
            }
        }
    }

    private long getNextSessionId() throws BGException {
        long sessionId;
        try {
            String tableSeq = "voice_session_" + this.moduleId + "_seq";
            PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + tableSeq + " (id) VALUES (NULL)", 1);
            ps.executeUpdate();
            sessionId = ServerUtils.lastInsertLongId((PreparedStatement)ps);
            ps.close();
            if (sessionId % 1000L == 0L) {
                this.clearOldIds(sessionId, tableSeq);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return sessionId;
    }

    private void clearOldIds(long sessionId, String tableSeq) {
        SERVICE.execute(() -> {
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            try {
                con.setAutoCommit(false);
                this.getLogger().info("Clean old id from voice_session_" + this.moduleId + "_seq");
                PreparedStatement ps = con.prepareStatement("DELETE FROM " + tableSeq + " WHERE id<?");
                ps.setLong(1, sessionId - 1000L);
                ps.executeUpdate();
                ps.close();
                this.getLogger().info("End clean old id from " + tableSeq);
                con.commit();
            }
            catch (SQLException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
            }
        });
    }

    private List<Long> getNextSessionIdList(int count) throws BGException {
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            long lastSessionId = 0L;
            String tableSeq = "voice_session_" + this.moduleId + "_seq";
            try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + tableSeq + " SET id=NULL", 1);){
                for (int i = 0; i < count; ++i) {
                    ps.executeUpdate();
                    try (ResultSet generatedKeys = ps.getGeneratedKeys();){
                        while (generatedKeys.next()) {
                            long sessionId = generatedKeys.getLong(1);
                            result.add(sessionId);
                            if (sessionId % 1000L != 0L) continue;
                            lastSessionId = sessionId;
                        }
                        continue;
                    }
                }
            }
            if (lastSessionId > 0L) {
                this.clearOldIds(lastSessionId, tableSeq);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected String getFieldPart() {
        return " SET " + this.FIELDS.stream().map(v -> v + " = ?").collect(Collectors.joining(","));
    }

    protected int setPsParams(VoiceSession session, PreparedStatement ps, int idx) throws SQLException {
        ps.setInt(idx++, session.getContractId());
        ps.setInt(idx++, session.getAccountId());
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)session.getSessionStart()));
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)session.getSessionStop()));
        ps.setBigDecimal(idx++, session.getSessionCost());
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)session.getHour()));
        ps.setString(idx++, session.getCallingStationId());
        ps.setString(idx++, session.getCalledStationId());
        ps.setString(idx++, session.getE164CallingStationId());
        ps.setString(idx++, session.getE164CalledStationId());
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)session.getLastActive()));
        ps.setInt(idx++, session.getDeviceId());
        ps.setLong(idx++, session.getSessionTime());
        ps.setLong(idx++, session.getRoundedSessionTime());
        ps.setString(idx++, session.getIdentifier());
        ps.setInt(idx++, session.getDestinationId());
        ps.setShort(idx++, session.getCallType());
        ps.setString(idx++, session.getAcctSessionId());
        if (session.getParentId() > 0L) {
            ps.setLong(idx++, session.getParentId());
        } else {
            ps.setNull(idx++, 4);
        }
        ps.setInt(idx++, session.getType());
        ps.setString(idx++, session.getFromPort());
        ps.setString(idx++, session.getToPort());
        ps.setInt(idx++, session.getCodeId());
        ps.setInt(idx++, session.getCostMapItemId());
        if (session.getServiceId() > 0) {
            ps.setInt(idx++, session.getServiceId());
        } else {
            ps.setNull(idx++, 4);
        }
        ps.setBigDecimal(idx++, session.getMinuteCost());
        ps.setBigDecimal(idx++, session.getCdrCallCost());
        ps.setBigDecimal(idx++, session.getCdrCallOperCost());
        return idx;
    }

    private int setQueryParams(VoiceSessionFilter filter, PreparedStatement ps, int index) throws SQLException {
        if (filter.getDateFrom() != null) {
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)filter.getDateFrom()));
        }
        if (filter.getDateTo() != null) {
            LocalDateTime time = TimeUtils.convertDateToLocalDateTime((Date)filter.getDateTo()).truncatedTo(ChronoUnit.DAYS).plusDays(1L).minusSeconds(1L);
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)time));
        }
        if (filter.getHourFrom() != null) {
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)filter.getHourFrom()));
        }
        if (filter.getHourTo() != null) {
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)filter.getHourTo()));
        }
        return index;
    }

    public SessionAccountAmount getContractSums(VoiceSessionFilter filter) throws BGException {
        SessionAccountAmount result = new SessionAccountAmount();
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName) || !ServerUtils.tableExists((Connection)this.con, (String)this.sessionAccountTableName)) {
            return result;
        }
        StringBuilder query = new StringBuilder("SELECT SUM(session.sessionTime) as amount, SUM(session.sessionTimeRound) as amountRound,  SUM(session.sessionCost) as account FROM " + this.tableName + " session");
        this.addWherePart(filter, query);
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            this.setQueryParams(filter, ps, index);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Long amount = rs.getLong("amount");
                Long amountRound = rs.getLong("amountRound");
                BigDecimal account = rs.getBigDecimal("account");
                result = new SessionAccountAmount(account, amount);
                result.setAmountRound(amountRound);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<SessionAccountReportItem> getSessionsGroupedByAccount(VoiceSessionFilter filter) throws BGException {
        ArrayList<SessionAccountReportItem> result = new ArrayList<SessionAccountReportItem>();
        String accountBaseTableName = this.getTableName("voice_account_base", this.moduleId, null);
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName) || !ServerUtils.tableExists((Connection)this.con, (String)this.sessionAccountTableName)) {
            return result;
        }
        StringBuilder query = new StringBuilder("SELECT accountBase.title, SUM(sessionAccount.account) as account, SUM(sessionAccount.amount) as amount, COUNT(*)  as count FROM " + this.tableName + " session");
        this.addSesionAccountJoin(filter, query);
        query.append(" LEFT JOIN " + accountBaseTableName + " AS  accountBase ON accountBase.id=session.accountId");
        this.addWherePart(filter, query);
        query.append(" GROUP BY session.accountId");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            this.setQueryParams(filter, ps, index);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String title = rs.getString("title");
                Long amount = rs.getLong("amount");
                BigDecimal account = rs.getBigDecimal("account");
                int count = rs.getInt("count");
                SessionAccountReportItem item = new SessionAccountReportItem();
                item.setTitle(title);
                item.setCost(account != null ? account : BigDecimal.ZERO);
                item.setDuration(amount.longValue());
                item.setCount(count);
                result.add(item);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<SessionDestinationReportItem> getSessionsGroupedByAccountAndDestination(VoiceSessionFilter filter) throws BGException {
        ArrayList<SessionDestinationReportItem> result = new ArrayList<SessionDestinationReportItem>();
        String accountBaseTableName = this.getTableName("voice_account_base", this.moduleId, null);
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName) || !ServerUtils.tableExists((Connection)this.con, (String)this.sessionAccountTableName)) {
            return result;
        }
        StringBuilder query = new StringBuilder("SELECT accountBase.title, SUM(sessionAccount.account) as account, SUM(sessionAccount.amount) as amount, COUNT(*)  as count, destination.title as destination FROM " + this.tableName + " session");
        this.addSesionAccountJoin(filter, query);
        query.append(" LEFT JOIN " + accountBaseTableName + " AS  accountBase ON accountBase.id=session.accountId");
        query.append(" LEFT JOIN voice_destination_" + this.moduleId + " AS  destination ON session.destinationId=destination.id ");
        this.addWherePart(filter, query);
        query.append(" GROUP BY session.accountId, destination.id");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            this.setQueryParams(filter, ps, index);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String title = rs.getString("title");
                String destination = rs.getString("destination");
                Long amount = rs.getLong("amount");
                BigDecimal account = rs.getBigDecimal("account");
                int count = rs.getInt("count");
                SessionDestinationReportItem item = new SessionDestinationReportItem();
                item.setTitle(title);
                item.setCost(account != null ? account : BigDecimal.ZERO);
                item.setDuration(amount.longValue());
                item.setCount(count);
                item.setDestination(destination);
                result.add(item);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<SessionServiceReportItem> getSessionsGroupedByAccountAndService(VoiceSessionFilter filter) throws BGException {
        ArrayList<SessionServiceReportItem> result = new ArrayList<SessionServiceReportItem>();
        String accountBaseTableName = this.getTableName("voice_account_base", this.moduleId, null);
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName) || !ServerUtils.tableExists((Connection)this.con, (String)this.sessionAccountTableName)) {
            return result;
        }
        StringBuilder query = new StringBuilder("SELECT accountBase.title, SUM(sessionAccount.account) as account, SUM(sessionAccount.amount) as amount, COUNT(*)  as count, service.title as service FROM " + this.tableName + " session");
        this.addSesionAccountJoin(filter, query);
        query.append(" LEFT JOIN " + accountBaseTableName + " AS  accountBase ON accountBase.id=session.accountId");
        query.append(" LEFT JOIN service AS  service ON sessionAccount.serviceId=service.id ");
        this.addWherePart(filter, query);
        query.append(" GROUP BY session.accountId, sessionAccount.serviceId");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            this.setQueryParams(filter, ps, index);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String title = rs.getString("title");
                String service = rs.getString("service");
                Long amount = rs.getLong("amount");
                BigDecimal account = rs.getBigDecimal("account");
                int count = rs.getInt("count");
                SessionServiceReportItem item = new SessionServiceReportItem();
                item.setTitle(title);
                item.setCost(account != null ? account : BigDecimal.ZERO);
                item.setDuration(amount.longValue());
                item.setCount(count);
                item.setService(service);
                result.add(item);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<SessionDetail<SessionDetail<SessionDetailReportItem>>> getSessionsDetail(VoiceSessionFilter filter, Page page) throws BGException {
        ArrayList<SessionDetail<SessionDetail<SessionDetailReportItem>>> result = new ArrayList<SessionDetail<SessionDetail<SessionDetailReportItem>>>();
        String accounTableName = this.getTableName("voice_account", this.moduleId, null);
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName) || !ServerUtils.tableExists((Connection)this.con, (String)this.sessionAccountTableName)) {
            return result;
        }
        StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS account.number, session.sessionStart, sessionAccount.account as account, sessionAccount.amount as amount, destination.title as destination, session.e164callingStationId, session.e164calledStationId, sessionAccount.serviceId, session.accountId, service.title as service, session.sessionTimeRound as amountRound FROM " + this.tableName + " as session ");
        this.addSesionAccountJoin(filter, query);
        query.append(" INNER JOIN " + accounTableName + " AS account ON account.id=session.accountId");
        query.append(" LEFT JOIN voice_destination_" + this.moduleId + " AS destination ON session.destinationId=destination.id ");
        query.append(" LEFT JOIN service AS service ON sessionAccount.serviceId=service.id ");
        this.addWherePart(filter, query);
        query.append(" ORDER BY sessionAccount.serviceId, session.accountId, session.e164callingStationId, session.sessionStart ");
        query.append(Page.toSqlLimit((Page)page));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            this.setQueryParams(filter, ps, index);
            try (ResultSet rs = ps.executeQuery();){
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
                int lastServiceId = -1;
                int lastAccountId = -1;
                SessionDetail lastService = null;
                SessionDetail lastAccount = null;
                while (rs.next()) {
                    Timestamp sessionStart = rs.getTimestamp("sessionStart");
                    String destination = rs.getString("destination");
                    String callingStationIdE164 = rs.getString("e164callingStationId");
                    String calledStationIdE164 = rs.getString("e164calledStationId");
                    int amount = rs.getInt("amount");
                    int amountRound = rs.getInt("amountRound");
                    BigDecimal cost = rs.getBigDecimal("account");
                    int serviceId = rs.getInt("serviceId");
                    int accountId = rs.getInt("accountId");
                    String service = rs.getString("service");
                    long number = rs.getLong("number");
                    if (serviceId != lastServiceId) {
                        lastServiceId = serviceId;
                        lastService = new SessionDetail();
                        lastService.setService(service);
                        lastService.setServiceId(serviceId);
                        result.add((SessionDetail<SessionDetail<SessionDetailReportItem>>)lastService);
                        lastAccountId = -1;
                    }
                    if (accountId != lastAccountId) {
                        lastAccount = new SessionDetail();
                        lastAccount.setNumberA(String.valueOf(number));
                        lastAccount.setAccountId(accountId);
                        lastAccountId = accountId;
                        lastService.getResult().add(lastAccount);
                    }
                    SessionDetailReportItem item = new SessionDetailReportItem().setSessionStart((Date)sessionStart).setDestination(destination).setNumberA(callingStationIdE164).setNumberB(calledStationIdE164).setCost(cost != null ? cost : BigDecimal.ZERO).setDuration(amount).setDurationRound(amountRound);
                    lastAccount.getResult().add(item);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public Map<String, SessionDetail> getDetailSumValues(VoiceSessionFilter filter) throws BGException {
        HashMap<String, SessionDetail> resultMap = new HashMap<String, SessionDetail>();
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return resultMap;
        }
        StringBuilder query = new StringBuilder().append("SELECT sessionAccount.serviceId as serviceId, session.accountId as accountId, count(*) as cc, ").append("sum( sessionAccount.account ) as cost, sum( sessionAccount.amount ) as amount, ").append("sum( session.sessionTimeRound ) as amountRound FROM ").append(this.tableName).append(" as session ");
        this.addSesionAccountJoin(filter, query);
        this.addWherePart(filter, query);
        query.append(" GROUP BY serviceId, accountId WITH ROLLUP");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            this.setQueryParams(filter, ps, index);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    SessionDetail detail = new SessionDetail();
                    detail.setSumm(rs.getBigDecimal("cost"));
                    detail.setCount(rs.getInt("cc"));
                    detail.setAmount((long)rs.getInt("amount"));
                    detail.setAmountRound((long)rs.getInt("amountRound"));
                    resultMap.put(rs.getInt("serviceId") + "_" + rs.getInt("accountId"), detail);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return resultMap;
    }

    public List<VoiceSession> list(VoiceSessionFilter filter, Page page, boolean loadSessionAccount) throws BGException {
        ArrayList<VoiceSession> result = new ArrayList<VoiceSession>();
        String accountTableName = this.getTableName("voice_account", this.moduleId, null);
        String accountBaseTableName = this.getTableName("voice_account_base", this.moduleId, null);
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName) || !ServerUtils.tableExists((Connection)this.con, (String)this.sessionAccountTableName)) {
            return result;
        }
        StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS session.*, account.number, contract.title, contract.comment,  accountBase.title as accountTitle");
        if (loadSessionAccount) {
            query.append(", CAST(GROUP_CONCAT(sessionAccount.account) as char(256)) as accounts,").append(" CAST(GROUP_CONCAT(sessionAccount.amount)  as char(256)) as amounts,").append(" CAST(GROUP_CONCAT(sessionAccount.serviceId) as char(256)) as services ");
        }
        query.append(" FROM " + this.tableName + " AS session");
        if (loadSessionAccount) {
            this.addSesionAccountJoin(filter, query);
        }
        query.append(" LEFT JOIN " + accountTableName + " account ON account.id=session.accountId");
        query.append(" LEFT JOIN " + accountBaseTableName + " AS  accountBase ON accountBase.id=session.accountId");
        query.append(" LEFT JOIN contract ON session.contractId = contract.id ");
        this.addWherePart(filter, query);
        if (filter.getGroupMask() != 0L) {
            query.append(" AND contract.gr & " + filter.getGroupMask() + " > 0 ");
        }
        if (!Utils.isEmptyString((String)filter.getContractTitle())) {
            query.append(" AND contract.title like ?");
        }
        if (!Utils.isEmptyString((String)filter.getLogin())) {
            query.append(" AND account.login like ?");
        }
        query.append(" GROUP BY session.contractId, session.id ");
        query.append(" ORDER BY session.sessionStart ");
        query.append(Page.toSqlLimit((Page)page));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            index = this.setQueryParams(filter, ps, index);
            if (!Utils.isEmptyString((String)filter.getContractTitle())) {
                ps.setString(index++, "%" + filter.getContractTitle() + "%");
            }
            if (!Utils.isEmptyString((String)filter.getLogin())) {
                ps.setString(index++, "%" + filter.getLogin() + "%");
            }
            try (ResultSet rs = ps.executeQuery();){
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
                while (rs.next()) {
                    VoiceSession session = this.getFromRS(rs);
                    String contractTitle2 = rs.getString("contract.title");
                    String contractComment = rs.getString("contract.comment");
                    session.setContractTitle(contractTitle2);
                    session.setContractComment(contractComment);
                    session.setAccountTitle(rs.getString("accountTitle"));
                    if (loadSessionAccount) {
                        this.loadAccountAmountFromRs(rs, session);
                    }
                    result.add(session);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private void loadAccountAmountFromRs(ResultSet rs, VoiceSession session) throws SQLException {
        String accountsStr = rs.getString("accounts");
        String amountsStr = rs.getString("amounts");
        String servicesStr = rs.getString("services");
        int contractId = rs.getInt("contractId");
        List accounts = Utils.toBigDecimalList((String)accountsStr);
        List amounts = Utils.toLongList((String)amountsStr);
        List services = Utils.toIntegerList((String)servicesStr);
        HashMap<Integer, VoiceSessionAccount> sessionAccountMap = new HashMap<Integer, VoiceSessionAccount>();
        for (int i = 0; i < accounts.size(); ++i) {
            VoiceSessionAccount account = new VoiceSessionAccount();
            account.setAccount((BigDecimal)accounts.get(i));
            account.setAmount(((Long)amounts.get(i)).longValue());
            account.setServiceId(((Integer)services.get(i)).intValue());
            account.setContractId(contractId);
            account.setSessionId(session.getId());
            account.setHour(session.getHour());
            account.setDeviceId(session.getDeviceId());
            sessionAccountMap.put(account.getServiceId(), account);
        }
        session.setAccountMap(sessionAccountMap);
    }

    private void addSesionAccountJoin(VoiceSessionFilter filter, StringBuilder query) {
        query.append(" LEFT JOIN " + this.sessionAccountTableName + " sessionAccount ON sessionAccount.sessionId=session.id ");
        if (filter.getServiceIds().size() > 0) {
            query.append(" AND sessionAccount.serviceId IN (" + Utils.toString((Iterable)filter.getServiceIds()) + ")");
        }
    }

    private void addWherePart(VoiceSessionFilter filter, StringBuilder query) {
        query.append(" WHERE 1=1 ");
        if (filter.getDateFrom() != null) {
            query.append(" AND  session.sessionStart>=?");
        }
        if (filter.getDateTo() != null) {
            query.append(" AND session.sessionStart<=?");
        }
        if (filter.getHourFrom() != null) {
            query.append(" AND session.hour>=?");
        }
        if (filter.getHourTo() != null) {
            query.append(" AND session.hour<?");
        }
        if (filter.getContractIds().size() > 0) {
            query.append(" AND session.contractId IN (" + Utils.toString((Iterable)filter.getContractIds()) + ")");
        }
        if (filter.getAccountIds().size() > 0) {
            query.append(" AND session.accountId IN (" + Utils.toString((Iterable)filter.getAccountIds()) + ")");
        }
        if (filter.getDeviceIds().size() > 0) {
            query.append(" AND session.deviceId IN (" + Utils.toString((Iterable)filter.getDeviceIds()) + ")");
        }
        if (filter.isOnlyCharged()) {
            query.append(" AND session.sessionCost > 0 ");
        }
        if (filter.getCallType() == VoiceSessionFilter.CallType.INCOMING) {
            query.append(" AND callType = 2");
        } else if (filter.getCallType() == VoiceSessionFilter.CallType.OUTGOING) {
            query.append(" AND callType = 1");
        }
    }

    public static void checkTables(Connection con, int moduleId, Date date) throws BGException {
        try (Statement st = con.createStatement();){
            String tableName = ServerUtils.getModuleMonthTableName((String)TABLE_VOICE_SESSION_LOG, (Date)date, (int)moduleId);
            if (!ServerUtils.tableExists((Connection)con, (String)tableName)) {
                st.executeUpdate(" CREATE TABLE " + tableName + " ( `id` BIGINT(20) NOT NULL,`contractId` int(10) unsigned NOT NULL,`accountId` int(11) NOT NULL,`sessionStart` datetime DEFAULT NULL,`sessionStop` datetime DEFAULT NULL,`sessionCost` decimal(10,5) DEFAULT NULL,`hour` datetime NOT NULL,`callingStationId` varchar(45) NOT NULL,`calledStationId` varchar(45) NOT NULL,`e164CallingStationId` varchar(45) NOT NULL,`e164CalledStationId` varchar(45) NOT NULL,`lastActive` datetime DEFAULT NULL,`deviceId` INT NOT NULL, `sessionTime` INT NOT NULL, `sessionTimeRound` INT(11) NOT NULL,`identifier` varchar(50), `destinationId` INT(11)  NULL DEFAULT NULL, `callType` tinyint(4) NOT NULL,`acctSessionId` VARCHAR(50) NULL, `parentId` BIGINT(20) NULL DEFAULT NULL, `type` INT(11) NULL DEFAULT NULL, `fromPort` VARCHAR(50) NULL DEFAULT NULL,`toPort` VARCHAR(50) NULL DEFAULT NULL,`uploadTime` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (`id`),KEY `account` (`accountId`),KEY `contract` (`contractId`),KEY `sessionStart` (`sessionStart`),KEY `destination` (`destinationId`),KEY `deviceId` (`deviceId`),KEY `hour` (`hour`),`codeId` INT(11) NULL DEFAULT NULL,`costMapItemId` INT(11) NULL DEFAULT NULL,`serviceId` INT(10) UNSIGNED NULL,`minuteCost` DECIMAL(13,5) UNSIGNED NULL DEFAULT NULL,`cdrCallCost` DECIMAL(13,5) NULL DEFAULT NULL,`cdrCallOperCost` DECIMAL(13,5) NULL DEFAULT NULL,CONSTRAINT `fk_" + tableName + "_parent` FOREIGN KEY (`parentId`) REFERENCES `" + tableName + "` (`id`) ON UPDATE CASCADE ON DELETE CASCADE )");
            }
            VoiceSessionAccountLogDao.checkTables(con, moduleId, date);
            try (VoiceTrafficRangeDao trafficRangeDao = new VoiceTrafficRangeDao(con, moduleId);){
                trafficRangeDao.checkTables(con, st, date, moduleId);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void insertSessions(List<VoiceSession> sessions) throws BGException {
        if (sessions.size() == 0) {
            return;
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("sessions.size() = {}", (Object)sessions.size());
        }
        String fieldPart = "(" + this.FIELDS.stream().collect(Collectors.joining(",")) + ", id )";
        String quastions = this.FIELDS.stream().map(v -> "?").collect(Collectors.joining(",")) + ",?";
        StringBuffer query = new StringBuffer(sessions.size() * 4).append("INSERT INTO " + this.tableName + fieldPart + " VALUES ").append(sessions.stream().map(v -> "(" + quastions + ")").collect(Collectors.joining(",")));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            List<Long> sessionIdList = this.getNextSessionIdList(sessions.size());
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("sessionIdList = {}", (Object)Utils.toString(sessionIdList));
            }
            for (int i = 0; i < sessions.size(); ++i) {
                sessions.get(i).setId(sessionIdList.get(i).longValue());
            }
            int idx = 1;
            for (VoiceSession session : sessions) {
                idx = this.setPsParams(session, ps, idx);
                ps.setLong(idx++, session.getId());
            }
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteSessions(LocalDate day, int deviceId) throws SQLException, BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return;
        }
        String query = "DELETE FROM " + this.tableName + " WHERE hour>=? AND hour<? AND deviceId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int idx = 1;
            ps.setTimestamp(idx++, TimeUtils.convertLocalDateToTimestamp((LocalDate)day));
            ps.setTimestamp(idx++, TimeUtils.convertLocalDateToTimestamp((LocalDate)day.plusDays(1L)));
            ps.setInt(idx++, deviceId);
            ps.executeUpdate();
        }
    }

    public void deleteSessions(Date hour, int deviceId) throws SQLException, BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return;
        }
        String query = "DELETE FROM " + this.tableName + " WHERE hour=? AND deviceId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int idx = 1;
            ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)hour));
            ps.setInt(idx++, deviceId);
            ps.executeUpdate();
        }
    }

    public void deleteSessions(int divizer, int remainder, Date hour, int deviceId) throws SQLException, BGException {
        if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            return;
        }
        List<Long> sessionIds = this.getSessionIds(divizer, remainder, hour, deviceId);
        if (sessionIds.size() == 0) {
            return;
        }
        String query = "DELETE FROM " + this.tableName + " WHERE id IN (" + Utils.toString(sessionIds) + ")";
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    private List<Long> getSessionIds(int divizer, int remainder, Date hour, int deviceId) throws SQLException {
        ArrayList<Long> sessionIds = new ArrayList<Long>();
        String query = "SELECT session.id FROM " + this.tableName + " AS session LEFT JOIN contract ON contract.id = session.contractId WHERE ( (contract.scid <= 0 && session.contractId % ? = ?) || ( contract.scid > 0 && contract.sub_mode=1 && contract.scid % ? = ?)) AND session.hour=? and session.deviceId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int idx = 1;
            ps.setInt(idx++, divizer);
            ps.setInt(idx++, remainder);
            ps.setInt(idx++, divizer);
            ps.setInt(idx++, remainder);
            ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)hour));
            ps.setInt(idx++, deviceId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    sessionIds.add(rs.getLong(1));
                }
            }
        }
        return sessionIds;
    }

    public List<VoiceSession> list() throws BGException {
        return super.list("", "", new Object[0]);
    }

    public VoiceSession get(long id) throws BGException {
        try {
            VoiceSession result;
            PreparedStatement ps = this.getByIdPS;
            if (ps == null) {
                ps = this.getByIdPS = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE id=?");
            }
            ps.setLong(1, id);
            try (ResultSet rs = ps.executeQuery();){
                result = rs.next() ? this.getFromRS(rs) : null;
            }
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

