/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.assist.client.AutopaymentContract;
import ru.bitel.bgbilling.modules.assist.client.TransactionContract;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.common.service.AssistService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ServicePropertiesPanel
extends ServicePanel {
    private JTabbedPane tabPane = new JTabbedPane(1);
    private TransactionContract transactionContract = new TransactionContract();
    private AutopaymentContract autopaymentContract = new AutopaymentContract();
    private JLabel recurringLabel = new JLabel("-");
    private BGButton recurringDoButton = new BGButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u043b\u0430\u0442\u0451\u0436 \u0441\u0435\u0439\u0447\u0430\u0441...");
    private BGButton recurringDeleteButton = new BGButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0451\u0436...");
    private String r_amount;

    public ServicePropertiesPanel() {
        this.tabPane.add("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", (Component)((Object)this.transactionContract));
        this.tabPane.add("\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436", (Component)((Object)this.autopaymentContract));
        this.tabPane.addChangeListener(e -> ((BGUPanel)this.tabPane.getSelectedComponent()).performAction("refresh"));
        this.setLayout(new GridBagLayout());
        this.add(this.tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jbInit();
    }

    public void init(int contractId, int moduleId) {
        super.init(contractId, moduleId);
    }

    private void jbInit() {
        this.recurringDoButton.setEnabled(false);
        this.recurringDeleteButton.setEnabled(false);
        JPanel recurringPanel = new JPanel(new GridBagLayout());
        recurringPanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436"));
        recurringPanel.add((Component)this.recurringLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        recurringPanel.add((Component)this.recurringDoButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        recurringPanel.add((Component)this.recurringDeleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.add((Component)recurringPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(tablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.recurringDoButton.addActionListener(e -> this.doRecurring());
        this.recurringDeleteButton.addActionListener(e -> this.deleteRecurring());
    }

    public void setData() {
        ((BGUPanel)this.tabPane.getComponentAt(this.tabPane.getSelectedIndex())).performAction("refresh");
        if (this.getContractId() > -1 && this.getModuleId() > -1) {
            this.recurringLabel.setText("-");
            this.recurringDoButton.setEnabled(false);
            this.recurringDeleteButton.setEnabled(false);
            this.tryCall(() -> {
                for (AssistPaymentRecurring paymentRecurring : ((AssistService)this.getContext().getWebService(AssistService.class)).recurringList(this.getContractId())) {
                    String r_date = TimeUtils.format((Date)paymentRecurring.getDate(), (String)"dd.MM.yyyy HH:mm:ss");
                    String r_ordernumber = paymentRecurring.getOrdernumber() > 0 ? String.valueOf(paymentRecurring.getOrdernumber()) : null;
                    String r_billnumber = paymentRecurring.getBillnumber() > 0L ? String.valueOf(paymentRecurring.getBillnumber()) : null;
                    this.r_amount = Utils.formatCost((BigDecimal)paymentRecurring.getAmount());
                    String r_recurringMaxDate = TimeUtils.format((Date)paymentRecurring.getRecurringMaxDate(), (String)"dd.MM.yyyy");
                    if (Utils.isBlankString((String)r_billnumber)) {
                        r_billnumber = "\u041d\u0415 \u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d";
                        this.recurringDoButton.setEnabled(false);
                        this.recurringDeleteButton.setEnabled(true);
                    } else {
                        this.recurringDoButton.setEnabled(true);
                        this.recurringDeleteButton.setEnabled(true);
                    }
                    this.recurringLabel.setText("billnumber: " + r_billnumber + ", \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d: " + r_date + ", \u0432 \u0437\u0430\u043a\u0430\u0437\u0435: " + r_ordernumber + " (\u0441\u0443\u043c\u043c\u0430 " + this.r_amount + "), \u0434\u043e \u0434\u0430\u0442\u044b: " + r_recurringMaxDate);
                }
            });
        }
    }

    public void editItem() {
        ((BGUPanel)this.tabPane.getComponentAt(this.tabPane.getSelectedIndex())).performAction("edit");
    }

    private void doRecurring() {
        String sum = JOptionPane.showInputDialog("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430", (Object)this.r_amount);
        if (sum != null) {
            this.tryCall(() -> {
                ((AssistService)this.getContext().getWebService(AssistService.class)).recurringDo(this.getContractId(), new BigDecimal(sum));
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436 \u0437\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d");
            });
        }
    }

    private void deleteRecurring() {
        if (ClientUtils.confirmDelete((Object)"\u0440\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436")) {
            this.tryCall(() -> {
                ((AssistService)this.getContext().getWebService(AssistService.class)).recurringDelete(this.getContractId());
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436 \u0443\u0434\u0430\u043b\u0451\u043d");
                this.setData();
            });
        }
    }
}

