/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.StringReader;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.client.common.BGControlPanelContractSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelMonth;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.bean.Writable;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.modules.bill.client.bean.BGBillTable;
import ru.bitel.bgbilling.modules.bill.common.bean.DocTypes;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;

public class ServiceConfigBillGenerate
extends ServiceConfigTabbedPanel {
    private BGBillTable table;
    private Calendar currentCalendar = new GregorianCalendar();
    private BGControlPanelMonth month = new BGControlPanelMonth(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    private ContractLabelTree contractLabelTree = new ContractLabelTree();
    private BGControlPanelListSelect docTypeList = new BGControlPanelListSelect();
    private BGControlPanelContractSelect contract = new BGControlPanelContractSelect();
    private boolean isInvoice = false;
    private BGUComboBox<KeyValue> documentType = new BGUComboBox();
    private BGFloatTextField ftfFrom = new BGFloatTextField();
    private BGFloatTextField ftfTo = new BGFloatTextField();
    private boolean isAll = true;
    private List<KeyValue> documentTypeItems = Arrays.asList(new KeyValue("bill", "\u0421\u0447\u0435\u0442\u0430"), new KeyValue("invoice", "\u0421\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0410\u043a\u0442\u044b, \u0423\u041f\u0414"));

    public ServiceConfigBillGenerate() {
        this(true);
    }

    public ServiceConfigBillGenerate(boolean isAll) {
        this.isAll = isAll;
        this.jbInit();
    }

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)(this.isAll ? new BGSplitPaneNoBorder(1, (Component)this.getFilterPanel(), (Component)this.getTablePanel(), 400L) : this.getTablePanel()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getFilterPanel() {
        JTabbedPane filtersPanel = new JTabbedPane();
        JPanel contractFilters = new JPanel(new GridBagLayout());
        contractFilters.add((Component)this.contract, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 2, 3, 2), 0, 0));
        contractFilters.add((Component)new JScrollPane((Component)this.contractLabelTree), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel conditionsPanel = new JPanel(new GridBagLayout());
        JPanel balancePanel = new JPanel(new GridBagLayout());
        balancePanel.setBorder((Border)new BGTitleBorder("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a"));
        balancePanel.add((Component)new JLabel("\u041e\u0442 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        balancePanel.add((Component)this.ftfFrom, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        balancePanel.add((Component)new JLabel(" \u0434\u043e: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        balancePanel.add((Component)this.ftfTo, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.ftfFrom.setText("");
        this.ftfTo.setText("");
        conditionsPanel.add((Component)balancePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        conditionsPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filtersPanel.addTab("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b/\u043c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", contractFilters);
        filtersPanel.addTab("\u0422\u0438\u043f\u044b", (Component)this.docTypeList);
        filtersPanel.addTab("\u0423\u0441\u043b\u043e\u0432\u0438\u044f", conditionsPanel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setPreferredSize(new Dimension(278, 335));
        panel.setMinimumSize(new Dimension(278, 335));
        panel.add((Component)filtersPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        this.table = new BGBillTable(this, this.isAll);
        this.documentType.setData(this.documentTypeItems);
        this.documentType.addActionListener(e -> this.buildDocType());
        JButton generateButton = new JButton("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        generateButton.addActionListener(e -> this.getTemplateBillList(false));
        JButton generateAndCreateButton = new JButton("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c + \u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        generateAndCreateButton.addActionListener(e -> {
            if (ClientUtils.confirm((String)"\u0414\u0430\u043d\u043d\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043f\u0440\u0438\u0432\u0435\u0434\u0435\u0442 \u043a \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u043c\u0443 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044e \u0441\u0447\u0435\u0442\u043e\u0432 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 \u0431\u0435\u0437 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438\u0445 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e! \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?", (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435")) {
                this.getTemplateBillList(true);
            }
        });
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)this.month, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u0422\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        topPanel.add((Component)this.documentType, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)generateButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)generateAndCreateButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add(Box.createHorizontalStrut(1), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)topPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)((Object)this.table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.table.init(module, moduleId);
        this.contract.init(module, moduleId);
    }

    public void setData() {
        this.tryCall(() -> {
            this.contractLabelTree.setData(((ContractLabelService)this.getContext().getPort(ContractLabelService.class, 0)).getContractLabelTreeItemList(-1, false));
            this.table.setData(null);
            this.buildDocType();
        });
    }

    private void buildDocType() {
        this.tryCall(() -> {
            DocumentType documentType = DocumentType.valueOf((String)((KeyValue)this.documentType.getSelectedItem()).getKey().toUpperCase());
            DocTypes docTypes = ((BillService)this.getContext().getWebService(BillService.class, this.getContext().getModuleId())).documentTypes(this.getContext().getContractId(), documentType);
            this.docTypeList.getListModel().removeAllElements();
            this.docTypeList.getListModel().addAll(docTypes.getAvaliableList().stream().map(a -> new BGUListItem(a)).toList());
        });
    }

    public void setDocumentTypeSelectedIndex(int index) {
        this.documentType.setSelectedIndex(index);
    }

    public void setTableSelectedIndex(int index) {
        this.table.setTableSelection(index, index);
    }

    public void setTableSelectionV() {
        this.table.setTableSelectionV();
    }

    public void getTemplateBillList(boolean andCreate) {
        try {
            Object cids = this.isAll ? this.contract.getContracts() : "" + this.getContractId();
            this.getTemplateBillList(andCreate, (String)cids, ((KeyValue)this.documentType.getSelectedItem()).getKey(), -1, this.docTypeList.getListValues(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getTemplateBillList(boolean andCreate, String cids, String typeDocument, int documentId, String documentTypeIds, String typeDocumentFrom) throws Exception {
        if (andCreate || ClientUtils.confirm((String)"\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b?\n\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u044d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u043d\u044f\u0442\u044c \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f.", (String)"\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f")) {
            String doc;
            this.currentCalendar.setTime(TimeUtils.convertLocalDateToDate((LocalDate)this.month.getLocalDate()));
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("bill".equals(typeDocument) ? "BillPositionList" : "InvoicePositionList");
            request.setAttribute("mm", this.currentCalendar.get(2));
            request.setAttribute("month", TimeUtils.formatDate((Calendar)this.currentCalendar));
            Document document = this.getDocument(request);
            this.table.setPositionList(XMLUtils.getElement((Document)document, (String)"positions"));
            request = new Request();
            request.setModule(this.module);
            request.setAction("GetTemplateBillList");
            request.setAttribute("type", typeDocument);
            request.setModuleId(this.getModuleId());
            request.setAttribute("gr", Utils.toString((Iterable)this.contractLabelTree.getSelectedIds()));
            request.setAttribute("cids", cids);
            request.setAttribute("y", this.currentCalendar.get(1));
            request.setAttribute("m", this.currentCalendar.get(2));
            request.setAttribute("doc_types", documentTypeIds);
            request.setAttribute("outgoing", this.ftfFrom.getText() + ";" + this.ftfTo.getText());
            request.setAttribute("andCreate", andCreate);
            if (andCreate) {
                int organizationId = this.table.getOrganizationId();
                request.setAttribute("organization_id", organizationId);
                request.setAttribute("account_id", this.table.getAccountId(organizationId));
            }
            request.setAttribute("documentId", documentId);
            if (typeDocumentFrom != null) {
                request.setAttribute("typeDocumentFrom", typeDocumentFrom);
            }
            if ((doc = TransferManager.getString((Request)request)).length() > 500) {
                this.isInvoice = typeDocument.equals("invoice");
                this.table.updateData(doc, this.isInvoice);
            } else {
                Document realDoc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(doc)));
                if (ClientUtils.checkStatus((Document)realDoc)) {
                    this.isInvoice = typeDocument.equals("invoice");
                    this.table.updateData(doc, this.isInvoice);
                }
            }
        }
    }

    public void generateBills(Writable billsXML, String date) {
        Request request = new Request();
        request.setAction(this.isInvoice ? "GenerateInvoices" : "GenerateBills");
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAttribute("bills_x", (Object)billsXML);
        request.setAttribute("date", date);
        request.setAttribute("y", this.currentCalendar.get(1));
        request.setAttribute("m", this.currentCalendar.get(2));
        Document doc = this.getDocument(request);
        ClientUtils.checkStatus((Document)doc);
    }

    public Element getBillPosList(int id) {
        Element result = null;
        Request request = new Request();
        request.setAction("GetBillPositionValues");
        request.setAttribute("id", id);
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAttribute("y", this.currentCalendar.get(1));
        request.setAttribute("m", this.currentCalendar.get(2));
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            result = XMLUtils.getElement((Document)doc, (String)"bill");
        }
        return result;
    }

    public void setContractId(int id) {
        super.setContractId(id);
        this.table.setContractId(id);
    }
}

