/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.common;

import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.Fiscalizator;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.IdTitle;

@XmlSeeAlso(value={IdTitle.class})
public class Printer
extends IdTitle
implements Cloneable {
    private boolean hidden;
    private boolean autoclose;
    private int autoclosePass;
    private FiscalizatorType fiscalizatorType;
    private ParameterMap config = new ParameterMap.DefaultParameterMap(new HashMap());
    private String checkbuilder;
    private int pass;
    public static int EMPTY_SKIP_PRINTER_ID = Integer.MIN_VALUE;

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isAutoclose() {
        return this.autoclose;
    }

    public void setAutoclose(boolean autoclose) {
        this.autoclose = autoclose;
    }

    public int getAutoclosePass() {
        return this.autoclosePass;
    }

    public void setAutoclosePass(int autoclosePass) {
        this.autoclosePass = autoclosePass;
    }

    public void switchPrinter(Printer printer) {
        this.setId(printer.getId());
        this.setTitle(printer.getTitle());
        this.hidden = printer.hidden;
        this.autoclose = printer.autoclose;
        this.autoclosePass = printer.autoclosePass;
        this.fiscalizatorType = printer.fiscalizatorType;
        this.config = printer.config;
        this.checkbuilder = printer.checkbuilder;
        this.pass = printer.pass;
    }

    public Printer clone() {
        Printer p = new Printer();
        p.switchPrinter(this);
        return p;
    }

    public Fiscalizator fiscalize() throws BGException {
        return Fiscalizator.getFiscalizatorImpl((FiscalizatorType)this.fiscalizatorType, (Printer)this);
    }

    public void setFiscalizatorType(FiscalizatorType fiscalizatorType) {
        this.fiscalizatorType = fiscalizatorType;
    }

    public FiscalizatorType getFiscalizatorType() {
        return this.fiscalizatorType;
    }

    public ParameterMap getConfig() {
        return this.config;
    }

    public void setConfig(ParameterMap config) {
        this.config = config;
    }

    public String getCheckbuilder() {
        return this.checkbuilder;
    }

    public void setCheckbuilder(String checkbuilder) {
        this.checkbuilder = checkbuilder;
    }

    public int getPass() {
        return this.pass;
    }

    public void setPass(int pass) {
        this.pass = pass;
    }

    public static Printer empty() {
        Printer empty = new Printer();
        empty.setTitle("<empty>");
        return empty;
    }

    public void skip() throws BGException {
        this.setId(EMPTY_SKIP_PRINTER_ID);
        this.setTitle("skip printer");
        this.fiscalizatorType = FiscalizatorType.empty;
    }

    public static enum FiscalizatorType {
        cashcheckserver,
        empty,
        atolonlinev4,
        atolonlinev5,
        dyncode,
        fermaofdru,
        komtet;

    }
}

