/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.service;

import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Channel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.PacketChannel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.PacketService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.TariffRequestManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.GetClosePacketDatesEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.GetOpenPacketDatesEvent;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.CollectionMapConverter;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Pair;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cerbercrypt.common.service.PacketService")
public class PacketServiceImpl
extends AbstractService
implements PacketService {
    public List<Packet> packetList(Boolean isVirtualCinema) throws BGException {
        if (isVirtualCinema == null) {
            return new PacketManager(this.getConnection(), this.moduleId).getPacketList();
        }
        return new PacketManager(this.getConnection(), this.moduleId).getPacketList(isVirtualCinema);
    }

    public void deletePacket(int id) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        List<CardPacket> cps = new CardPacketManager(this.getConnection(), this.moduleId).getCardPacketListByPacketId(id);
        if (cps.size() > 0) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u043a\u0435\u0442, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 " + cps.size() + " \u043a\u0430\u0440\u0442\u043f\u0430\u043a\u0435\u0442\u0430\u0445.");
        }
        new PacketManager(this.getConnection(), this.moduleId).deletePacket(id);
        new PacketChannelManager(this.getConnection(), this.moduleId).deletePacketChannels(id);
    }

    public int updatePacket(Packet packet) throws BGException {
        if (packet == null || Utils.isEmptyString((String)packet.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (packet.getId() > 0 && packet.getServiceId() <= 0) {
            throw new BGMessageException("\u0423\u0441\u043b\u0443\u0433\u0443 \u043d\u0430\u0434\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c, \u0438\u043d\u0430\u0447\u0435 \u043f\u0430\u043a\u0435\u0442 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0442\u0430\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f");
        }
        new PacketManager(this.getConnection(), this.moduleId).updatePacket(packet);
        return packet.getId();
    }

    public void deletePacketChannel(int id) throws BGException {
        if (id < 0) {
            throw new BGIllegalArgumentException();
        }
        new PacketChannelManager(this.getConnection(), this.moduleId).deletePacketChannel(id);
    }

    public PacketChannel getPacketChannel(int id) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        return new PacketChannelManager(this.getConnection(), this.moduleId).getPacketChannelById(id);
    }

    public void updatePacketChannel(PacketChannel packetChannel) throws BGException {
        if (packetChannel.getId() < 0 || packetChannel.getPacketId() <= 0 || packetChannel.getChannelId() <= 0) {
            throw new BGIllegalArgumentException();
        }
        new PacketChannelManager(this.getConnection(), this.moduleId).updatePacketChannel(packetChannel);
    }

    public Packet getPacket(int packetId) throws BGException {
        if (packetId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return new PacketManager(this.getConnection(), this.moduleId).getPacketById(packetId);
    }

    public List<PacketChannel> packetChannelTable(int packetId) throws BGException {
        if (packetId <= 0) {
            throw new BGIllegalArgumentException();
        }
        Map<Integer, Channel> channelMap = new ChannelManager(this.getConnection(), this.moduleId).getChannelMap();
        List<PacketChannel> channelList = new PacketChannelManager(this.getConnection(), this.moduleId).getPacketChannelList(packetId);
        for (PacketChannel packetChannel : channelList) {
            Channel channel = channelMap.get(packetChannel.getChannelId());
            if (channel != null) {
                packetChannel.setChannelTitle(channel.getTitle());
                continue;
            }
            packetChannel.setChannelTitle("???");
        }
        return channelList;
    }

    public void packetOfferingList(int cid, int usercardId, boolean virtualCinema, Holder<List<Packet>> packetList, Holder<MapHolder<String, Object>> params) throws BGException {
        this.tryCall(() -> {
            GregorianCalendar now = new GregorianCalendar();
            UserCardManager ucm = new UserCardManager(this.getConnection(), this.moduleId, this.userId);
            PacketManager pm = new PacketManager(this.getConnection(), this.moduleId);
            UserCard userCard = (UserCard)ucm.get(usercardId);
            Set<Integer> packetGroup = null;
            if (userCard != null && userCard.getContractId() == cid) {
                TariffRequestManager trm = new TariffRequestManager(this.getConnectionSet(), this.moduleId);
                packetGroup = trm.getPacketGroup((ParameterMap)this.getModuleSetup(), cid, now);
            }
            List<PacketChannel> pc = new PacketChannelManager(this.getConnection(), this.moduleId).getPacketChannelList(now);
            Map mapPacketChannelList = new CollectionMapConverter<PacketChannel, Integer, Integer>(this){

                protected Pair<Integer, Integer> convert(PacketChannel f) {
                    return new Pair((Object)f.getPacketId(), (Object)f.getChannelId());
                }
            }.getMapOfList(pc);
            HashMap<Integer, Packet> packetMap = new HashMap<Integer, Packet>();
            ArrayList<Packet> result = new ArrayList<Packet>();
            for (Packet packet : pm.getPacketList()) {
                List lpc;
                packetMap.put(packet.getId(), packet);
                if (!packet.isCanWebOpen() && !packet.isCanWebClose() || virtualCinema != packet.isVirtualCinema()) continue;
                result.add(packet);
                if (packetGroup != null && packetGroup.contains(packet.getId())) {
                    packet.setPacketGroup(true);
                }
                packet.setChannelCount((lpc = (List)mapPacketChannelList.get(packet.getId())) != null ? lpc.size() : 0);
            }
            if (params != null) {
                params.value = new MapHolder();
                GetOpenPacketDatesEvent dateOpenListEvent = new GetOpenPacketDatesEvent(this.userId, this.moduleId, cid, userCard.getId(), new Date());
                dateOpenListEvent = (GetOpenPacketDatesEvent)EventProcessor.getInstance().request((QueueEvent)dateOpenListEvent);
                if (dateOpenListEvent.getDateList() != null) {
                    ((MapHolder)params.value).getMap().put("date_list_open", dateOpenListEvent.getDateList());
                }
                GetClosePacketDatesEvent dateCloseListEvent = new GetClosePacketDatesEvent(this.userId, this.moduleId, cid, userCard.getId(), new Date());
                dateCloseListEvent = (GetClosePacketDatesEvent)EventProcessor.getInstance().request((QueueEvent)dateCloseListEvent);
                if (dateCloseListEvent.getDateList() != null) {
                    ((MapHolder)params.value).getMap().put("date_list_close", dateCloseListEvent.getDateList());
                }
            }
            packetList.value = result;
        });
    }
}

