/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.dba.common.bean.GenerateScriptParameters;
import ru.bitel.bgbilling.modules.dba.common.bean.TableInfo;
import ru.bitel.bgbilling.modules.dba.common.bean.enums.ScriptType;
import ru.bitel.bgbilling.modules.dba.common.service.DBAService;
import ru.bitel.bgbilling.modules.dba.server.bean.BashScriptGenerator;
import ru.bitel.bgbilling.modules.dba.server.bean.BatchScriptGenerator;
import ru.bitel.bgbilling.modules.dba.server.bean.ScriptGenerator;
import ru.bitel.bgbilling.modules.dba.server.bean.TableConfigItem;
import ru.bitel.bgbilling.modules.dba.server.bean.TableConfigManager;
import ru.bitel.bgbilling.modules.dba.server.bean.TableRefManager;
import ru.bitel.bgbilling.modules.dba.server.bean.TableTaskDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.dba.common.service.DBAService")
public class DBAServiceImpl
extends AbstractService
implements DBAService {
    public List<TableInfo> tableInfoList() throws BGException {
        return (List)this.tryReturn(() -> {
            ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
            List<String> kernelTableNames = Arrays.asList("contract_period_job_log", "data_log_error", "log_function_process", "log_gscript_process", "payment_register_item", "reserve_job_log", "tariff_option_job_log", "web_query_log", "bgs_query_log", "charge_register_item");
            String taskTableName = "dba_table_task_" + this.moduleId;
            Map moduleMap = ModuleCache.getInstance().getModuleMap();
            try (Statement st = this.getConnection().createStatement();
                 Statement stTask = this.getConnection().createStatement();
                 ResultSet rs = st.executeQuery("SHOW TABLES");
                 ResultSet rsTask = stTask.executeQuery("SELECT * FROM " + taskTableName);){
                HashMap<String, Integer> autoValue = new HashMap<String, Integer>();
                JSONArray autoConfig = new JSONArray(ServerUtils.getSetupValue((Connection)this.getConnection(), (String)("dba.auto.archive.config." + this.moduleId), (String)"[]"));
                int len = autoConfig.length();
                for (int index = 0; index < len; ++index) {
                    JSONObject json = autoConfig.getJSONObject(index);
                    autoValue.put(json.getString("tableNameMask"), json.getInt("autoValue"));
                }
                HashSet<String> taskNameSet = new HashSet<String>();
                while (rsTask.next()) {
                    taskNameSet.add(rsTask.getString(1));
                }
                while (rs.next()) {
                    String tableNamePrefix;
                    String tableName = rs.getString(1);
                    if (!tableName.matches(".*_\\d{6}$") && !tableName.matches(".*_\\d{8}$")) continue;
                    TableInfo tableInfo = new TableInfo();
                    tableInfo.setTableName(tableName);
                    tableInfo.setComponentId(Utils.parseInt((String)tableName.replaceAll(".*_(\\d+)_\\d+$", "$1"), (int)-1));
                    tableInfo.setInArchive(taskNameSet.contains(tableName));
                    tableInfo.setAutoArchive(autoValue.getOrDefault(tableName.replaceAll("^(.+)_\\d+$", "$1"), 0).intValue());
                    String componentName = null;
                    if (tableInfo.getComponentId() > 0) {
                        BGModule bgModule = moduleMap.getOrDefault(tableInfo.getComponentId(), null);
                        String string = componentName = bgModule != null ? bgModule.getTitle() : null;
                    }
                    if (componentName == null && kernelTableNames.contains(tableNamePrefix = tableName.replaceAll("(.*)_\\d+$", "$1"))) {
                        tableInfo.setComponentId(0);
                        componentName = "\u042f\u0434\u0440\u043e";
                    }
                    tableInfo.setComponentName(componentName);
                    tableInfos.add(tableInfo);
                }
            }
            return tableInfos;
        });
    }

    public void tableInArchiveUpdate(List<String> tableNames, boolean value) throws BGException {
        if (Utils.isEmptyCollection(tableNames)) {
            return;
        }
        this.tryCall(() -> new TableTaskDao(this.getConnection(), this.moduleId).tableInArchiveUpdate(tableNames, value));
    }

    public void tableAutoarchiveUpdate(Set<String> tableNameMaskSet, int autoValue) throws BGException {
        if (tableNameMaskSet != null) {
            String name = "dba.auto.archive.config." + this.moduleId;
            String configText = ServerUtils.getSetupValue((Connection)this.getConnection(), (String)name, (String)"[]");
            JSONArray configArray = new JSONArray(configText);
            block0: for (String tableNameMask : tableNameMaskSet) {
                if (autoValue == 0) {
                    int len = configArray.length();
                    for (int index = 0; index < len; ++index) {
                        JSONObject obj = configArray.getJSONObject(index);
                        if (!tableNameMask.equals(obj.optString("tableNameMask"))) continue;
                        configArray.remove(index);
                        continue block0;
                    }
                    continue;
                }
                JSONObject json = null;
                int len = configArray.length();
                for (int index = 0; index < len; ++index) {
                    JSONObject obj = configArray.getJSONObject(index);
                    if (!tableNameMask.equals(obj.optString("tableNameMask"))) continue;
                    json = obj;
                    break;
                }
                if (json == null) {
                    json = new JSONObject();
                    json.put("tableNameMask", (Object)tableNameMask);
                    configArray.put((Object)json);
                }
                json.put("autoValue", autoValue);
            }
            ServerUtils.setSetupValue((Connection)this.getConnection(), (String)name, (String)configArray.toString());
        }
    }

    public String generateScript(GenerateScriptParameters generateScriptParameters) throws BGException {
        return (String)this.tryReturn(() -> {
            if (this.moduleId <= 0 || Utils.isBlankString((String)generateScriptParameters.getMysqlCommand()) || Utils.isBlankString((String)generateScriptParameters.getMysqlDumpCommand()) || Utils.isBlankString((String)generateScriptParameters.getBackupPath()) || generateScriptParameters.getType() == null) {
                throw new BGIllegalArgumentException();
            }
            ScriptGenerator generator = null;
            if (generateScriptParameters.getType() == ScriptType.BASH) {
                generator = new BashScriptGenerator(Setup.getSetup(), this.getConnection(), this.moduleId);
            } else if (generateScriptParameters.getType() == ScriptType.BATCH) {
                generator = new BatchScriptGenerator(Setup.getSetup(), this.getConnection(), this.moduleId);
            }
            generator.setMysqlCommand(generateScriptParameters.getMysqlCommand());
            generator.setMysqlDumpCommand(generateScriptParameters.getMysqlDumpCommand());
            generator.setBackupPath(generateScriptParameters.getBackupPath());
            return generator.getScript();
        });
    }

    public String tableConfigTreeData() throws BGException {
        return (String)this.tryReturn(() -> {
            Document rootDoc = XMLUtils.newDocument();
            Element rootNode = XMLUtils.createElement((Document)rootDoc, (String)"data");
            TableRefManager tableRefManager = new TableRefManager();
            TableConfigManager tableConfigManager = new TableConfigManager(this.getConnection(), this.moduleId);
            Element tableRef = XMLUtils.createElement((Element)rootNode, (String)"table_ref");
            Map<String, Document> docMap = tableRefManager.getModulesDocMap();
            ArrayList<BGModule> moduleList = new ArrayList<BGModule>();
            moduleList.addAll(ModuleCache.getInstance().getModulesList());
            BGModule kernelModule = new BGModule().setId(0).setTitle("\u042f\u0434\u0440\u043e").setName("kernel");
            moduleList.add(0, kernelModule);
            for (BGModule module : moduleList) {
                int mid = module.getId();
                String title = module.getTitle();
                Element moduleEl = rootNode.getOwnerDocument().createElement("module");
                moduleEl.setAttribute("id", String.valueOf(mid));
                moduleEl.setAttribute("title", title);
                Document doc = docMap.get(module.getName());
                if (doc == null) continue;
                Element data = XMLUtils.getElement((Document)doc, (String)"data");
                NodeList childs = data.getChildNodes();
                int size = childs.getLength();
                for (int i = 0; i < size; ++i) {
                    Node child = childs.item(i);
                    moduleEl.appendChild(moduleEl.getOwnerDocument().importNode(child, true));
                }
                tableRef.appendChild(moduleEl);
            }
            Element config = XMLUtils.createElement((Element)rootNode, (String)"table_conf");
            List<TableConfigItem> itemList = tableConfigManager.getConfigItemList();
            for (TableConfigItem item : itemList) {
                Element itemEl = XMLUtils.createElement((Element)config, (String)"item");
                itemEl.setAttribute("mid", String.valueOf(item.getModuleId()));
                itemEl.setAttribute("tid", String.valueOf(item.getTableId()));
                itemEl.setAttribute("data", item.getData());
            }
            return Base64.encodeUTF8((String)XMLUtils.serializeToString((Node)rootNode, (boolean)false));
        });
    }

    public void treeConfigUpdate(int tableModuleId, int tableId, String config) throws BGException {
        if (tableModuleId < 0 || tableId <= 0) {
            throw new BGIllegalArgumentException("(tableModuleId = " + tableModuleId + ") < 0 || (tableId = " + tableId + " ) <= 0");
        }
        this.tryCall(() -> new TableConfigManager(this.getConnection(), this.moduleId).updateConfigItem(new TableConfigItem().setModuleId(tableModuleId).setTableId(tableId).setData(config)));
    }
}

