/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.filestorage.common.bean;

import java.util.Date;
import java.util.Objects;
import org.json.JSONObject;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Idable;

public class BGServerFile
implements Idable,
Cloneable {
    private int id;
    private int ownerId;
    private int contractId;
    private int userId = -1;
    private long size = -1L;
    private Date date = null;
    private String title = null;
    private String comment = null;
    private String uuid = "";

    public BGServerFile clone() {
        try {
            BGServerFile copy = (BGServerFile)super.clone();
            copy.setId(0);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public int getContractId() {
        return this.contractId;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public long getSize() {
        return this.size;
    }

    public String getTitle() {
        return this.title;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public BGServerFile setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public BGServerFile setContractId(int contractId) {
        this.contractId = contractId;
        return this;
    }

    public BGServerFile setDate(Date date) {
        this.date = date;
        return this;
    }

    public BGServerFile setId(int id) {
        this.id = id;
        return this;
    }

    public BGServerFile setOwnerId(int ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public BGServerFile setSize(long size) {
        this.size = size;
        return this;
    }

    public BGServerFile setTitle(String title) {
        this.title = title;
        return this;
    }

    public BGServerFile setUserId(int userId) {
        this.userId = userId;
        return this;
    }

    public BGServerFile setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public static void fromJSON(JSONObject jsonObject, BGServerFile bgServerFile) {
        Objects.requireNonNull(jsonObject);
        Objects.requireNonNull(bgServerFile);
        bgServerFile.setId(jsonObject.optInt("id"));
        bgServerFile.setOwnerId(jsonObject.optInt("ownerId"));
        bgServerFile.setContractId(jsonObject.optInt("contractId"));
        bgServerFile.setUserId(jsonObject.optInt("userId"));
        bgServerFile.setSize(jsonObject.optLong("size"));
        bgServerFile.setDate(TimeUtils.parseDate(jsonObject.optString("date"), "dd.MM.yyyy HH:mm:ss"));
        bgServerFile.setTitle(jsonObject.optString("title"));
        bgServerFile.setComment(jsonObject.optString("comment"));
        bgServerFile.setUuid(jsonObject.optString("uuid"));
    }

    public static void toJSON(BGServerFile bgServerFile, JSONObject jsonObject) {
        Objects.requireNonNull(jsonObject);
        Objects.requireNonNull(bgServerFile);
        jsonObject.put("id", bgServerFile.getId());
        jsonObject.put("ownerId", bgServerFile.getOwnerId());
        jsonObject.put("contractId", bgServerFile.getContractId());
        jsonObject.put("userId", bgServerFile.getUserId());
        jsonObject.put("size", bgServerFile.getSize());
        jsonObject.put("date", (Object)TimeUtils.format(bgServerFile.getDate(), "dd.MM.yyyy HH:mm:ss"));
        jsonObject.put("title", (Object)bgServerFile.getTitle());
        jsonObject.put("comment", (Object)bgServerFile.getComment());
        jsonObject.put("uuid", (Object)bgServerFile.getUuid());
    }
}

