/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import bitel.billing.server.Action;
import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.WebRequestCounter;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.util.captcha.Captcha;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.web.common.bean.WebMenuItem;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebMenuDao;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionLogEntry;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGActionLogManager;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionHandler;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractFace;
import ru.bitel.bgbilling.kernel.contract.api.server.Module;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.kernel.contract.dashboard.common.bean.DashboardItem;
import ru.bitel.bgbilling.kernel.contract.dashboard.common.bean.DashboardItemType;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.WebMenuListEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.pc.server.BGPCServlet;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.WebMenuBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.worker.ThreadContext;

@BGPCServlet
@WebServlet(name="webexecuter", urlPatterns={"/webexecuter/*"})
public class WebExecuter
extends CommonExecutor {
    private final Logger logger = LogManager.getLogger();
    private WebRequestCounter requestCounter;
    private ActionHandler actionHandler;
    private Map<Object, Class<? extends WebMenuBase>> menuMap = new HashMap<Object, Class<? extends WebMenuBase>>(64);
    private final String WEB_MENU_CACHE_KEY = "webMenu";

    @Override
    public void init() {
        this.setup = Setup.getSetup();
        this.requestCounter = new WebRequestCounter(this.setup);
        this.actionHandler = new ActionHandler();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.redirectByPath(request, response)) {
            return;
        }
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        HttpSession session = request.getSession(true);
        request.setAttribute("setup", (Object)this.setup);
        request.setAttribute("response", (Object)response);
        request.setAttribute("contextPath", (Object)this.setup.get("context.path", "/bgbilling"));
        WebExecuter.rememberBackUrl(request);
        String tab = WebExecuter.getParameter(request, "tab", null);
        Optional.ofNullable(tab).ifPresent(a -> request.setAttribute("tab", a));
        try {
            Integer clid;
            String[] paths;
            String module = WebExecuter.getParameter(request, "module", "contract.dashboard");
            String mid = WebExecuter.getParameter(request, "mid", "0");
            String action = WebExecuter.getParameter(request, "action", "Dashboard");
            String operation = WebExecuter.getParameter(request, "operation", "execute");
            String pathInfo = request.getPathInfo();
            if (pathInfo != null && (paths = pathInfo.split("/")) != null && paths.length > 1 && paths[1].matches("^[mpbdu]\\d*$")) {
                module = switch (paths[1].substring(0, 1)) {
                    case "b" -> "contract.basic";
                    case "d" -> "contract.dashboard";
                    case "m" -> {
                        mid = paths[1].substring(1);
                        yield ModuleCache.getInstance().optModule(Utils.parseInt((String)mid, (int)0)).map(a -> a.getInstalledModule().getName()).orElse(module);
                    }
                    case "p" -> {
                        mid = paths[1].substring(1);
                        yield ModuleCache.getInstance().getPluginName(Utils.parseInt((String)mid, (int)0));
                    }
                    default -> module;
                };
                action = this.getPathParam(paths, 2, action);
                operation = this.getPathParam(paths, 3, operation);
            }
            Document doc = null;
            Element rootNode = null;
            this.logRequest(request);
            doc = XMLUtils.newDocument();
            rootNode = doc.createElement("data");
            rootNode.setAttribute("contextPath", this.setup.get("context.path", "/bgbilling"));
            doc.appendChild(rootNode);
            Object webMode = WebExecuter.getRequestParameters(this.setup.get("web.mode", System.getProperty("web.mode", "jsp")), request, "contentType", "ct");
            if (webMode != null && "html".equals(webMode)) {
                webMode = "jsp";
                this.logger.error("\u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415! web.mode=html - \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
            }
            if ((clid = (Integer)session.getAttribute("clientid")) != null) {
                Object xsltFile = null;
                boolean canAccess = true;
                if (!this.requestCounter.checkRequestCount(clid)) {
                    canAccess = false;
                    if (request.getParameter("getcaptcha") != null) {
                        webMode = ActionResultContentType.binary;
                        Captcha.captcha(request, response, session, false);
                    } else {
                        String captcha = WebExecuter.getParameter(request, "captcha", null);
                        if (!Captcha.validate(captcha, request, session)) {
                            if (!Utils.isEmptyString((String)captcha)) {
                                XMLUtils.createElement((Element)rootNode, (String)"error").setAttribute("id", "badCode");
                            }
                            rootNode.setAttribute("rand", String.valueOf(System.currentTimeMillis() % 1000L));
                            canAccess = false;
                            xsltFile = "limit_error.xsl";
                        } else {
                            request.setAttribute("ResetLimit", (Object)Boolean.TRUE);
                            canAccess = true;
                        }
                    }
                }
                if (canAccess) {
                    Integer moduleId;
                    String year = String.valueOf(new GregorianCalendar().get(1));
                    rootNode.setAttribute("action", action);
                    rootNode.setAttribute("module", module);
                    rootNode.setAttribute("mid", mid);
                    rootNode.setAttribute("year", year);
                    request.setAttribute("action", (Object)action);
                    request.setAttribute("module", (Object)module);
                    request.setAttribute("year", (Object)year);
                    Contract contract = (Contract)((Object)session.getAttribute("contract_current"));
                    Object list = session.getAttribute(contract.getId() + "_allowed_modules");
                    if (list instanceof List && (moduleId = Integer.valueOf(Utils.parseInt((String)mid))) != 0 && !((List)list).contains(moduleId)) {
                        WebExecuter.setErrorStatus(request, rootNode, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u043c\u043e\u0434\u0443\u043b\u044c!");
                        throw new Error("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u043c\u043e\u0434\u0443\u043b\u044c!");
                    }
                    request.setAttribute("moduleId", (Object)mid);
                    this.buildMenu(conSlave, contract, request, rootNode);
                    this.executeAction(webMode, action, operation, module, mid, request, response, rootNode);
                    Object requestWebMode = request.getAttribute("contentType");
                    if (requestWebMode != null) {
                        webMode = requestWebMode;
                    }
                    request.removeAttribute("contentType");
                    if (ActionResultContentType.forward.isEquals(webMode)) {
                        request.getRequestDispatcher((String)request.getAttribute("forward")).forward((ServletRequest)request, (ServletResponse)response);
                    } else if (!ActionResultContentType.binary.isEquals(webMode)) {
                        if (contract != null) {
                            Contract loggedAsContract = (Contract)((Object)session.getAttribute("logged_as_cid"));
                            if (loggedAsContract == null) {
                                loggedAsContract = contract;
                                session.setAttribute("logged_as_cid", (Object)contract);
                            }
                            Contract superContract = (Contract)((Object)session.getAttribute("contract_general"));
                            List subContractList = (List)session.getAttribute("contract_sublist");
                            if (ActionResultContentType.jsp.isEquals(webMode)) {
                                request.setAttribute("contract", (Object)contract);
                                request.setAttribute("superContract", (Object)superContract);
                                request.setAttribute("subContractList", (Object)subContractList);
                                request.setAttribute("currencyTitleMedium", (Object)this.setup.get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
                            } else {
                                boolean showSubcontractOnly;
                                WebExecuter.addContractDataToXML(rootNode, contract);
                                boolean bl = showSubcontractOnly = this.setup.getInt("web.sub.contract.auth.mode", 1) == 2;
                                if (loggedAsContract.isSub() && showSubcontractOnly) {
                                    Element subContractEl = XMLUtils.createElement((Element)rootNode, (String)"sub_contract");
                                    WebExecuter.addContractDataToXML(subContractEl, loggedAsContract);
                                } else {
                                    if (subContractList != null) {
                                        Element subContracts = XMLUtils.createElement((Element)rootNode, (String)"sub_contracts");
                                        for (Contract subContract : subContractList) {
                                            Element item = XMLUtils.createElement((Element)subContracts, (String)"item");
                                            WebExecuter.addContractDataToXML(item, subContract);
                                        }
                                    }
                                    if (superContract != null) {
                                        Element superContractEl = XMLUtils.createElement((Element)rootNode, (String)"super_contract");
                                        WebExecuter.addContractDataToXML(superContractEl, superContract);
                                    }
                                }
                            }
                            this.checkNotifications(conSlave, request, rootNode, clid);
                        }
                        if (this.setup.getInt("web.add.contract", -1) > 0) {
                            SoftReference contractDataRef = (SoftReference)session.getAttribute("contract_data");
                            Element contractData = contractDataRef != null ? (Element)contractDataRef.get() : null;
                            Integer contractDataCid = (Integer)session.getAttribute("contract_data_cid");
                            if (contractData != null && contractDataCid != null && !contractDataCid.equals(clid)) {
                                contractData = null;
                            }
                            if (contractData == null) {
                                Document contractDoc = XMLUtils.newDocument();
                                contractData = contractDoc.createElement("contract_data");
                                contractDoc.appendChild(contractData);
                                XMLOutputFactory factory = XMLOutputFactory.newInstance();
                                new ContractUtils(conSlave).addContractXML(clid, factory.createXMLStreamWriter(new DOMResult(contractData)), true);
                                session.setAttribute("contract_data", new SoftReference<Element>(contractData));
                                session.setAttribute("contract_data_cid", (Object)clid);
                            }
                            rootNode.appendChild(doc.importNode(contractData, true));
                        }
                        xsltFile = module.equals("contract") ? "main.xsl" : module + ".xsl";
                    }
                } else {
                    webMode = ActionResultContentType.binary;
                    if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
                        request.getRequestDispatcher("/WEB-INF/jspf/include/request_limit.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    } else {
                        request.getRequestDispatcher("/WEB-INF/jspf/webcontent.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    }
                }
                ServerUtils.addNoCache(response);
                if (ActionResultContentType.jsp.isEquals(webMode)) {
                    request.getRequestDispatcher("/WEB-INF/jspf/webcontent.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (ActionResultContentType.json.isEquals(webMode)) {
                    JSONObject jsonObject = new JSONObject((Map)request.getAttribute("dataMap"));
                    String type = request.getHeader("Content-Type");
                    boolean isMultipart = type != null && type.startsWith("multipart/form-data");
                    response.setContentType((isMultipart ? "text/plain" : "application/json") + "; charset=UTF-8");
                    PrintWriter out = response.getWriter();
                    out.print(jsonObject.toString());
                    out.flush();
                    out.close();
                } else if (ActionResultContentType.xml.isEquals(webMode) || ActionResultContentType.html.isEquals(webMode)) {
                    if (Files.exists(Paths.get("webroot", "xsl", "xsltFile"), new LinkOption[0])) {
                        if (ActionResultContentType.xml.isEquals(webMode)) {
                            this.sendXmlWithXSLTInstuction(request, response, doc, (String)xsltFile);
                        } else if (ActionResultContentType.html.isEquals(webMode)) {
                            this.xslManager.transformToResponse(response, (String)xsltFile, new DOMSource(doc), null, "text/html", null, false);
                        }
                    } else {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("RequestURI = " + request.getRequestURI());
                            this.logger.trace("QueryString = " + request.getQueryString());
                        }
                        request.setAttribute("webMode", webMode);
                        request.setAttribute("requestURI", (Object)request.getRequestURI());
                        request.setAttribute("queryString", (Object)request.getQueryString());
                        request.getRequestDispatcher("/WEB-INF/jspf/error.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    }
                }
                if (session.getAttribute("invalidate") != null) {
                    session.invalidate();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage() + "; requestURI=" + request.getRequestURI() + "; requestQueryString=" + request.getQueryString(), (Throwable)e);
            response.setContentType("text/plain; charset=UTF-8");
            PrintWriter out = response.getWriter();
            e.printStackTrace(out);
            out.flush();
            out.close();
        }
        catch (Error e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            PrintWriter out = response.getWriter();
            out.flush();
            out.close();
        }
        finally {
            ServerUtils.closeConnection(conSlave);
        }
    }

    private String getPathParam(String[] paths, int index, String defaultValue) {
        if (paths == null || index >= paths.length) {
            return defaultValue;
        }
        return paths[index];
    }

    private void checkNotifications(Connection conSlave, HttpServletRequest request, Element rootNode, int contractId) throws BGException {
        try {
            Class<?> clazz = Class.forName("ru.bitel.bgbilling.plugins.notification.server.bean.ContractNotificationDao");
            if (clazz != null) {
                Object contractNotificationDao = clazz.getConstructor(Connection.class).newInstance(conSlave);
                int newNotificationsCount = (Integer)clazz.getMethod("getUnreadNotificationsCount", Integer.TYPE).invoke(contractNotificationDao, contractId);
                rootNode.setAttribute("notificationsCount", String.valueOf(newNotificationsCount));
                request.setAttribute("notificationsCount", (Object)String.valueOf(newNotificationsCount));
                clazz.getMethod("close", new Class[0]).invoke(contractNotificationDao, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction(Object webMode, String action, String operation, String module, String moduleId, HttpServletRequest request, HttpServletResponse response, Element rootNode) {
        Action webAction = null;
        if (!action.equalsIgnoreCase("menu")) {
            try (Connection con = this.setup.getDBConnection();){
                ActionLogEntry actionLogEntry;
                BGActionLogManager actionLogManager;
                block24: {
                    actionLogManager = new BGActionLogManager(con);
                    actionLogEntry = null;
                    try {
                        if (actionLogManager.isConnectionActive()) {
                            actionLogEntry = new ActionLogEntry().setAction("Web:" + action).setDatetime(new Date()).setModuleId(Utils.parseInt((String)moduleId)).setModuleTitle(module).setQuery(WebExecuter.getQueryString(request, true)).setUserId(-1);
                            actionLogManager.update((Object)actionLogEntry);
                        }
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                    try {
                        Class<?> actionClass;
                        String className = "Action" + action;
                        if (moduleId.equals("contract")) {
                            module = "contract";
                        }
                        if ((actionClass = this.findAction(module, "web.", className)) == null) {
                            this.logger.error("action \"" + module + "." + className + "\" not found!");
                            WebExecuter.setErrorStatus(request, rootNode, "action \"" + module + "." + className + "\" not found!");
                            break block24;
                        }
                        if (Action.class.isAssignableFrom(actionClass)) {
                            webAction = actionClass.asSubclass(Action.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                            try {
                                webAction.init(this.setup, rootNode, request, response, this.servletContext);
                                webAction.setOutputMode(WebExecuter.getOutputMode(webMode));
                                webAction.doAction();
                                webAction.commit();
                                break block24;
                            }
                            finally {
                                webAction.freeConnection();
                            }
                        }
                        if (AbstractAction.class.isAssignableFrom(actionClass)) {
                            int contractId = -1;
                            Integer clientid = (Integer)request.getSession().getAttribute("clientid");
                            if (clientid != null) {
                                contractId = clientid;
                            }
                            this.actionHandler.handle(actionClass.asSubclass(AbstractAction.class), operation, this.setup, webMode, ActionResultContentType.xml.isEquals(webMode) ? rootNode : null, request, response, this.servletContext, contractId, -1);
                        }
                    }
                    catch (BGMessageException ex) {
                        WebExecuter.setErrorStatus(request, rootNode, ex.getMessage());
                    }
                    catch (Exception ex) {
                        this.logger.error(ex.getMessage(), (Throwable)ex);
                        WebExecuter.setErrorStatus(request, rootNode, "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                    }
                }
                if (actionLogManager.isConnectionActive() && actionLogEntry != null) {
                    actionLogManager.delete(actionLogEntry.getId());
                }
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static int getOutputMode(Object webMode) {
        int outputMode = 0;
        if (ActionResultContentType.jsp.isEquals(webMode)) {
            outputMode = 1;
        } else if (ActionResultContentType.json.isEquals(webMode)) {
            outputMode = 2;
        }
        return outputMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRequest(HttpServletRequest request) {
        block27: {
            String queryString;
            boolean log = this.setup.getBoolean("webquery.log", false);
            if (log && (queryString = WebExecuter.getQueryString(request, true)) != null && queryString.length() > 0) {
                String remoteAddr = ServletUtils.getIpFromHeader(request, this.setup);
                String module = request.getParameter("module");
                BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(module);
                Object mid = null;
                mid = plugin != null ? "p" + plugin.getId() : request.getParameter("mid");
                Integer clientId = (Integer)request.getSession().getAttribute("clientid");
                int cid = clientId == null ? -1 : clientId;
                Connection con = this.setup.getDBConnectionFromPool();
                try {
                    GregorianCalendar calendar = new GregorianCalendar();
                    Object table = "web_query_log_" + TimeUtils.format((Calendar)calendar, (String)"MMyyyy");
                    if (ServerUtils.tableExists(con, (String)table)) {
                        String query = "INSERT INTO " + (String)table + " SET dtime=NOW(), cid=?, ip=?, mid=?, query=?";
                        try (PreparedStatement psInsert = con.prepareStatement(query);){
                            psInsert.setInt(1, cid);
                            psInsert.setString(2, remoteAddr);
                            psInsert.setInt(3, Utils.parseInt((String)mid));
                            psInsert.setString(4, queryString);
                            psInsert.executeUpdate();
                            break block27;
                        }
                    }
                    table = ServerUtils.getMonthTableName("web_query_log", calendar.getTime());
                    if (!ServerUtils.tableExists(con, (String)table)) {
                        String query = "CREATE TABLE " + (String)table + "( id INT AUTO_INCREMENT NOT NULL, dtime DATETIME NOT NULL default '0000-00-00 00:00:00',cid INT NOT NULL,ip VARCHAR(20) NOT NULL,mid INT NOT NULL, query TEXT NOT NULL,c_title VARCHAR(150) NOT NULL,m_title VARCHAR(150) NOT NULL,PRIMARY KEY id(id), KEY cid(cid), KEY dtime(dtime) )";
                        try (Statement st = con.createStatement();){
                            st.execute(query);
                        }
                    }
                    Contract contract = ContractDao.getContract(con, cid);
                    BGModule mod = null;
                    if (plugin == null) {
                        mod = new ModuleManager(con).getModule(Utils.parseInt((String)mid));
                    }
                    String query = "INSERT INTO " + (String)table + " SET dtime=NOW(), cid=?, ip=?, mid=?, query=?, c_title=?, m_title=?";
                    try (PreparedStatement psInsert = con.prepareStatement(query);){
                        psInsert.setInt(1, cid);
                        psInsert.setString(2, remoteAddr);
                        psInsert.setInt(3, Utils.parseInt((String)mid));
                        psInsert.setString(4, queryString);
                        psInsert.setString(5, contract != null ? contract.getTitle() : "");
                        psInsert.setString(6, plugin != null ? plugin.getName() : (mod != null ? mod.getTitle() : ""));
                        psInsert.executeUpdate();
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    ServerUtils.closeConnection(con);
                }
            }
        }
    }

    private void buildMenu(Connection con, Contract contract, HttpServletRequest request, Element rootNode) {
        try {
            String cacheKey = "webMenu_" + contract.getId();
            Document doc = rootNode.getOwnerDocument();
            HttpSession session = request.getSession();
            Object[] data = (Object[])session.getAttribute(cacheKey);
            if (data == null) {
                WebMenuDao webMenuDao = new WebMenuDao(con);
                int webMenuId = webMenuDao.getWebMenuIdForContract(contract.getId());
                if (webMenuId == -1) {
                    List<WebMenuItem> list = webMenuDao.list();
                    for (WebMenuItem webMenuItem : list) {
                        if (!webMenuItem.isDefault()) continue;
                        webMenuId = webMenuItem.getId();
                        break;
                    }
                }
                ArrayList<MenuItem> menuItemList = new ArrayList<MenuItem>();
                ArrayList<DashboardItem> dashboardItems = new ArrayList<DashboardItem>();
                List<BGModule> bgModules = new ContractModuleManager(con).getContractModules(contract.getId());
                List moduleList = bgModules.stream().map(m -> m.getId()).collect(Collectors.toList());
                if (webMenuId > 0) {
                    Document webMenuDoc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(webMenuDao.getData(webMenuId))));
                    this.buildDashboardList(webMenuDoc.getDocumentElement(), dashboardItems);
                    for (Object itemElement : XMLUtils.selectElements((Node)webMenuDoc, (String)"//item")) {
                        MenuItem menuItem = new MenuItem().setAction(itemElement.getAttribute("action")).setTitle(itemElement.getAttribute("title")).setIcon(itemElement.getAttribute("icon")).setModule(itemElement.getAttribute("moduleName")).setModuleId(Utils.parseInt((String)itemElement.getAttribute("moduleId")));
                        if (menuItem.getModuleId() != 0 && !moduleList.contains(menuItem.getModuleId())) continue;
                        if (menuItem.getModule().startsWith("ru.bitel.bgbilling.plugins") && menuItem.getModuleId() == 0) {
                            menuItem.setModuleId(ModuleCache.getInstance().getPluginId(menuItem.getModule()));
                        }
                        menuItemList.add(menuItem);
                    }
                } else {
                    Element itemElement;
                    WebMenuBase menuBase;
                    List<MenuItem> items;
                    Class<?> result;
                    Class<? extends WebMenuBase> menuBaseClass;
                    Element autoMenu = doc.createElement("autoMenu");
                    Element kernelGroup = XMLUtils.createElement((Element)autoMenu, (String)"group");
                    kernelGroup.setAttribute("key", "kernel");
                    kernelGroup.setAttribute("title", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440");
                    kernelGroup.setAttribute("icon", "contract");
                    for (MenuItem menuItem : new Module().getContractWebMenuItems(con, "contract", 0, contract.getId())) {
                        if ("header".equals(menuItem.getDefaultMenu())) continue;
                        Element itemElement2 = XMLUtils.createElement((Element)kernelGroup, (String)"item");
                        itemElement2.setAttribute("action", menuItem.getAction());
                        itemElement2.setAttribute("moduleName", menuItem.getModule());
                        itemElement2.setAttribute("moduleId", String.valueOf(menuItem.getModuleId()));
                        itemElement2.setAttribute("title", menuItem.getTitle());
                        itemElement2.setAttribute("icon", menuItem.getIcon());
                        itemElement2.setAttribute("description", menuItem.getDescription());
                        menuItemList.add(menuItem);
                    }
                    for (BGModule bGModule : bgModules) {
                        int moduleId = bGModule.getId();
                        menuBaseClass = this.menuMap.get(moduleId);
                        if (menuBaseClass == null) {
                            try {
                                String packServer2 = bGModule.getInstalledModule().getPackageServer();
                                result = Class.forName(packServer2 + ".Module");
                                menuBaseClass = result.asSubclass(WebMenuBase.class);
                                this.menuMap.put(moduleId, menuBaseClass);
                            }
                            catch (Exception packServer2) {
                                // empty catch block
                            }
                        }
                        if (menuBaseClass == null || (items = (menuBase = menuBaseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getContractWebMenuItems(con, bGModule.getName(), moduleId, contract.getId())).isEmpty()) continue;
                        Element moduleGroup = autoMenu;
                        if (items.size() > 1) {
                            moduleGroup = XMLUtils.createElement((Element)autoMenu, (String)"group");
                            moduleGroup.setAttribute("key", "module" + moduleId);
                            moduleGroup.setAttribute("title", bGModule.getGuiTitle());
                            moduleGroup.setAttribute("icon", bGModule.getName());
                        }
                        for (MenuItem menuItem : items) {
                            itemElement = XMLUtils.createElement((Element)moduleGroup, (String)"item");
                            itemElement.setAttribute("action", menuItem.getAction());
                            itemElement.setAttribute("moduleName", menuItem.getModule());
                            itemElement.setAttribute("moduleId", String.valueOf(menuItem.getModuleId()));
                            itemElement.setAttribute("title", menuItem.getTitle());
                            itemElement.setAttribute("icon", menuItem.getIcon());
                            itemElement.setAttribute("description", menuItem.getDescription());
                            menuItemList.add(menuItem);
                        }
                    }
                    for (Map.Entry entry : BGPluginManagerServer.getManager().getPluginsMap().entrySet()) {
                        String pluginid = (String)entry.getKey();
                        menuBaseClass = this.menuMap.get(pluginid);
                        if (menuBaseClass == null) {
                            try {
                                String packServer3 = ((BGPluginServer)entry.getValue()).getPackServer();
                                result = Class.forName(packServer3 + ".PluginServerListener");
                                menuBaseClass = result.asSubclass(WebMenuBase.class);
                                this.menuMap.put(pluginid, menuBaseClass);
                            }
                            catch (Exception packServer3) {
                                // empty catch block
                            }
                        }
                        if (menuBaseClass == null || (items = (menuBase = menuBaseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getContractWebMenuItems(con, pluginid, ModuleCache.getInstance().getPluginId(pluginid), contract.getId())).isEmpty()) continue;
                        Element pluginGroup = autoMenu;
                        if (items.size() > 1) {
                            pluginGroup = XMLUtils.createElement((Element)autoMenu, (String)"group");
                            pluginGroup.setAttribute("key", "module" + pluginid);
                            pluginGroup.setAttribute("title", ((BGPluginServer)entry.getValue()).getName());
                            pluginGroup.setAttribute("icon", "module" + pluginid);
                        }
                        for (MenuItem menuItem : items) {
                            itemElement = XMLUtils.createElement((Element)pluginGroup, (String)"item");
                            itemElement.setAttribute("action", menuItem.getAction());
                            itemElement.setAttribute("moduleName", menuItem.getModule());
                            itemElement.setAttribute("moduleId", String.valueOf(menuItem.getModuleId()));
                            itemElement.setAttribute("title", menuItem.getTitle());
                            itemElement.setAttribute("icon", menuItem.getIcon());
                            itemElement.setAttribute("description", menuItem.getDescription());
                            if (menuItem.getModule().startsWith("ru.bitel.bgbilling.plugins")) {
                                itemElement.setAttribute("moduleId", String.valueOf(ModuleCache.getInstance().getPluginId(menuItem.getModule())));
                            }
                            menuItemList.add(menuItem);
                        }
                    }
                    this.buildDashboardList(autoMenu, dashboardItems);
                }
                Element menu = doc.createElement("menu");
                for (MenuItem menuItem : menuItemList) {
                    Element element = doc.createElement("item");
                    element.setAttribute("mid", String.valueOf(menuItem.getModuleId()));
                    element.setAttribute("action", menuItem.getAction());
                    element.setAttribute("title", menuItem.getTitle());
                    element.setAttribute("module", menuItem.getModule());
                    menu.appendChild(element);
                }
                data = new Object[]{menu, menuItemList, moduleList, dashboardItems};
                WebMenuListEvent webMenuListEvent = new WebMenuListEvent(contract, data);
                ServerContext context = new ServerContext(this.setup, 0, -1);
                ThreadContext threadContext = ThreadContext.push((ThreadContext)context);
                EventProcessor.getInstance().request(webMenuListEvent);
                ThreadContext.pop((ThreadContext)context, (ThreadContext)threadContext);
                data = webMenuListEvent.getData();
                session.setAttribute(cacheKey, (Object)data);
            }
            HashMap pageTitles = new HashMap();
            ((List)data[1]).forEach(a -> pageTitles.put(a.getModule() + ":" + a.getModuleId() + ":" + a.getAction(), a.getTitle()));
            rootNode.appendChild(doc.importNode((Element)data[0], true));
            request.setAttribute("menuItemList", data[1]);
            request.setAttribute("pageTitles", pageTitles);
            request.setAttribute(contract.getId() + "_allowed_modules", data[2]);
            request.setAttribute("dashboardItems", data[3]);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void buildDashboardList(Element menuElement, List<DashboardItem> dashboardItems) {
        NodeList nodeList = menuElement.getChildNodes();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element childNode = (Element)nodeList.item(index);
            boolean isGroup = "group".equals(childNode.getNodeName());
            String type = childNode.getAttribute("type");
            DashboardItem dashboardItem = new DashboardItem().setTitle(childNode.getAttribute("title")).setDescription(childNode.getAttribute("description"));
            DashboardItemType itemType = DashboardItemType.PAGE;
            if (isGroup) {
                itemType = DashboardItemType.FOLDER;
            } else if ("link".equals(type)) {
                itemType = DashboardItemType.LINK;
                dashboardItem.setUrl(childNode.getAttribute("url"));
            } else if ("assistantMaster".equals(type)) {
                itemType = DashboardItemType.ASSISTANT_MASTER;
                dashboardItem.setAssistantMasterId(childNode.getAttribute("assistantMasterId"));
            }
            dashboardItem.setItemType(itemType);
            try {
                String icon = childNode.getAttribute("icon");
                if (Utils.notEmptyString((String)icon)) {
                    if (icon.startsWith("http")) {
                        dashboardItem.setIcon(icon);
                    } else {
                        Path iconPath = Paths.get("webroot", "img", icon);
                        if (Files.exists(iconPath, new LinkOption[0]) && Files.isRegularFile(iconPath, new LinkOption[0])) {
                            dashboardItem.setIcon("img/" + icon);
                        } else {
                            iconPath = Paths.get("webroot", "img", icon + ".png");
                            if (Files.exists(iconPath, new LinkOption[0]) && Files.isRegularFile(iconPath, new LinkOption[0])) {
                                dashboardItem.setIcon("img/" + icon + ".png");
                            }
                        }
                    }
                }
            }
            catch (Exception icon) {
                // empty catch block
            }
            if (isGroup) {
                dashboardItem.setKey(childNode.getAttribute("key"));
                this.buildDashboardList(childNode, dashboardItem.getSubItems());
            } else {
                String moduleName = childNode.getAttribute("moduleName");
                dashboardItem.setAction(childNode.getAttribute("action"));
                dashboardItem.setModule(moduleName);
                if (moduleName.startsWith("ru.bitel.bgbilling.plugins")) {
                    dashboardItem.setModuleId(ModuleCache.getInstance().getPluginId(moduleName));
                } else {
                    dashboardItem.setModuleId(Utils.parseInt((String)childNode.getAttribute("moduleId"), (int)0));
                }
            }
            dashboardItems.add(dashboardItem);
        }
    }

    private static String getParameter(HttpServletRequest request, String name, String defaultValue) {
        return Optional.ofNullable(request.getParameter(name)).orElse(defaultValue);
    }

    private static void addContractDataToXML(Element el, Contract contract) {
        el.setAttribute("id", String.valueOf(contract.getId()));
        el.setAttribute("contract", contract.getTitle());
        el.setAttribute("title", contract.getTitle());
        el.setAttribute("comment", contract.getComment());
        el.setAttribute("balance_mode", String.valueOf(contract.getBalanceMode()));
        el.setAttribute("fc", String.valueOf(contract.getFace() == ContractFace.FIZIC ? 0 : 1));
    }
}

