/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class BGControlPanelPeriodNoB
extends JPanel {
    protected BGCalendarButton dateTextField1 = new BGCalendarButton();
    protected BGCalendarButton dateTextField2 = new BGCalendarButton();

    public BGControlPanelPeriodNoB() {
        this(true);
    }

    public BGControlPanelPeriodNoB(boolean showWith) {
        int gridx = 0;
        this.setLayout(new GridBagLayout());
        if (showWith) {
            this.add((Component)new JLabel("\u0441"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        }
        this.add((Component)this.dateTextField1, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.dateTextField2, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.dateTextField1.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("updateCalendar")) {
                this.firePropertyChange("date1", e.getOldValue(), e.getNewValue());
            }
        });
        this.dateTextField1.addChangeListener(e -> this.firePropertyChange("showCalendar", !this.dateTextField1.isSelected(), this.dateTextField1.isSelected()));
        this.dateTextField2.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("updateCalendar")) {
                this.firePropertyChange("date2", e.getOldValue(), e.getNewValue());
            }
        });
        this.dateTextField2.addChangeListener(e -> this.firePropertyChange("showCalendar", !this.dateTextField1.isSelected(), this.dateTextField1.isSelected()));
    }

    public void setLocalDateFrom(LocalDate localDate) {
        this.dateTextField1.setLocalDate(localDate);
    }

    public void setDateFrom(Date date) {
        this.dateTextField1.setLocalDate(TimeUtils.convertDateToLocalDate(date));
    }

    public void setDateCalendar1(Calendar calendar) {
        this.dateTextField1.setLocalDate(calendar != null ? TimeUtils.convertDateToLocalDate(calendar.getTime()) : null);
    }

    public void undoDateCalendar1() {
        this.dateTextField1.undoCalendar();
    }

    public Period getPeriod() {
        return new Period(this.getDateFrom(), this.getDateTo());
    }

    public void setPeriod(Period period) {
        if (period != null) {
            this.setLocalDateFrom(period.getLocalDateFrom());
            this.setLocalDateTo(period.getLocalDateTo());
        } else {
            this.setLocalDateFrom(null);
            this.setLocalDateTo(null);
        }
    }

    public Calendar getDateCalendar1() {
        return this.dateTextField1.getCalendar();
    }

    public void setLocalDateTo(LocalDate localDate) {
        this.dateTextField2.setLocalDate(localDate);
    }

    public void setDateTo(Date date) {
        this.dateTextField2.setLocalDate(TimeUtils.convertDateToLocalDate(date));
    }

    public void setDateCalendar2(Calendar calendar) {
        this.dateTextField2.setLocalDate(calendar != null ? TimeUtils.convertDateToLocalDate(calendar.getTime()) : null);
    }

    public void undoDateCalendar2() {
        this.dateTextField2.undoCalendar();
    }

    public Calendar getDateCalendar2() {
        return this.dateTextField2.getCalendar();
    }

    public void setDateString1(String dateString1) {
        this.dateTextField1.setText(dateString1);
    }

    public String getDateString1() {
        return this.dateTextField1.getText().trim();
    }

    public void setDateString2(String dateString2) {
        this.dateTextField2.setText(dateString2);
    }

    public String getDateString2() {
        return this.dateTextField2.getText().trim();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    public void reset() {
        this.dateTextField1.setLocalDate(null);
        this.dateTextField2.setLocalDate(null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.dateTextField1.setEnabled(enabled);
        this.dateTextField2.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setFromEnabled(boolean enabled) {
        this.dateTextField1.setEnabled(enabled);
    }

    public void setToEnabled(boolean enabled) {
        this.dateTextField2.setEnabled(enabled);
    }

    public Date getDateFrom() {
        return TimeUtils.convertCalendarToDate(this.dateTextField1.getCalendar());
    }

    public Date getDateTo() {
        return TimeUtils.convertCalendarToDate(this.dateTextField2.getCalendar());
    }

    public LocalDate getLocalDateFrom() {
        return this.dateTextField1.getLocalDate();
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        this.dateTextField1.addFocusListener(focusListener);
        this.dateTextField2.addFocusListener(focusListener);
    }

    public LocalDate getLocalDateTo() {
        return this.dateTextField2.getLocalDate();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.dateTextField1.setName(name);
        this.dateTextField2.setName(name);
    }

    public void showErrorToolTipFrom(String message) {
        BGToolTip.showErrorMessage(this.dateTextField1, message);
    }

    public void showErrorToolTipTo(String message) {
        BGToolTip.showErrorMessage(this.dateTextField2, message);
    }
}

