/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanelContainer;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel_Card;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel_Parameters;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel_Report;
import ru.bitel.bgbilling.kernel.contract.base.client.FolderSelect;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ContractEditor
extends BGTabPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();

    public ContractEditor(int cid) {
        this(cid, null);
    }

    public ContractEditor(int contractId, String selectedPanelClass) {
        super("contract_" + contractId, "UNDEF");
        this.setContractId(contractId);
        this.jbInit();
        if (selectedPanelClass == null) {
            this.tabbedPane.add((Component)new ContractPanelContainer(this, ContractPanel_Parameters.class.getName()), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            this.tabbedPane.add((Component)new ContractPanelContainer(this, ContractPanel_Report.class.getName()), "\u041e\u0442\u0447\u0435\u0442");
            this.tabbedPane.add((Component)new ContractPanelContainer(this, ContractPanel_Card.class.getName()), "\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0438");
        } else {
            ContractPanelContainer container = new ContractPanelContainer(this, ContractPanel_Parameters.class.getName());
            this.tabbedPane.add((Component)container, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            this.tabbedPane.setSelectedComponent(container);
            if (!ContractPanel_Parameters.class.getName().equals(selectedPanelClass)) {
                this.setData();
            }
            container = new ContractPanelContainer(this, ContractPanel_Report.class.getName());
            this.tabbedPane.add((Component)container, "\u041e\u0442\u0447\u0435\u0442");
            if (ContractPanel_Report.class.getName().equals(selectedPanelClass)) {
                this.tabbedPane.setSelectedComponent(container);
            }
            container = new ContractPanelContainer(this, ContractPanel_Card.class.getName());
            this.tabbedPane.add((Component)container, "\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0438");
            if (ContractPanel_Card.class.getName().equals(selectedPanelClass)) {
                this.tabbedPane.setSelectedComponent(container);
            }
        }
        for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions(ContractEditor.class.getCanonicalName(), true)) {
            Element extensionElement = extension.getElement();
            BGPluginClient plugin = (BGPluginClient)extension.getPlugin();
            NodeList list = extensionElement.getElementsByTagName("tab");
            for (int index = 0; index < list.getLength(); ++index) {
                Element tab = (Element)list.item(index);
                this.tryCall(() -> {
                    String name = plugin.getResourceString(tab.getAttribute("name"));
                    String className = tab.getAttribute("class");
                    boolean eq = className.equals(selectedPanelClass);
                    ContractPanelContainer container = new ContractPanelContainer(this, className);
                    this.tabbedPane.add((Component)container, name);
                    if (eq) {
                        this.tabbedPane.setSelectedComponent(container);
                    }
                });
            }
        }
        this.tabbedPane.addChangeListener(e -> {
            this.tabChanged();
            this.setData();
        });
        this.tabChanged();
        this.setData();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        this.getPanel().trySetData();
    }

    @Override
    public void newItem() {
        this.getPanel().newItem();
    }

    @Override
    public void copyItem() {
        this.getPanel().copyItem();
    }

    @Override
    public void editItem() {
        this.getPanel().editItem();
    }

    @Override
    public void deleteItem() {
        this.getPanel().deleteItem();
    }

    private ContractPanel getPanel() {
        return ((ContractPanelContainer)this.tabbedPane.getSelectedComponent()).getPanel();
    }

    private void tabChanged() {
        ContractPanelContainer container = (ContractPanelContainer)this.tabbedPane.getSelectedComponent();
        container.getPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ContractPanel panel = ((ContractPanelContainer)this.tabbedPane.getSelectedComponent()).getPanel();
        if (panel != null) {
            panel.actionPerformed(e);
        }
    }

    public void setContractTitle(String title) {
        this.setTabTitle(title);
    }

    public String getContractTitle() {
        return this.tabTitle;
    }

    public boolean deleteContract() throws Exception {
        if (!ClientUtils.confirmDelete(this.tabTitle)) {
            return false;
        }
        int save = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u043e\u043f\u0438\u044e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0432 \u0430\u0440\u0445\u0438\u0432\u0435?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0, 1);
        boolean needSave = save == 0;
        String deleteFolder = "";
        if (needSave && Utils.isBlankString(deleteFolder = this.getDeleteFolder())) {
            return false;
        }
        try {
            this.getContext().getPort(ContractService.class).contractDelete(this.getContractId(), needSave, deleteFolder);
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
            return false;
        }
        return true;
    }

    private String getDeleteFolder() throws Exception {
        String result = "";
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ArchiveFoldersList");
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            DefaultComboBoxModel<ComboBoxItem> model = ClientUtils.buildComboBox(XMLUtils.selectElement(doc, "//folder_list"), "/");
            FolderSelect fs = new FolderSelect(new JComboBox<ComboBoxItem>(model));
            result = fs.getFolder();
        }
        return result;
    }

    public ContractPanel chooseTab(String tabClass) {
        for (int i = 0; i < this.tabbedPane.getComponentCount(); ++i) {
            if (!tabClass.equals(((ContractPanelContainer)this.tabbedPane.getComponentAt(i)).getClassName())) continue;
            this.tabbedPane.setSelectedComponent(this.tabbedPane.getComponentAt(i));
            return ((ContractPanelContainer)this.tabbedPane.getComponentAt(i)).getPanel();
        }
        return null;
    }
}

