/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.events;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.common.SerialUtils;

@XmlRootElement
public class CalculateEvent
extends LocalEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(CalculateEvent.class);
    public static final int TYPE_BEFORE = 0;
    public static final int TYPE_AFTER = 1;
    public static final int TYPE_ERROR = 2;
    @XmlElementWrapper(name="contractIds")
    @XmlElements(value={@XmlElement(name="id")})
    private final List<Integer> contractIds;
    @XmlElementWrapper(name="serviceIds")
    @XmlElements(value={@XmlElement(name="id")})
    private final List<Integer> serviceIds;
    @XmlAttribute
    private final Date start;
    @XmlAttribute
    private final Date stop;
    @XmlAttribute
    private final int eventType;
    private final String comment;

    protected CalculateEvent() {
        this.eventType = -1;
        this.serviceIds = null;
        this.contractIds = null;
        this.start = null;
        this.stop = null;
        this.comment = null;
    }

    public CalculateEvent(int eventType, int moduleId, int userId, Date timeStart, Date timeStop, List<Integer> serviceIds, List<Integer> contractIds, String comment) {
        super(moduleId, CONTRACT_GLOBAL, userId);
        this.eventType = eventType;
        this.serviceIds = serviceIds;
        this.contractIds = contractIds;
        this.start = timeStart;
        this.stop = timeStop;
        this.comment = comment;
    }

    public List<Integer> getContractIds() {
        return this.contractIds != null ? this.contractIds : Collections.emptyList();
    }

    public List<Integer> getServiceIds() {
        return this.serviceIds != null ? this.serviceIds : Collections.emptyList();
    }

    public Date getStart() {
        return this.start;
    }

    public Date getStop() {
        return this.stop;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getComment() {
        return this.comment;
    }
}

