/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.notification.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.notification.common.bean.ContractNotification;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class ContractNotificationDao
extends AbstractIdDao<ContractNotification> {
    public ContractNotificationDao(Connection con) {
        super(con, "contract_notification");
    }

    public List<ContractNotification> list(int contractId) throws SQLException {
        return super.list("cid=?", "dt DESC", new Object[]{contractId});
    }

    public int getUnreadNotificationsCount(int contractId) throws SQLException {
        int count = 0;
        String query = "SELECT COUNT(id) FROM " + this.tableName + " WHERE cid=? AND is_read=0";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
        }
        return count;
    }

    protected ContractNotification getFromRS(ResultSet rs) throws SQLException {
        return new ContractNotification().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setDateTime((Date)rs.getTimestamp("dt")).setSubject(rs.getString("subject")).setMessage(rs.getString("message")).setRead(rs.getBoolean("is_read"));
    }

    protected void updateImpl(ContractNotification notice) throws SQLException {
        String querySet = "subject=?, message=?, cid=?, is_read=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)notice, querySet);){
            int index = 1;
            ps.setString(index++, notice.getSubject());
            ps.setString(index++, notice.getMessage());
            ps.setInt(index++, notice.getContractId());
            ps.setInt(index++, notice.isRead() ? 1 : 0);
            this.executeUpdate((Id)notice, index, ps);
        }
    }

    public boolean markReadNotification(int contractId, int id) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET is_read=? WHERE id=? AND cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, 1);
            ps.setInt(2, id);
            ps.setInt(3, contractId);
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
    }
}

