/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sbpilot.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.sbpilot.common.bean.SbPilotPayment;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public class SbPilotPaymentManager {
    private final Connection con;

    public SbPilotPaymentManager(Connection con) {
        this.con = con;
    }

    public Result<SbPilotPayment> getPaymentList(Period period, Page page) throws BGException {
        ArrayList<SbPilotPayment> result = new ArrayList<SbPilotPayment>();
        try {
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT SQL_CALC_FOUND_ROWS sbpilot.*, contract_payment.*, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ");
            query.append("FROM sbpilot_payments AS sbpilot, contract_payment ");
            query.append("LEFT JOIN contract ON contract_payment.cid=contract.id ");
            query.append("LEFT JOIN contract_payment_types ON contract_payment.pt=contract_payment_types.id ");
            query.append("WHERE ( sbpilot.payment_id=contract_payment.id ) ");
            if (period.getDateFrom() != null) {
                query.append(" AND sbpilot.dt>='");
                query.append(TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd"));
                query.append("'");
            }
            if (period.getDateTo() != null) {
                query.append(" AND sbpilot.dt<=DATE_ADD('");
                query.append(TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd"));
                query.append("', INTERVAL 1 DAY )");
            }
            query.append(" ORDER BY sbpilot.dt DESC ").append(Page.toSqlLimit((Page)page));
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        SbPilotPayment payment = new SbPilotPayment();
                        SbPilotPaymentManager.loadPaymentFromRS(payment, rs);
                        result.add(payment);
                    }
                }
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    private static void loadPaymentFromRS(SbPilotPayment payment, ResultSet rs) throws SQLException {
        payment.setId(rs.getInt("id"));
        payment.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("sbpilot.dt")));
        payment.setSumma(rs.getBigDecimal("sbpilot.summa"));
        payment.setPaymentComment(rs.getString("comment"));
        payment.setContractId(rs.getInt("cid"));
        payment.setContractTitle(rs.getString("contract_title"));
        payment.setPaymentTypeTitle(rs.getString("contract_payment_types_title"));
        payment.setContractComment(rs.getString("contract_comment"));
        payment.setCardnum(rs.getString("sbpilot.cardnum"));
        payment.setCarddate(rs.getString("sbpilot.carddate"));
        payment.setAuthcode(rs.getString("sbpilot.authcode"));
        payment.setInternalnum(rs.getString("sbpilot.internalnum"));
        payment.setCardtype(rs.getString("sbpilot.cardtype"));
    }

    public void addPayment(SbPilotPayment payment) throws BGException {
        try {
            Object query = "SELECT payment_id FROM sbpilot_payments WHERE payment_id=" + payment.getId();
            PreparedStatement ps = this.con.prepareStatement((String)query);
            ResultSet rs = ps.executeQuery();
            boolean exists = rs.next();
            rs.close();
            ps.close();
            if (!exists) {
                query = "INSERT INTO sbpilot_payments SET payment_id=?, summa=?, dt=?, type=?, cardnum=?, carddate=?, authcode=?, internalnum=?, cardtype=?";
                ps = this.con.prepareStatement((String)query);
                ps.setInt(1, payment.getId());
                ps.setBigDecimal(2, payment.getSumma());
                ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)new Date()));
                ps.setInt(4, 0);
                ps.setString(5, payment.getCardnum());
                ps.setString(6, payment.getCarddate());
                ps.setString(7, payment.getAuthcode());
                ps.setString(8, payment.getInternalnum());
                ps.setString(9, payment.getCardtype());
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

