/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDateTime;
import java.util.List;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.bgbilling.modules.subscription.common.bean.RegistrationPeriod;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.common.event.SubscriptionModifiedEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdContractId;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.xml.JAXBUtils;

@DirectoryItem(eventClass=SubscriptionModifiedEvent.class)
@XmlRootElement(name="subscription")
public class Subscription
extends IdContractId {
    private int typeId;
    private SubscriptionType subscriptionType;
    private PeriodWithTime period;
    private int registrationPeriodId;
    private List<RegistrationPeriod> registrationPeriodList;
    private boolean avtoCommit = false;
    private long jobId;
    private String comment = null;

    @XmlAttribute
    public String getComment() {
        return this.comment;
    }

    @XmlAttribute
    public long getJobId() {
        return this.jobId;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.PeriodWithTimeAdapter.class)
    public PeriodWithTime getPeriod() {
        return this.period;
    }

    @XmlAttribute
    public int getRegistrationPeriodId() {
        return this.registrationPeriodId;
    }

    @XmlElement
    public List<RegistrationPeriod> getRegistrationPeriodList() {
        return this.registrationPeriodList;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    @XmlAttribute
    public int getTypeId() {
        return this.typeId;
    }

    public boolean isActive() {
        LocalDateTime now = LocalDateTime.now();
        boolean result = this.period != null && TimeUtils.dateInPeriod((LocalDateTime)now, (PeriodWithTime)this.period);
        boolean bl = result = result && this.registrationPeriodList != null && !this.registrationPeriodList.isEmpty();
        if (result) {
            result = TimeUtils.dateInPeriod((LocalDateTime)now, (PeriodWithTime)this.registrationPeriodList.get(this.registrationPeriodList.size() - 1).getPeriod());
        }
        return result;
    }

    @XmlAttribute
    public boolean isAvtoCommit() {
        return this.avtoCommit;
    }

    public Subscription setAvtoCommit(boolean avtoCommit) {
        this.avtoCommit = avtoCommit;
        return this;
    }

    public Subscription setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Subscription setContractId(int contractId) {
        super.setContractId(contractId);
        return this;
    }

    public Subscription setId(int id) {
        super.setId(id);
        return this;
    }

    public Subscription setJobId(long jobId) {
        this.jobId = jobId;
        return this;
    }

    public Subscription setPeriod(PeriodWithTime period) {
        this.period = period;
        return this;
    }

    public Subscription setRegistrationPeriodId(int registrationPeriodId) {
        this.registrationPeriodId = registrationPeriodId;
        return this;
    }

    public Subscription setRegistrationPeriodList(List<RegistrationPeriod> registrationPeriodList) {
        this.registrationPeriodList = registrationPeriodList;
        return this;
    }

    public Subscription setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
        if (subscriptionType != null) {
            this.typeId = subscriptionType.getId();
        }
        return this;
    }

    public Subscription setTypeId(int typeId) {
        this.typeId = typeId;
        return this;
    }
}

