/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vseplatezhi.server.action.web;

import java.text.DecimalFormat;
import java.util.Date;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.vseplatezhi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.vseplatezhi.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.vseplatezhi.server.bean.Constants;
import ru.bitel.bgbilling.modules.vseplatezhi.server.bean.TransactionManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Vseplatezhi")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("vseplatezhi");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("vseplatezhi.gate.url", "https://pay.vseplatezhi.ru/shop/payment"));
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws Exception {
        this.execute();
    }

    public void fail() throws Exception {
        this.execute();
    }

    @WebOperation(title="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        Transaction transaction = new Transaction().setSum(this.sum).setContractId(this.contractId).setCreateDate(new Date());
        new TransactionManager(this.con, this.moduleId).update(transaction);
        this.setResultParam("gateUrl", this.moduleSetup.get("vseplatezhi.gate.url", "https://pay.vseplatezhi.ru/shop/payment"));
        this.setResultParam("client_id", this.moduleSetup.get("vseplatezhi.client.id", ""));
        this.setResultParam("order_id", String.valueOf(transaction.getId()));
        this.setResultParam("amount", new DecimalFormat("###########0.00").format(this.sum).replace(",", "."));
        StringBuffer signData = new StringBuffer().append(this.getResultParam("client_id")).append(this.getResultParam("order_id")).append(this.getResultParam("amount")).append(this.moduleSetup.get("vseplatezhi.shared.key", ""));
        this.setResultParam("sign", Utils.getDigest((String)signData.toString(), (String)"UTF-8").toLowerCase());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("client_id: " + String.valueOf(this.getResultParam("client_id")));
            this.getLogger().debug("order_id: " + String.valueOf(this.getResultParam("order_id")));
            this.getLogger().debug("amount: " + String.valueOf(this.getResultParam("amount")));
            this.getLogger().debug("secretKey: " + this.moduleSetup.get("vseplatezhi.shared.key", ""));
            this.getLogger().debug("signData: " + String.valueOf(signData));
            this.getLogger().debug("sign: " + String.valueOf(this.getResultParam("sign")));
        }
    }
}

