/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import bitel.billing.server.contract.object.bean.ListValueManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParamType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamAddressValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamDateValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamFlagValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamTextValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamValue;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectParamDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectParamTypeDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ParamValueManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ObjectDao
extends AbstractIdDao<ContractObject> {
    public ObjectDao(Connection con) {
        super(con, "object");
    }

    public List<ContractObject> getActiveObjectList(int contractId) throws SQLException {
        ArrayList<ContractObject> result = new ArrayList<ContractObject>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND ( date1<=NOW() OR date1 IS NULL ) AND ( isNULL(date2) OR date2 > NOW() ) ORDER BY pos";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        return result;
    }

    public List<ContractObject> getSuperObjectList(int contractId, boolean showAll) throws SQLException {
        ArrayList<ContractObject> result = new ArrayList<ContractObject>();
        String query = null;
        query = showAll ? "SELECT o.* FROM " + this.tableName + " o, contract c WHERE (o.cid=c.id OR (o.cid=c.scid AND c.scid!=0 AND c.scid!=-1) ) AND c.id=? ORDER BY o.pos" : "SELECT o.* FROM " + this.tableName + " o, contract c WHERE (o.cid=c.id OR (o.cid=c.scid AND c.scid!=0 AND c.scid!=-1)) AND c.id=? AND (o.date1<=NOW() OR o.date1 IS NULL) AND (isNULL(o.date2) OR o.date2 > NOW()) ORDER BY o.pos";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        return result;
    }

    public void moveObject(int id, int cidTo) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET cid=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, cidTo);
            ps.setInt(index++, id);
            ps.executeUpdate();
        }
    }

    public static void addObjectParams(Connection con, int objectId, XMLStreamWriter table, ObjectType type) throws XMLStreamException, BGException {
        try {
            Map<Integer, ListValue> listValuesMap = new ListValueManager(con).getValuesMap();
            Map<Integer, ObjectParam> paramMap = new ObjectParamDao(con).getParamMap();
            List<ObjectParamType> typeParamList = new ObjectParamTypeDao(con).getTypeParamList(type.getId());
            Map<Integer, ParamValue> valuesMap = new ParamValueManager(con).getObjectParamMap(objectId);
            for (ObjectParamType typeParam : typeParamList) {
                ParamValue value;
                ObjectParam objectParam = paramMap.get(typeParam.getParamId());
                if (objectParam == null || (value = valuesMap.get(objectParam.getId())) == null) continue;
                table.writeStartElement("row");
                table.writeAttribute("param_id", String.valueOf(objectParam.getId()));
                table.writeAttribute("type_id", String.valueOf(objectParam.getTypeId()));
                table.writeAttribute("title", objectParam.getTitle());
                switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)objectParam.getTypeId()).get()) {
                    case TEXT: {
                        table.writeAttribute("value", ((ParamTextValue)value).getValue());
                        break;
                    }
                    case BOOLEAN: {
                        table.writeAttribute("value", String.valueOf(((ParamFlagValue)value).getValue()));
                        break;
                    }
                    case ADDRESS: {
                        table.writeAttribute("value", ((ParamAddressValue)value).getAddress());
                        break;
                    }
                    case DATE: {
                        table.writeAttribute("value", TimeUtils.formatDate((Calendar)((ParamDateValue)value).getValue()));
                        break;
                    }
                    case LIST: {
                        ListValue listValue = listValuesMap.get(((ParamListValue)value).getValue());
                        if (listValue != null) {
                            table.writeAttribute("value", listValue.getTitle());
                            break;
                        }
                        table.writeAttribute("value", "???");
                        break;
                    }
                }
                table.writeEndElement();
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected ContractObject getFromRS(ResultSet rs) throws SQLException {
        return ContractObject.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setStatus(rs.getInt("status")).setTitle(rs.getString("title")).setTypeId(rs.getInt("type_id")).setDateFrom(rs.getDate("date1")).setDateTo(rs.getDate("date2")).setPosition(rs.getInt("pos")).build();
    }

    protected void updateImpl(ContractObject contractObject) throws SQLException {
        boolean update = contractObject.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, date1=?, date2=?" + (update ? " WHERE id=?" : ", cid=?, type_id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, contractObject.getTitle());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractObject.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractObject.getDateTo()));
            if (!update) {
                ps.setInt(index++, contractObject.getContractId());
                ps.setInt(index++, contractObject.getTypeId());
            }
            this.executeUpdate((Id)contractObject, index, ps);
        }
        if (!update) {
            query = "UPDATE " + this.tableName + " SET pos=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, contractObject.getId());
                ps.setInt(2, contractObject.getId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }
}

