/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.aots.client.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGDecimalTextField;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.aots.common.bean.AOTSContractService;
import ru.bitel.bgbilling.modules.aots.common.service.AOTSService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.BGUComboBoxRefresh;
import ru.bitel.common.model.IdTitle;

public class AOTSContractServicePanel
extends BGUPanel {
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("ContractService");
    private BGUPanel.WebServiceHolder<AOTSService> webServiceHolder = new BGUPanel.WebServiceHolder((BGUPanel)this, AOTSService.class);

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getTablePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        return panel;
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.performAction("edit"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            BGUTableParams tableParams = new BGUTableParams().setContractId(((ClientContext)this.getContext()).getContractId());
            this.tableModel.loadData((ClientContext)this.getContext(), tableParams);
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            new ContractServiceEditor("\u041d\u043e\u0432\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430", null).open();
            EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            String id = this.tableModel.optSelectedRow().map(a -> a.optValue("id").orElse(null)).orElse(null);
            new ContractServiceEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0441\u043b\u0443\u0433\u0438", id).open();
            EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            String id = this.tableModel.optSelectedRow().map(a -> a.optValue("id").orElse(null)).orElse(null);
            if (id == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            ((AOTSService)((ClientContext)this.getContext()).getWebService(AOTSService.class, ((ClientContext)this.getContext()).getModuleId())).aotsContractServiceDelete(id);
            EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
        });
    }

    class ContractServiceEditor
    extends BGEditorDialog<String> {
        private AOTSContractService contractService;
        private BGControlPanelDateNoB serviceTime;
        private BGUComboBoxRefresh<IdTitle> service;
        private BGUComboBox<KeyValue> rateMode;
        private BGDecimalTextField amount;
        private BGDecimalTextField cost;
        private BGDecimalTextField sum;
        private BGDecimalTextField serviceSum;
        private BGDecimalTextField rate;
        private BGDecimalTextField rateSum;
        private JCheckBox calCost;
        private JCheckBox rate0;
        private BGTextArea comment;

        public ContractServiceEditor(String title, String data) {
            super(title, (Object)data);
            this.contractService = null;
            this.serviceTime = new BGControlPanelDateNoB();
            this.service = new BGUComboBoxRefresh();
            this.rateMode = new BGUComboBox();
            this.amount = new BGDecimalTextField(10);
            this.cost = new BGDecimalTextField(10);
            this.sum = new BGDecimalTextField(10);
            this.serviceSum = new BGDecimalTextField(10);
            this.rate = new BGDecimalTextField(3);
            this.rateSum = new BGDecimalTextField(10);
            this.calCost = new JCheckBox("\u0420\u0430\u0441\u0441\u0447\u0438\u0442\u0430\u0442\u044c \u0446\u0435\u043d\u0443 \u0438\u0441\u0445\u043e\u0434\u044f \u0438\u0437 \u0441\u0443\u043c\u043c\u044b");
            this.rate0 = new JCheckBox("\u0411\u0435\u0437 \u041d\u0414\u0421");
            this.comment = new BGTextArea(3, 50);
        }

        public void doDialogPanel() {
            this.sum.setEnabled(false);
            this.rateSum.setEnabled(false);
            this.rateMode.setEnabled(false);
            this.serviceSum.setEnabled(false);
            this.rateMode.setData(Arrays.asList(new KeyValue("rateUp", "\u041d\u0414\u0421 \u0441\u0432\u0435\u0440\u0445\u0443"), new KeyValue("rateIn", "\u041d\u0414\u0421 \u0432\u043a\u043b\u044e\u0447\u0435\u043d")));
            this.calCost.addActionListener(e -> {
                boolean fl = this.calCost.isSelected();
                this.sum.setEnabled(fl);
                this.rateMode.setEnabled(fl);
                this.cost.setEnabled(!fl);
                this.calcSum();
            });
            this.rate0.addActionListener(e -> {
                this.rate.setEnabled(!this.rate0.isSelected());
                this.calcSum();
            });
            this.rateMode.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.calcSum();
                }
            });
            ActionListener al = e -> this.calcSum();
            this.amount.addActionListener(al);
            this.cost.addActionListener(al);
            this.sum.addActionListener(al);
            this.rate.addActionListener(al);
            this.addFieldV("\u0423\u0441\u043b\u0443\u0433\u0430:", (JComponent)this.service);
            this.addFieldV("", this.getCostPanel());
            this.addFieldV("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:", new JScrollPane((Component)this.comment));
            try {
                this.contractService = this.data == null ? ((AOTSService)AOTSContractServicePanel.this.webServiceHolder.get()).aotsContractServiceNew(((ClientContext)AOTSContractServicePanel.this.getContext()).getContractId()) : ((AOTSService)AOTSContractServicePanel.this.webServiceHolder.get()).aotsContractServiceGet((String)this.data);
                this.service.setEnabled(this.data == null);
                this.service.setSupplier(() -> ((AOTSService)AOTSContractServicePanel.this.webServiceHolder.get()).aotsServiceList(this.contractService.getServiceId()));
                this.service.refresh();
                this.service.setSelectedItem((Object)this.contractService.getServiceId());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.rate0.setSelected(this.contractService.getNdsRate() == null);
            this.cost.setText(this.contractService.getCost().setScale(2).toString());
            this.amount.setText(this.contractService.getAmount().toString());
            this.rate.setText(this.contractService.getNdsRate() == null ? "0" : this.contractService.getNdsRate().setScale(0).toString());
            this.rate.setEnabled(!this.rate0.isSelected());
            this.serviceTime.setLocalDate(this.contractService.getServiceTime().toLocalDate());
            this.comment.setText(this.contractService.getComment());
            this.calcSum();
        }

        private void calcSum() {
            try {
                BigDecimal a = Utils.parseBigDecimal((String)this.amount.getText(), (BigDecimal)BigDecimal.ZERO);
                BigDecimal r = Utils.parseBigDecimal((String)this.rate.getText(), (BigDecimal)BigDecimal.ZERO);
                BigDecimal s = BigDecimal.ZERO;
                BigDecimal rs = BigDecimal.ZERO;
                BigDecimal i = BigDecimal.ZERO;
                BigDecimal p100 = new BigDecimal(100);
                if (this.calCost.isSelected()) {
                    s = Utils.parseBigDecimal((String)this.sum.getText(), (BigDecimal)BigDecimal.ZERO);
                    String mode = ((KeyValue)this.rateMode.getSelectedItem()).getKey();
                    BigDecimal c = BigDecimal.ZERO;
                    if ("rateUp".equals(mode)) {
                        c = s.divide(a, 2, RoundingMode.HALF_UP);
                        rs = this.rate0.isSelected() ? BigDecimal.ZERO : s.divide(p100).multiply(r);
                        i = s.add(rs);
                    } else if ("rateIn".equals(mode)) {
                        c = this.rate0.isSelected() ? s.divide(a, 2, RoundingMode.HALF_UP) : s.divide(r.add(p100), 4, RoundingMode.HALF_UP).multiply(p100).divide(a, 2, RoundingMode.HALF_UP);
                        rs = this.rate0.isSelected() ? BigDecimal.ZERO : s.divide(p100.add(r), 4, RoundingMode.HALF_UP).multiply(r).setScale(2, RoundingMode.HALF_UP);
                        i = s;
                    }
                    this.cost.setText(c.toString());
                } else {
                    BigDecimal c = Utils.parseBigDecimal((String)this.cost.getText(), (BigDecimal)BigDecimal.ZERO);
                    s = a.multiply(c).setScale(2, RoundingMode.HALF_UP);
                    rs = this.rate0.isSelected() ? BigDecimal.ZERO : s.divide(p100).multiply(r);
                    i = s.add(rs);
                    this.sum.setText(s.toString());
                }
                this.rateSum.setText(rs.setScale(2, RoundingMode.HALF_UP).toString());
                this.serviceSum.setText(i.setScale(2, RoundingMode.HALF_UP).toString());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((String)ex.getLocalizedMessage());
            }
        }

        private JPanel getCostPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.amount, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0426\u0435\u043d\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.cost, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.sum, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.rateMode, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.calCost, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041d\u0414\u0421:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.rateSum, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.getRatePanel(), new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.rate0, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0412\u0441\u0435\u0433\u043e:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.serviceSum, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0414\u0430\u0442\u0430:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 0, 15, 0), 0, 0));
            panel.add((Component)this.serviceTime, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 15, 0), 0, 0));
            return panel;
        }

        private JPanel getRatePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.rate, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("%"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            this.calcSum();
            IdTitle serviceIdTitle = (IdTitle)this.service.getSelectedItem();
            if (serviceIdTitle == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443");
                return false;
            }
            this.contractService.setServiceId(serviceIdTitle.getId());
            this.contractService.setServiceTime(this.serviceTime.getLocalDate().atStartOfDay());
            this.contractService.setAmount(Utils.parseBigDecimal((String)this.amount.getText(), (BigDecimal)BigDecimal.ONE));
            this.contractService.setCost(Utils.parseBigDecimal((String)this.cost.getText(), (BigDecimal)BigDecimal.ZERO));
            this.contractService.setNdsRate(this.rate0.isSelected() ? null : Utils.parseBigDecimal((String)this.rate.getText(), (BigDecimal)BigDecimal.ZERO));
            this.contractService.setServiceSum(Utils.parseBigDecimal((String)this.serviceSum.getText(), (BigDecimal)BigDecimal.ZERO));
            this.contractService.setComment(this.comment.getText());
            return this.tryCallBoolean(() -> {
                ((AOTSService)AOTSContractServicePanel.this.webServiceHolder.get()).aotsContractServiceUpdate(((ClientContext)AOTSContractServicePanel.this.getContext()).getContractId(), this.contractService);
                AOTSContractServicePanel.this.performAction("refresh");
            });
        }
    }
}

