/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paylinks.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.paylinks.common.bean.RedirectLogEntry;
import ru.bitel.bgbilling.modules.paylinks.server.bean.MethodManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public class PaylinksRedirectLogDao {
    private Connection con;
    private String tableName;
    private ParameterMap moduleSetup;

    public PaylinksRedirectLogDao(Connection con, int mid, ParameterMap moduleSetup) {
        this.con = con;
        this.tableName = "paylinks_redirectlog_" + mid;
        this.moduleSetup = moduleSetup;
    }

    public Result<RedirectLogEntry> getList(Period period, Page page, int cid) throws BGException {
        MethodManager methodsManager = new MethodManager(this.moduleSetup);
        ArrayList<RedirectLogEntry> result = new ArrayList<RedirectLogEntry>();
        try {
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT SQL_CALC_FOUND_ROWS log.*, contract.title as contract_title, contract.comment as contract_comment ");
            query.append("FROM " + this.tableName + " AS log ");
            query.append("LEFT JOIN contract ON log.cid=contract.id ");
            query.append("WHERE (1=1) ");
            if (period != null && period.getDateFrom() != null) {
                query.append(" AND log.date>='");
                query.append(TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd"));
                query.append("'");
            }
            if (period != null && period.getDateTo() != null) {
                query.append(" AND log.date<=DATE_ADD('");
                query.append(TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd"));
                query.append("', INTERVAL 1 DAY )");
            }
            if (cid > 0) {
                query.append(" AND log.cid=" + cid);
            }
            query.append(" ORDER BY log.date");
            query.append(Page.toSqlLimit((Page)page));
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        RedirectLogEntry entry = new RedirectLogEntry();
                        PaylinksRedirectLogDao.loadEntryFromRS(entry, rs);
                        result.add(entry);
                        entry.setMethodTitle(methodsManager.getTitle(entry.getMethodId()));
                    }
                }
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    private static void loadEntryFromRS(RedirectLogEntry entry, ResultSet rs) throws SQLException {
        entry.setId(rs.getInt("log.id"));
        entry.setMethodId(rs.getInt("log.method_id"));
        entry.setCid(rs.getInt("log.cid"));
        entry.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("log.date")));
        entry.setSum(rs.getBigDecimal("log.sum"));
        entry.setRawUrl(rs.getString("log.raw_url"));
        entry.setContractTitle(rs.getString("contract_title"));
        entry.setContractComment(rs.getString("contract_comment"));
    }

    public void addLogEntry(RedirectLogEntry entry) throws BGException {
        try {
            if (entry.getMethodId() <= 0 || entry.getDate() == null || entry.getSum() == null) {
                throw new BGException("error data");
            }
            String query = "REPLACE INTO `" + this.tableName + "` (`method_id`,`cid`,`date`,`sum`,`raw_url`) VALUES (?, ?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, entry.getMethodId());
            ps.setInt(2, entry.getCid());
            ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)entry.getDate()));
            ps.setBigDecimal(4, entry.getSum());
            ps.setString(5, entry.getRawUrl());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

