/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.payonline.common.bean.Transaction;
import ru.bitel.bgbilling.modules.payonline.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;

public class PayOnlineUtils
extends BGLogger {
    private Connection con = null;
    private int moduleId = -1;
    private TransactionManager transactionManager = null;
    private ChargeDao chargeDao = null;
    private PaymentDao paymentDao = null;
    private Preferences moduleSetup = null;
    private int paymentTypeId;
    private int commissionTypeId;
    public static final int ORDER_TYPE_USUAL = 0;
    public static final int ORDER_TYPE_REBILL = 1;

    public PayOnlineUtils(Connection con, int moduleId) throws BGMessageException {
        this.con = con;
        this.moduleId = moduleId;
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.loadConfig();
    }

    private TransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = new TransactionManager(this.con, this.moduleId);
        }
        return this.transactionManager;
    }

    private ChargeDao getChargeDao() {
        if (this.chargeDao == null) {
            this.chargeDao = new ChargeDao(this.con);
        }
        return this.chargeDao;
    }

    private PaymentDao getPaymentDao() {
        if (this.paymentDao == null) {
            this.paymentDao = new PaymentDao(this.con);
        }
        return this.paymentDao;
    }

    private void loadConfig() throws BGMessageException {
        if (this.paymentTypeId <= 0) {
            this.paymentTypeId = this.moduleSetup.getInt("payment.type.id", -1);
            if (this.paymentTypeId <= 0) {
                throw new BGMessageException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430!");
            }
        }
        if (this.commissionTypeId <= 0 && this.moduleSetup.getInt("commission.type", 0) != 0) {
            this.commissionTypeId = this.moduleSetup.getInt("commission.charge.type.id", -1);
            if (this.commissionTypeId <= 0) {
                throw new BGMessageException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438!");
            }
        }
    }

    public void pay(Transaction transaction, int orderType) throws Exception {
        String comment = switch (orderType) {
            case 0 -> this.moduleSetup.get("usual.comment", "\u041c\u043e\u0434\u0443\u043b\u044c PayOnline. \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f ") + transaction.getTransactionId();
            case 1 -> this.moduleSetup.get("rebill.comment", "\u041c\u043e\u0434\u0443\u043b\u044c PayOnline. \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f ") + transaction.getTransactionId();
            default -> "\u041c\u043e\u0434\u0443\u043b\u044c PayOnline. \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f " + transaction.getTransactionId();
        };
        Payment payment = Payment.builder().setDate(transaction.getTransactionDate()).setTypeId(this.paymentTypeId).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(comment).build();
        this.getPaymentDao().update((Object)payment);
        this.getTransactionManager().addPaymentToTransaction(transaction.getId(), payment.getId(), 0);
        Charge charge = null;
        if (this.moduleSetup.getInt("commission.type", 0) != 0) {
            BigDecimal percent = this.moduleSetup.getBigDecimal("commission.percent", BigDecimal.ZERO).divide(new BigDecimal(100)).add(new BigDecimal(1));
            BigDecimal summa = transaction.getSum().divide(percent, RoundingMode.HALF_UP);
            summa = transaction.getSum().subtract(summa);
            charge = new Charge().setContractId(transaction.getContractId()).setComment(this.moduleSetup.get("commission.comment", "\u041c\u043e\u0434\u0443\u043b\u044c PayOnline. \u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f ") + transaction.getTransactionId()).setTypeId(this.commissionTypeId).setSum(summa).setDate(transaction.getTransactionDate());
            this.getChargeDao().update((Object)charge);
            this.getTransactionManager().addPaymentToTransaction(transaction.getId(), charge.getId(), 1);
        }
        ServerUtils.commitConnection((Connection)this.con);
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
        }
        ServerUtils.commitConnection((Connection)this.con);
        EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
        if (this.moduleSetup.getInt("commission.type", 0) != 0) {
            EventProcessor.getInstance().publish((Event)new ChargeEvent(0, charge));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 4, charge.getSum()));
        }
        EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
    }
}

