/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import java.beans.ConstructorProperties;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorRequest;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListener;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLogger;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusListenerWorker;
import ru.bitel.bgbilling.server.util.Setup;

public class InetRadiusListener
extends RadiusListener<InetNas>
implements ExtendedLifecycle {
    @ConstructorProperties(value={"host", "port", "recvBufferSize", "byteBufferCapacity", "soRCVBUF", "processor", "mode", "setup", "dataLogger", "threadCount", "maxQueueSize"})
    public InetRadiusListener(String host, int port, int recvBufferSize, int _recvBufferSize, int socketRcvBufSize, RadiusProcessor<?, InetNas, ?> processor, RadiusListener.Mode mode, Setup setup, RadiusHourlyDataLogger dataLogger, int threadCount, int maxQueueSize) {
        super(host, port, Math.max(recvBufferSize, _recvBufferSize), socketRcvBufSize, processor, mode, setup, dataLogger, threadCount, maxQueueSize, Boolean.FALSE);
        this.threadCountParamName = "threadCount";
        this.threadQueueParamName = "maxQueueSize";
    }

    public ProcessorRequest<?> newRequest(SocketAddress clientAddress, long millis, ByteBuffer data, int overloadLevel) {
        return new InetRadiusListenerWorker(this, clientAddress, millis, data, overloadLevel);
    }

    public void init() {
        super.init();
    }

    public void start() {
        this.startListener();
    }

    public void stop() throws Exception {
        this.shutdown();
    }

    public void destroy() throws Exception {
    }

    public void onPacket(SocketAddress clientAddress, ByteBuffer data) {
        super.onPacket(clientAddress, data);
    }
}

