/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.monitoring.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.monitoring.common.bean.JmxAppItem;
import ru.bitel.bgbilling.plugins.monitoring.common.bean.MonitoringComponent;
import ru.bitel.bgbilling.plugins.monitoring.common.bean.MonitoringComponentLogging;
import ru.bitel.bgbilling.plugins.monitoring.common.bean.MonitoringCompopentType;
import ru.bitel.bgbilling.plugins.monitoring.common.service.MonitoringService;
import ru.bitel.bgbilling.plugins.monitoring.server.bean.JmxAppItemDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.monitoring.common.service.MonitoringService")
public class MonitoringServiceImpl
extends AbstractService
implements MonitoringService {
    private JmxAppItemDao jmxAppItemDao;

    @PostConstruct
    private void init() {
        this.jmxAppItemDao = new JmxAppItemDao(this.getConnection());
    }

    public SearchResult<JmxAppItem> jmxAppItemSearch() throws Exception {
        SearchResult searchResult = new SearchResult();
        this.jmxAppItemDao.searchJmxAppItes((SearchResult<JmxAppItem>)searchResult);
        return searchResult;
    }

    public JmxAppItem jmxAppItemGet(int id) throws Exception {
        return (JmxAppItem)this.jmxAppItemDao.get(id);
    }

    public int jmxAppItemUpdate(JmxAppItem jmxAppItem) throws Exception {
        this.jmxAppItemDao.update(jmxAppItem);
        return jmxAppItem.getId();
    }

    public int jmxAppItemDelete(int id) throws Exception {
        return this.jmxAppItemDao.delete(id);
    }

    public String jmxServiceDo(String serviceUrl, String username, String password) throws Exception {
        JMXServiceURL url = new JMXServiceURL(serviceUrl);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        jmxc.close();
        return null;
    }

    public List<MonitoringComponent> componentList() throws BGException, BGMessageException {
        ArrayList<MonitoringComponent> components = new ArrayList<MonitoringComponent>();
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> mbeans = mBeanServer.queryNames(null, null);
            for (ObjectName name : mbeans) {
                Hashtable<String, String> keyPropertyList;
                String type;
                String domain = name.getDomain();
                if (!domain.startsWith("BGBilling") || !"Module".equals(type = (keyPropertyList = name.getKeyPropertyList()).get("type"))) continue;
                components.add(new MonitoringComponent().setType(MonitoringCompopentType.MODULE).setTitle(keyPropertyList.get("title")).setModuleId(Utils.parseInt((String)keyPropertyList.get("moduleId"))).setModuleName(keyPropertyList.get("moduleName")).setObjectName(name.toString()));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return components;
    }

    public List<MonitoringComponentLogging> componentLoggingList(String objectName) throws BGException, BGMessageException {
        ArrayList<MonitoringComponentLogging> componentLoggings = new ArrayList<MonitoringComponentLogging>();
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Arrays.asList((String[])mBeanServer.invoke(new ObjectName(objectName), "loggerNames", null, null)).stream().forEach(a -> componentLoggings.add(new MonitoringComponentLogging().setLoggerName(a).setLoggerLevel("info")));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return componentLoggings;
    }
}

