/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.common.TimeUtils;

public class LoaderBalanceUpdateUtil
extends LoaderBase {
    private Date date;
    private int chargeTypeId;
    private int paymentTypeId;
    private String comment;

    @Override
    public String execute(String data, String config) throws BGException {
        block27: {
            JSONObject configJsonObject = new JSONObject(config);
            int parameterId = configJsonObject.optInt("parameterId", 0);
            Calendar cal = TimeUtils.parseCalendar(configJsonObject.optString("date"), "dd.MM.yyyy");
            this.chargeTypeId = configJsonObject.optInt("chargeTypeId");
            this.paymentTypeId = configJsonObject.optInt("paymentTypeId");
            this.comment = configJsonObject.optString("comment");
            String tableName = ContractParameterPrefType.TYPE_TEXT.getTableName();
            try (ContractDao contractDao = new ContractDao(this.con, 0);
                 BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                ChargeDao chargeDao = new ChargeDao(this.con);
                PaymentDao paymentDao = new PaymentDao(this.con);
                cal.set(5, 1);
                this.date = cal.getTime();
                if (data != null) {
                    for (String line : data.split("\n")) {
                        Contract contract;
                        String[] parts = line.split("\t");
                        if (parts.length != 2 || (contract = contractDao.getByTitle(parts[0])) == null) continue;
                        this.setBalance(contract.getId(), parts[1], chargeDao, paymentDao, balanceUtils);
                    }
                    break block27;
                }
                String query = "SELECT * FROM " + tableName + " WHERE pid=?";
                try (PreparedStatement psSelect = this.con.prepareStatement(query);){
                    int parameterIndex = 1;
                    psSelect.setInt(parameterIndex, parameterId);
                    try (ResultSet resultSet = psSelect.executeQuery();){
                        while (resultSet.next()) {
                            this.setBalance(resultSet.getInt("cid"), resultSet.getString("val"), chargeDao, paymentDao, balanceUtils);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
                throw new BGException(ex);
            }
        }
        return null;
    }

    private void setBalance(int contractId, String val, ChargeDao chargeDao, PaymentDao paymentDao, BalanceUtils balanceUtils) throws Exception {
        BigDecimal sum;
        int result;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("contractId = " + contractId);
            this.getLogger().debug("inSum = " + val);
        }
        val = val.trim().replace(" ", "").replace(',', '.');
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("outSum = " + val);
        }
        if ((result = (sum = new BigDecimal(val)).compareTo(BigDecimal.ZERO)) == -1) {
            Charge charge = new Charge().setUserId(-1).setUserId(0).setContractId(contractId).setTypeId(this.chargeTypeId).setDate(this.date).setComment(this.comment).setSum(sum.negate()).setTimeChange(this.date);
            chargeDao.update(charge);
            balanceUtils.updateBalance(this.date, contractId);
        } else if (result == 1) {
            Payment payment = new Payment().setId(-1).setUserId(0).setContractId(contractId).setTypeId(this.paymentTypeId).setDate(this.date).setComment(this.comment).setSum(sum).setTimeChange(this.date);
            paymentDao.update(payment);
            balanceUtils.updateBalance(this.date, contractId);
        }
    }
}

