/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory.warehouse;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.shop.client.directory.warehouse.WarehouseEditorPanel;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeType;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemType;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;

public class WarehouseEditorSearchPanel
extends JPanel {
    private final BGUComboBox<StockItemType> stockItemTypes;
    private final BGUComboBox<StockItemAttribute> attribute;
    private final WarehouseEditorPanel editorPanel;
    private final JTextField searchField = new JTextField(22);

    public WarehouseEditorSearchPanel(WarehouseEditorPanel editorPanel) {
        super(new FlowLayout(0, 5, 0));
        this.editorPanel = editorPanel;
        this.stockItemTypes = new BGUComboBox();
        this.attribute = new BGUComboBox();
        BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u041f\u043e\u0438\u0441\u043a");
        BGSwingUtilites.wrapBorder(this.stockItemTypes, (String)"\u0422\u0438\u043f");
        BGSwingUtilites.wrapBorder(this.attribute, (String)"\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442");
        this.add(new JLabel("\u0422\u0438\u043f"));
        this.add((Component)this.stockItemTypes);
        this.add(new JLabel("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442"));
        this.add((Component)this.attribute);
        this.add(this.searchField);
    }

    protected void init(List<StockItemType> types, final ClientContext context) {
        this.stockItemTypes.setPreferredSize(new Dimension(200, this.stockItemTypes.getHeight()));
        this.attribute.setPreferredSize(new Dimension(200, this.attribute.getHeight()));
        ArrayList<StockItemType> stockItemTypeList = new ArrayList<StockItemType>();
        stockItemTypeList.add(new StockItemType(-1, "--------------------------"));
        stockItemTypeList.addAll(types);
        this.stockItemTypes.setData(stockItemTypeList);
        this.stockItemTypes.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                StockItemType selectedType = (StockItemType)this.stockItemTypes.getSelectedItem();
                StockItemAttributeKit attributeKit = null;
                if (selectedType != null && selectedType.getId() > 0 && (attributeKit = selectedType.getAttributeKit()) == null && selectedType.getParentTypeId() > 0) {
                    attributeKit = types.stream().filter(t -> t.getId() == selectedType.getParentTypeId()).findFirst().get().getAttributeKit();
                }
                if (attributeKit != null && Utils.notEmptyCollection((Collection)attributeKit.getAttributes())) {
                    this.attribute.setData(attributeKit.getAttributes().stream().filter(a -> a.getAttributeType().equals((Object)StockItemAttributeType.TEXT) || a.getAttributeType().equals((Object)StockItemAttributeType.NUMERIC)).collect(Collectors.toList()));
                    this.attribute.setEnabled(true);
                } else {
                    this.attribute.setData(new ArrayList());
                    this.attribute.setEnabled(false);
                }
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    WarehouseEditorSearchPanel.this.search(context);
                }
            }
        });
    }

    private void search(ClientContext context) {
        if (!this.checkSearchDataConditions()) {
            return;
        }
        try {
            List items = ((WarehouseService)context.getPort(WarehouseService.class, context.getModuleId())).searchStockItems(this.editorPanel.currentEntry.getId(), ((StockItemAttribute)this.attribute.getSelectedItem()).getId(), this.searchField.getText());
            if (items.isEmpty()) {
                BGToolTip.showMessage((JComponent)this.searchField, (String)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438");
            }
            this.editorPanel.stockItemTableModel.setData(items);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private boolean checkSearchDataConditions() {
        String data = this.searchField.getText();
        if (data == null || data.length() < 2) {
            return false;
        }
        if (this.stockItemTypes.getSelectedItem() == null || ((StockItemType)this.stockItemTypes.getSelectedItem()).getId() <= 0) {
            BGToolTip.showMessage(this.stockItemTypes, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f");
            return false;
        }
        if (this.attribute.getSelectedItem() == null || ((StockItemAttribute)this.attribute.getSelectedItem()).getId() <= 0) {
            BGToolTip.showMessage(this.attribute, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442");
            return false;
        }
        return true;
    }
}

