/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.contract;

import ru.bitel.bgbilling.modules.license.common.OrderUtils;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseOrderType;

public class DefaultOrder {
    private static int idGenerator = 0;
    private int id;
    private int componentId;
    private int count;
    private int productId;
    private int term;
    private String title;

    public DefaultOrder(int productId) {
        this.productId = productId;
        this.id = ++idGenerator;
    }

    public DefaultOrder(int productId, int componentId, String title, int count, int term) {
        this.productId = productId;
        this.componentId = componentId;
        this.title = title;
        this.count = count;
        this.term = term;
        this.id = ++idGenerator;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public int getCount() {
        return this.count;
    }

    public String getCountStr() {
        return OrderUtils.getCount((Integer)this.count);
    }

    public int getId() {
        return this.id;
    }

    public int getProductId() {
        return this.productId;
    }

    public int getTerm() {
        return this.term;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTypeStr() {
        return this.term == 0 ? LicenseOrderType.BUY.getText() : LicenseOrderType.TEST.getText() + " (" + this.term + ")";
    }

    public DefaultOrder setComponentId(int componentId) {
        this.componentId = componentId;
        return this;
    }

    public DefaultOrder setCount(int count) {
        this.count = count;
        return this;
    }

    public DefaultOrder setProductId(int productId) {
        this.productId = productId;
        return this;
    }

    public DefaultOrder setTerm(int term) {
        this.term = term;
        return this;
    }

    public DefaultOrder setTitle(String title) {
        this.title = title;
        return this;
    }
}

