/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.server.task;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class ContractStatusSetter
extends TaskBase {
    private final String TEMP_TABLE_NAME = "tmp_contract_status_last";

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432.";
    }

    @Override
    protected boolean initTask() {
        return true;
    }

    @Override
    protected void executeTask() {
        Calendar date = this.getOperatingTime();
        java.sql.Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)date);
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection conSlave = this.setup.getDBSlaveConnectionFromPool();){
            this.setContractStatus(sqlDate, con, conSlave);
            this.setContractObjectStatus(sqlDate, con, conSlave);
        }
        catch (Exception ex) {
            this.logError(ex);
            this.error = ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContractStatus(java.sql.Date sqlDate, Connection con, Connection conSlave) throws SQLException, BGException {
        int defaultStatus = StatusCache.getInstance().getDefaultStatus();
        String queryContractUpdate = "UPDATE contract SET status=?, status_date=? WHERE id=?";
        try (PreparedStatement psSetStatus = con.prepareStatement(queryContractUpdate);){
            int contractId;
            ResultSet rs;
            Object query = "SELECT cs.cid AS contractId, cs.status AS statusCode, cs.date1, cs.date2, contract.title FROM contract_status AS cs LEFT JOIN contract ON cs.cid=contract.id WHERE cs.object_id=0 AND (cs.date1<=? AND (cs.date2 IS NULL OR cs.date2>=?) ) AND cs.status<>contract.status";
            try (PreparedStatement psSelect = con.prepareStatement((String)query);){
                psSelect.setDate(1, sqlDate);
                psSelect.setDate(2, sqlDate);
                rs = psSelect.executeQuery();
                try {
                    while (rs.next()) {
                        contractId = rs.getInt("contractId");
                        int statusCode = rs.getInt("statusCode");
                        java.sql.Date date1 = rs.getDate("date1");
                        String title = rs.getString("title");
                        this.getLogger().info("Set contract " + title + " status " + statusCode + " from " + TimeUtils.formatDate((Date)date1));
                        psSetStatus.setInt(1, statusCode);
                        psSetStatus.setDate(2, date1);
                        psSetStatus.setInt(3, contractId);
                        psSetStatus.executeUpdate();
                        ContractStatus status = new ContractStatus().setDateFrom(date1).setDateTo(rs.getDate("date2")).setContractId(contractId).setStatus(statusCode);
                        EventProcessor.getInstance().publish(new ContractStatusChangedEvent(status, 0));
                        EventProcessor.getInstance().publish(new ContractStatusChangedTopicEvent(status, 0));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            query = "CREATE TEMPORARY TABLE tmp_contract_status_last AS SELECT DISTINCT cid, MAX(date2) as date2 FROM contract_status WHERE object_id=0 AND date2 < ? GROUP BY cid";
            try (PreparedStatement ps = con.prepareStatement((String)query);){
                ps.setDate(1, sqlDate);
                ps.executeUpdate();
            }
            query = "SELECT contract.id, temp.date2, contract.title FROM contract LEFT JOIN contract_status AS cs ON cs.cid = contract.id AND cs.date1 <= ? AND (cs.date2 is null or cs.date2 >= ? ) LEFT JOIN tmp_contract_status_last as temp ON contract.id = temp.cid WHERE cs.id is null AND cs.object_id=0 AND contract.status != " + defaultStatus;
            psSelect = con.prepareStatement((String)query);
            try {
                psSelect.setDate(1, sqlDate);
                psSelect.setDate(2, sqlDate);
                rs = psSelect.executeQuery();
                try {
                    while (rs.next()) {
                        contractId = rs.getInt("id");
                        java.sql.Date date2 = rs.getDate("temp.date2");
                        date2 = date2 != null ? TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getNextDay((Calendar)TimeUtils.convertDateToCalendar((Date)date2))) : sqlDate;
                        String title = rs.getString("title");
                        this.getLogger().info("Set contract " + title + " status " + defaultStatus + " from " + TimeUtils.formatDate((Date)date2));
                        psSetStatus.setInt(1, defaultStatus);
                        psSetStatus.setDate(2, date2);
                        psSetStatus.setInt(3, contractId);
                        psSetStatus.executeUpdate();
                        ContractStatus status = new ContractStatus().setDateFrom(date2).setContractId(contractId).setStatus(defaultStatus);
                        EventProcessor.getInstance().publish(new ContractStatusChangedEvent(status, 0));
                        EventProcessor.getInstance().publish(new ContractStatusChangedTopicEvent(status, 0));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
        }
        finally {
            try {
                ServerUtils.dropExistTable(con, "tmp_contract_status_last");
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContractObjectStatus(java.sql.Date sqlDate, Connection con, Connection conSlave1) throws SQLException, BGException {
        int defaultStatus = StatusCache.getInstance().getDefaultStatus();
        String queryContractUpdate = "UPDATE `object` SET status=?, status_date=? WHERE id=?";
        try (PreparedStatement psSetStatus = con.prepareStatement(queryContractUpdate);){
            int objectId;
            int contractId;
            ResultSet rs;
            String query = "SELECT cs.cid AS contractId, cs.status AS statusCode, cs.date1, cs.date2, cs.object_id AS objectId, object.title FROM contract_status AS cs LEFT JOIN `object` ON cs.object_id=object.id WHERE cs.object_id>0 AND (cs.date1<=? AND (cs.date2 IS NULL OR cs.date2>=?) ) AND cs.status<>object.status";
            try (PreparedStatement psSelect = con.prepareStatement(query);){
                psSelect.setDate(1, sqlDate);
                psSelect.setDate(2, sqlDate);
                rs = psSelect.executeQuery();
                try {
                    while (rs.next()) {
                        contractId = rs.getInt("contractId");
                        objectId = rs.getInt("objectId");
                        int statusCode = rs.getInt("statusCode");
                        java.sql.Date date1 = rs.getDate("date1");
                        String title = rs.getString("title");
                        this.getLogger().info("Set contract object " + title + " status " + statusCode + " from " + TimeUtils.formatDate((Date)date1));
                        psSetStatus.setInt(1, statusCode);
                        psSetStatus.setDate(2, date1);
                        psSetStatus.setInt(3, objectId);
                        psSetStatus.executeUpdate();
                        ContractStatus status = new ContractStatus().setDateFrom(date1).setDateTo(rs.getDate("date2")).setContractId(contractId).setObjectId(objectId).setStatus(statusCode);
                        EventProcessor.getInstance().publish(new ContractStatusChangedEvent(status, 0));
                        EventProcessor.getInstance().publish(new ContractStatusChangedTopicEvent(status, 0));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            query = "CREATE TEMPORARY TABLE tmp_contract_status_last AS SELECT DISTINCT object_id, MAX(date2) as date2 FROM contract_status WHERE object_id>0 AND date2 < ? GROUP BY object_id";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setDate(1, sqlDate);
                ps.executeUpdate();
            }
            query = "SELECT object.id AS objectId, object.cid AS contractId, temp.date2, object.title AS title FROM `object` LEFT JOIN contract_status AS cs ON cs.object_id = object.id AND cs.date1 <= ? AND (cs.date2 is null or cs.date2 >= ? ) LEFT JOIN tmp_contract_status_last as temp ON object.id = temp.object_id WHERE cs.id is null AND cs.object_id>0 AND object.status != -1";
            psSelect = con.prepareStatement(query);
            try {
                psSelect.setDate(1, sqlDate);
                psSelect.setDate(2, sqlDate);
                rs = psSelect.executeQuery();
                try {
                    while (rs.next()) {
                        contractId = rs.getInt("contractId");
                        objectId = rs.getInt("objectId");
                        java.sql.Date date2 = rs.getDate("temp.date2");
                        date2 = date2 != null ? TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getNextDay((Calendar)TimeUtils.convertDateToCalendar((Date)date2))) : sqlDate;
                        String title = rs.getString("title");
                        this.getLogger().info("Set contract object " + title + " status " + defaultStatus + " from " + TimeUtils.formatDate((Date)date2));
                        psSetStatus.setInt(1, defaultStatus);
                        psSetStatus.setDate(2, date2);
                        psSetStatus.setInt(3, objectId);
                        psSetStatus.executeUpdate();
                        ContractStatus status = new ContractStatus().setDateFrom(date2).setContractId(contractId).setObjectId(objectId).setStatus(-1);
                        EventProcessor.getInstance().publish(new ContractStatusChangedEvent(status, 0));
                        EventProcessor.getInstance().publish(new ContractStatusChangedTopicEvent(status, 0));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
        }
        finally {
            try {
                ServerUtils.dropExistTable(con, "tmp_contract_status_last");
            }
            catch (Exception exception) {}
        }
    }
}

