/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.bean.ServiceDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.npay.server.bean.NPayServiceStatusDao;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccountManager;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmount;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmountManager;
import ru.bitel.bgbilling.modules.npay.server.bean.quantity.ModuleQuantity;
import ru.bitel.bgbilling.modules.npay.server.bean.quantity.ModuleQuantityManger;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class NPayTariffContext
extends TariffContext {
    private static final String MODE_SERVICE_STATUS_MATRIX = "matrix";
    private String serviceStatusMode;
    private Calendar startMonth;
    private Calendar endMonth;
    private List<Integer> contractIds;
    private List<Integer> contractLabelIds;
    private List<Integer> serviceList;
    private Map<Integer, ModuleAmount> moduleAmountMap;
    private Map<Integer, ModuleAccount> moduleAccountMap;
    private Map<Integer, ModuleQuantity> moduleQuantityMap;
    private int precalcStatus = 0;
    private Period precalcOpenPeriod;
    private Calendar currentDay;
    private Connection con;
    private Map<Integer, Map<Integer, Map<Integer, List<Period>>>> suspendPeriodsMap;
    private Map<Integer, Set<Integer>> serviceNoSuspend = new HashMap<Integer, Set<Integer>>();

    public NPayTariffContext(Preferences moduleSetup, Connection con, int moduleId, Calendar startMonth, Calendar endMonth, Calendar currentDay, List<Integer> contractIds, List<Integer> contractLabelIds, List<Integer> serviceList) throws BGException {
        super(new MathContext(12, RoundingMode.HALF_UP), startMonth.getTime(), false, moduleId);
        this.con = con;
        this.startMonth = (Calendar)startMonth.clone();
        this.endMonth = (Calendar)endMonth.clone();
        this.currentDay = currentDay;
        this.contractIds = contractIds;
        this.contractLabelIds = contractLabelIds;
        this.serviceList = serviceList;
        this.serviceStatusMode = moduleSetup.get("npay.service.status.mode", MODE_SERVICE_STATUS_MATRIX);
        this.moduleAmountMap = new ModuleAmountManager(moduleSetup).getModuleAmountMap();
        this.moduleAccountMap = new ModuleAccountManager(moduleSetup).getModuleAccountMap();
        this.moduleQuantityMap = new ModuleQuantityManger(moduleSetup).getQuantityMap();
        if (MODE_SERVICE_STATUS_MATRIX.equals(this.serviceStatusMode)) {
            try (ServiceDao serviceDao = new ServiceDao(con);){
                List services = serviceDao.list(moduleId);
                List statusList = StatusCache.getInstance().getStatusList();
                Boolean[][] values = new NPayServiceStatusDao(con, moduleId).getServiceStatusValues(services.stream().map(a -> a.getId()).toList(), statusList.stream().map(a -> a.getId()).toList(), true);
                int l2 = statusList.size();
                for (int i2 = 0; i2 < l2; ++i2) {
                    HashSet<Integer> serviceSet = new HashSet<Integer>();
                    int l1 = services.size();
                    for (int i1 = 0; i1 < l1; ++i1) {
                        if (values[i1][i2] == null || !values[i1][i2].booleanValue()) continue;
                        serviceSet.add(((Service)services.get(i1)).getId());
                    }
                    if (serviceSet.isEmpty()) continue;
                    this.serviceNoSuspend.put(((Status)statusList.get(i2)).getId(), serviceSet);
                }
            }
        } else {
            for (Map.Entry me : moduleSetup.sub("service.no.suspend.").entrySet()) {
                String key = (String)me.getKey();
                String value = (String)me.getValue();
                Set serviceSet = Utils.toIntegerSet((String)value);
                if (serviceSet.size() <= 0) continue;
                for (Integer statusCode : Utils.toIntegerList((String)key)) {
                    this.serviceNoSuspend.put(statusCode, serviceSet);
                }
            }
        }
    }

    public ModuleAmount getModuleAmount(int amountType) {
        return this.moduleAmountMap.get(amountType);
    }

    public ModuleAccount getModuleAccount(int accountType) {
        return this.moduleAccountMap.get(accountType);
    }

    public ModuleQuantity getModuleQuantity(int serviceId) {
        return this.moduleQuantityMap.get(serviceId);
    }

    public Map<Integer, List<Period>> getSuspendPeriods(int contractId, int objectId, int serviceId) {
        Map<Integer, List<Period>> contractResult = this.getSuspendPeriods0(contractId, 0, serviceId);
        if (objectId == 0) {
            return contractResult;
        }
        Map<Integer, List<Period>> objectResult = this.getSuspendPeriods0(contractId, objectId, serviceId);
        if (objectResult == null || objectResult.isEmpty()) {
            return contractResult;
        }
        int[] days = new int[this.startMonth.getActualMaximum(5) + 1];
        for (int day = 0; day < days.length; ++day) {
            days[day] = -10;
        }
        LocalDate start = TimeUtils.convertDateToLocalDate((Date)this.startMonth.getTime()).withDayOfMonth(1);
        LocalDate stop = start.plusMonths(1L).minusDays(1L);
        this.setStatusToDays(days, contractResult, start, stop);
        this.setStatusToDays(days, objectResult, start, stop);
        HashMap<Integer, List<Period>> result = new HashMap<Integer, List<Period>>();
        int status = days[1];
        for (int day = 2; day < days.length; ++day) {
            if (days[day] == status) continue;
            this.toStatusPeriodMap(result, status, new Period(start, start.withDayOfMonth(day - 1)));
            status = days[day];
            start = start.withDayOfMonth(day);
        }
        this.toStatusPeriodMap(result, status, new Period(start, start.withDayOfMonth(days.length - 1)));
        return result;
    }

    private void setStatusToDays(int[] days, Map<Integer, List<Period>> map, LocalDate start, LocalDate stop) {
        for (Map.Entry<Integer, List<Period>> entry : map.entrySet()) {
            int status = entry.getKey();
            for (Period period : entry.getValue()) {
                LocalDate f = period.getLocalDateFrom();
                LocalDate t = period.getLocalDateTo();
                int from = f == null || f.isBefore(start) ? 1 : f.getDayOfMonth();
                int to = t == null || t.isAfter(stop) ? stop.getDayOfMonth() : t.getDayOfMonth();
                for (int day = from; day <= to; ++day) {
                    days[day] = status;
                }
            }
        }
    }

    private void toStatusPeriodMap(Map<Integer, List<Period>> result, int status, Period period) {
        if (status < 0) {
            return;
        }
        List<Period> list = result.get(status);
        if (list == null) {
            list = new ArrayList<Period>();
            result.put(status, list);
        }
        list.add(period);
    }

    private Map<Integer, List<Period>> getSuspendPeriods0(int contractId, int objectId, int serviceId) {
        Map<Integer, List<Period>> objectSuspendedPeriods;
        HashMap<Integer, List<Period>> result = new HashMap<Integer, List<Period>>();
        Map<Integer, Map<Integer, List<Period>>> contractSuspendedPeriods = this.getSuspendMap().get(contractId);
        if (contractSuspendedPeriods != null && (objectSuspendedPeriods = contractSuspendedPeriods.get(objectId)) != null) {
            Map<Integer, List<Period>> suspendedPeriods = objectSuspendedPeriods;
            if (this.precalcOpenPeriod != null) {
                int[] days = new int[this.startMonth.getActualMaximum(5) + 1];
                for (int day = 0; day < days.length; ++day) {
                    days[day] = -10;
                }
                LocalDate start = TimeUtils.convertDateToLocalDate((Date)this.startMonth.getTime()).withDayOfMonth(1);
                LocalDate stop = start.plusMonths(1L).minusDays(1L);
                this.setStatusToDays(days, objectSuspendedPeriods, start, stop);
                this.setStatusToDays(days, (Map<Integer, List<Period>>)new HashMap<Integer, List<Period>>(){
                    {
                        this.put(NPayTariffContext.this.precalcStatus, Arrays.asList(NPayTariffContext.this.precalcOpenPeriod));
                    }
                }, start, stop);
                HashMap<Integer, List<Period>> map = new HashMap<Integer, List<Period>>();
                int status = days[1];
                for (int day = 2; day < days.length; ++day) {
                    if (days[day] == status) continue;
                    this.toStatusPeriodMap(map, status, new Period(start, start.withDayOfMonth(day - 1)));
                    status = days[day];
                    start = start.withDayOfMonth(day);
                }
                this.toStatusPeriodMap(map, status, new Period(start, start.withDayOfMonth(days.length - 1)));
                suspendedPeriods = map;
            }
            for (Map.Entry<Integer, List<Period>> me : suspendedPeriods.entrySet()) {
                Integer status = me.getKey();
                Set<Integer> noSuspendSids = this.serviceNoSuspend.get(status);
                if (noSuspendSids != null && noSuspendSids.contains(serviceId)) continue;
                result.put(status, me.getValue());
            }
        }
        return result;
    }

    public void setPrecalcOpenPeriod(int status, Period period) {
        this.precalcStatus = status;
        this.precalcOpenPeriod = new Period(this.trimByMonthStart(period.getDateFrom()), this.trimByMonthEnd(period.getDateTo()));
    }

    public int getPrecalcStatus() {
        return this.precalcStatus;
    }

    public Period getPrecalcOpenPeriod() {
        return this.precalcOpenPeriod;
    }

    public Calendar getCurrentDay() {
        return this.currentDay;
    }

    private Map<Integer, Map<Integer, Map<Integer, List<Period>>>> getSuspendMap() {
        if (this.suspendPeriodsMap == null) {
            HashMap<Integer, Map<Integer, Map<Integer, List<Period>>>> suspendMap = new HashMap<Integer, Map<Integer, Map<Integer, List<Period>>>>();
            Set suspendStatusSet = StatusCache.getInstance().getModuleSuspendStatusSet(this.moduleId);
            if (suspendStatusSet.size() > 0 || MODE_SERVICE_STATUS_MATRIX.equals(this.serviceStatusMode)) {
                String contractJoin = "";
                if (Utils.isEmptyCollection(this.contractIds) && Utils.notEmptyCollection(this.contractLabelIds)) {
                    contractJoin = " INNER JOIN contract ON contract.id=status.cid ";
                }
                String query = "SELECT status.cid, status.date1, status.date2, status.status, status.object_id FROM contract_status AS status LEFT JOIN contract_module ON status.cid=contract_module.cid " + contractJoin + "WHERE " + (String)(MODE_SERVICE_STATUS_MATRIX.equals(this.serviceStatusMode) ? "" : "status.status IN (" + Utils.toString((Iterable)suspendStatusSet) + ") AND ") + "(status.date1 IS NULL OR status.date1<=?) AND (status.date2 IS NULL OR status.date2>=?) AND contract_module.mid=" + this.moduleId;
                if (Utils.notEmptyCollection(this.contractIds)) {
                    query = query + " AND status.cid IN (" + Utils.toString(this.contractIds) + ")";
                } else if (Utils.notEmptyCollection(this.contractLabelIds)) {
                    query = query + " AND contract.id IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString(this.contractLabelIds) + " ))";
                }
                query = query + " ORDER BY status.cid, status.date1";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)this.endMonth));
                    ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.startMonth));
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            ArrayList<Period> periodList;
                            HashMap<Integer, ArrayList<Period>> objectSuspendMap;
                            int contractId = rs.getInt("status.cid");
                            int objectId = rs.getInt("status.object_id");
                            Period period = new Period(this.trimByMonthStart(rs.getDate("status.date1")), this.trimByMonthEnd(rs.getDate("status.date2")));
                            int status = rs.getInt("status.status");
                            HashMap contactSuspendMap = (HashMap)suspendMap.get(contractId);
                            if (contactSuspendMap == null) {
                                contactSuspendMap = new HashMap(2);
                                suspendMap.put(contractId, contactSuspendMap);
                            }
                            if ((objectSuspendMap = (HashMap<Integer, ArrayList<Period>>)contactSuspendMap.get(objectId)) == null) {
                                objectSuspendMap = new HashMap<Integer, ArrayList<Period>>(2);
                                contactSuspendMap.put(objectId, objectSuspendMap);
                            }
                            if ((periodList = (ArrayList<Period>)objectSuspendMap.get(status)) == null) {
                                periodList = new ArrayList<Period>(2);
                                objectSuspendMap.put(status, periodList);
                            }
                            periodList.add(period);
                        }
                    }
                }
                catch (SQLException ex) {
                    this.logError(ex);
                }
            }
            this.suspendPeriodsMap = suspendMap;
        }
        return this.suspendPeriodsMap;
    }

    private Date trimByMonthEnd(Date date) {
        if (date == null || TimeUtils.dateBefore((Date)this.endMonth.getTime(), (Date)date)) {
            date = ((Calendar)this.endMonth.clone()).getTime();
        }
        return date;
    }

    private Date trimByMonthStart(Date date1) {
        if (date1 == null || TimeUtils.dateBefore((Date)date1, (Date)this.startMonth.getTime())) {
            date1 = ((Calendar)this.startMonth.clone()).getTime();
        }
        return date1;
    }

    public void setModuleAmountMap(Map<Integer, ModuleAmount> moduleAmountMap) {
        this.moduleAmountMap = moduleAmountMap;
    }

    public void setModuleAccountMap(Map<Integer, ModuleAccount> moduleAccountMap) {
        this.moduleAccountMap = moduleAccountMap;
    }

    public void setModuleQuantityMap(Map<Integer, ModuleQuantity> moduleQuantityMap) {
        this.moduleQuantityMap = moduleQuantityMap;
    }

    class StatusPeriod {
        int status;
        LocalDate from;
        LocalDate to;

        StatusPeriod(NPayTariffContext this$0, int status, LocalDate from, LocalDate to) {
            this.status = status;
            this.from = from;
            this.to = to;
        }
    }
}

