/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.service;

import jakarta.activation.DataHandler;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.soap.MTOM;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContractContact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessageStatistic;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.SenderType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.condition.CustomDyncodeChecker;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactTypeDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchFileStorageDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchMessageDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SenderTypeDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SubscriptionDao;
import ru.bitel.bgbilling.plugins.dispatch.server.event.DispatchEvent;
import ru.bitel.bgbilling.plugins.dispatch.server.event.DispatchSubscriptionEvent;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.bgbilling.plugins.dispatch.server.utils.DispatchUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService")
@MTOM
public class DispatchServiceImpl
extends AbstractService
implements DispatchService {
    private AbstractService.DaoHolder<ContactDao> contactDaoHolder = new AbstractService.DaoHolder((AbstractService)this, ContactDao.class);
    private AbstractService.DaoHolder<DispatchDao> dispatchDaoHolder = new AbstractService.DaoHolder((AbstractService)this, DispatchDao.class);
    private AbstractService.DaoHolder<SenderTypeDao> senderTypeDaoHolder = new AbstractService.DaoHolder((AbstractService)this, SenderTypeDao.class);
    private AbstractService.DaoHolder<ContactTypeDao> contactTypeDaoHolder = new AbstractService.DaoHolder((AbstractService)this, ContactTypeDao.class);
    private AbstractService.DaoHolder<SubscriptionDao> subscriptionDaoHolder = new AbstractService.DaoHolder((AbstractService)this, SubscriptionDao.class);
    private AbstractService.DaoHolder<DispatchMessageDao> messageDaoHolder = new AbstractService.DaoHolder((AbstractService)this, DispatchMessageDao.class);
    private DispatchFileStorageDao dispatchFileStorageDao;
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch");
    @Resource
    ModuleService moduleService;

    @PostConstruct
    public void init() {
        try {
            this.dispatchFileStorageDao = new DispatchFileStorageDao(this.getConnection(), this.plugin);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public List<Dispatch> getDispatchList() throws BGException {
        return (List)this.tryReturn(() -> ((DispatchDao)((Object)((Object)this.dispatchDaoHolder.get()))).getList());
    }

    public List<DispatchMessage> getMessageList(int did, boolean onlyNotSent) throws BGException {
        return (List)this.tryReturn(() -> ((DispatchMessageDao)((Object)((Object)this.messageDaoHolder.get()))).getList(did, onlyNotSent));
    }

    public void updateDispatch(Dispatch dispatch) throws BGException {
        this.tryCall(() -> {
            boolean isCreated = true;
            if (dispatch.getId() > 0) {
                Dispatch old = (Dispatch)((DispatchDao)((Object)((Object)this.dispatchDaoHolder.get()))).get(dispatch.getId());
                if (old != null && old.getContactTypeId() != dispatch.getContactTypeId()) {
                    throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432 \u0443 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438.");
                }
                isCreated = false;
            }
            dispatch.setUserId(this.userId);
            ((DispatchDao)((Object)((Object)this.dispatchDaoHolder.get()))).update(dispatch);
            EventProcessor.getInstance().publishAfterCommit((Event)new DispatchEvent(this.plugin.getPluginUID(), dispatch, isCreated, this.userId));
        });
    }

    public void updateMessage(DispatchMessage dispatchMessage) throws BGException {
        this.tryCall(() -> {
            DispatchMessage old;
            if (dispatchMessage.getId() > 0 && (old = (DispatchMessage)((DispatchMessageDao)((Object)((Object)this.messageDaoHolder.get()))).get(dispatchMessage.getId())).isSent()) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435!");
            }
            ((DispatchMessageDao)((Object)((Object)this.messageDaoHolder.get()))).update(dispatchMessage);
        });
    }

    public void deleteDispatch(Dispatch d) throws BGException {
        this.tryCall(() -> {
            this.dispatchFileStorageDao.deleteByObject((Id)d);
            ((DispatchMessageDao)((Object)((Object)this.messageDaoHolder.get()))).deleteByDispatch(d.getId());
            ((SubscriptionDao)this.subscriptionDaoHolder.get()).deleteByDispatch(d.getId());
            ((DispatchDao)((Object)((Object)this.dispatchDaoHolder.get()))).delete(d.getId());
        });
    }

    public void deleteMessage(DispatchMessage dm) throws BGException {
        this.tryCall(() -> {
            DispatchMessage old;
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch");
            if (dm.getId() > 0 && (old = (DispatchMessage)((DispatchMessageDao)((Object)((Object)this.messageDaoHolder.get()))).get(dm.getId())) != null && old.isSent() && plugin.getSetup().getBoolean("allow.delete.sent.messages", false)) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u044f\u0442\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435!");
            }
            this.dispatchFileStorageDao.deleteByObject((Id)dm);
            ((DispatchMessageDao)((Object)((Object)this.messageDaoHolder.get()))).delete(dm.getId());
        });
    }

    public void addMessageInclusion(DispatchMessage dm, Holder<DataHandler> inclusion, String fileName) throws BGException {
        this.tryCall(() -> {
            if (dm.isSent()) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0432 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435!");
            }
            byte[] bytes = Utils.readByBlock((InputStream)((DataHandler)inclusion.value).getInputStream());
            this.dispatchFileStorageDao.uploadFile((Id)dm, fileName, bytes);
        });
    }

    public void deleteMessageInclusion(DispatchMessage dm, BGServerFile inclusion) throws BGException {
        if (dm.isSent()) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0438\u0437 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435!");
        }
        if (inclusion == null) {
            this.dispatchFileStorageDao.deleteByObject((Id)dm);
        } else {
            this.dispatchFileStorageDao.deleteFile(inclusion.getId());
        }
    }

    public List<BGServerFile> getMessageInclusions(DispatchMessage dm) throws BGException {
        return this.dispatchFileStorageDao.getFileList((Id)dm);
    }

    public void updateContactType(ContactType current) throws BGException {
        this.tryCall(() -> ((ContactTypeDao)((Object)((Object)this.contactTypeDaoHolder.get()))).update(current));
    }

    public void deleteContactType(int contactTypeId) throws BGException {
        this.tryCall(() -> {
            if (((DispatchDao)((Object)((Object)this.dispatchDaoHolder.get()))).checkByContactType(contactTypeId)) {
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432: \u0435\u0441\u0442\u044c \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u0441 \u0442\u0430\u043a\u0438\u043c \u0442\u0438\u043f\u043e\u043c \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432");
            }
            ((ContactDao)((Object)((Object)this.contactDaoHolder.get()))).deleteByType(contactTypeId);
            ((ContactTypeDao)((Object)((Object)this.contactTypeDaoHolder.get()))).delete(contactTypeId);
        });
    }

    public List<ContactType> getContactTypes() throws BGException {
        return (List)this.tryReturn(() -> ((ContactTypeDao)((Object)((Object)this.contactTypeDaoHolder.get()))).getList());
    }

    @Deprecated
    public List<Contact> getContacts(int contractId) throws BGException {
        return (List)this.tryReturn(() -> ((ContactDao)((Object)((Object)this.contactDaoHolder.get()))).getContactsOfContract(contractId));
    }

    public List<Contact> getContacts(int contractId, Dispatch dispatch) throws BGException {
        return (List)this.tryReturn(() -> {
            int typeId;
            List<Contact> contacts = ((ContactDao)((Object)((Object)this.contactDaoHolder.get()))).getContactsOfContract(contractId);
            int contactTypeId = dispatch.getContactTypeId();
            if (Utils.notEmptyCollection(contacts)) {
                contacts.removeIf(contact -> contact.getContactTypeId() != contactTypeId);
            }
            if (Utils.isEmptyCollection(contacts) && ((typeId = DispatchUtils.getContactTypeIdOfContact(dispatch, this.getConnection())) == ContractParameterPrefType.TYPE_PHONE.getId() || typeId == ContractParameterPrefType.TYPE_EMAIL.getId())) {
                return DispatchUtils.getContactsFromContractParameters(contractId, dispatch, this.getConnection());
            }
            return contacts;
        });
    }

    public List<ContractContact> getContracts(String name, int typeId) throws BGException {
        return (List)this.tryReturn(() -> ((ContactDao)((Object)((Object)this.contactDaoHolder.get()))).getContracts(name, typeId));
    }

    public void updateContact(Contact current) throws BGException {
        this.tryCall(() -> {
            ContactType type = ((ContactTypeDao)((Object)((Object)this.contactTypeDaoHolder.get()))).get(current.getContactTypeId());
            if ((Utils.notBlankString((String)current.getValue()) || Utils.isBlankString((String)current.getValue()) && type.getPid() <= 0) && Utils.notBlankString((String)type.getPattern()) && !Pattern.matches(type.getPattern(), current.getValue())) {
                throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430!");
            }
            ((ContactDao)((Object)((Object)this.contactDaoHolder.get()))).update(current);
        });
    }

    public void deleteContact(int id) throws BGException {
        this.tryCall(() -> {
            if (((SubscriptionDao)this.subscriptionDaoHolder.get()).isContactSubscribed(id)) {
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!");
            }
            ((ContactDao)((Object)((Object)this.contactDaoHolder.get()))).delete(id);
        });
    }

    public List<Subscription> getSubscriptions(int dispatchId, int contractId) throws BGException {
        return (List)this.tryReturn(() -> ((SubscriptionDao)this.subscriptionDaoHolder.get()).getList(dispatchId, contractId, null));
    }

    public List<Subscription> getActiveSubscriptions(int dispatchId) throws BGException {
        return (List)this.tryReturn(() -> ((SubscriptionDao)this.subscriptionDaoHolder.get()).getList(dispatchId, 0, Boolean.TRUE));
    }

    public void deleteSubscription(int subscriptionId) throws BGException {
        this.tryCall(() -> {
            Subscription s = ((SubscriptionDao)this.subscriptionDaoHolder.get()).get(subscriptionId);
            ((SubscriptionDao)this.subscriptionDaoHolder.get()).delete(subscriptionId);
            EventProcessor.getInstance().publishAfterCommit((Event)new DispatchSubscriptionEvent(this.plugin.getPluginUID(), s, false, this.userId));
        });
    }

    public void updateSubscriptions(Subscription subscription) throws BGException {
        this.tryCall(() -> {
            int typeId;
            Dispatch dispatch = subscription.getDispatch();
            if (subscription.getContacts() != null && subscription.getContacts().size() == 0 && !dispatch.isWoContactType() && (typeId = DispatchUtils.getContactTypeIdOfContact(dispatch, this.getConnection())) != ContractParameterPrefType.TYPE_PHONE.getId() && typeId != ContractParameterPrefType.TYPE_EMAIL.getId()) {
                throw new BGMessageException("\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u044b!");
            }
            if (subscription.getContacts().size() > 1 && ((DispatchDao)((Object)((Object)this.dispatchDaoHolder.get()))).isOnlyOneContact(dispatch.getId())) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430!");
            }
            boolean isNotSubscribedYet = subscription.getId() <= 0;
            ((SubscriptionDao)this.subscriptionDaoHolder.get()).update(subscription);
            if (this.plugin.getSetup().getBoolean("dispatch.email.unsubscribe", false) && subscription.getDispatch().getSenderType().getId() == -1) {
                ((SubscriptionDao)this.subscriptionDaoHolder.get()).generateHashes(subscription);
            }
            if (isNotSubscribedYet) {
                EventProcessor.getInstance().publishAfterCommit((Event)new DispatchSubscriptionEvent(this.plugin.getPluginUID(), subscription, true, this.userId));
            }
        });
    }

    public void addSubscriptions(String dispatchIds, String contractIds) throws BGException {
        this.tryCall(() -> {
            for (Integer dispatchId : Utils.toIntegerList((String)dispatchIds)) {
                Dispatch dispatch = (Dispatch)((DispatchDao)((Object)((Object)this.dispatchDaoHolder.get()))).get(dispatchId);
                if (dispatch == null) continue;
                for (Integer cid : Utils.toIntegerList((String)contractIds)) {
                    List<Subscription> contractSubscriptions = this.getSubscriptions(dispatchId, cid);
                    if (!contractSubscriptions.isEmpty()) continue;
                    ArrayList<Contact> subscriptionContacts = new ArrayList<Contact>();
                    for (Contact contact : this.getContacts(cid)) {
                        if (contact.getContactTypeId() != dispatch.getContactTypeId()) continue;
                        subscriptionContacts.add(contact);
                    }
                    if (!subscriptionContacts.isEmpty()) {
                        this.addSubscriptionOnContract(dispatch, cid, subscriptionContacts);
                        continue;
                    }
                    Contact contact = this.addDefaultContact(dispatch, cid);
                    if (contact == null) continue;
                    this.addSubscriptionOnContract(dispatch, cid, Collections.singletonList(contact));
                }
            }
        });
    }

    private Contact addDefaultContact(Dispatch dispatch, int cid) throws BGException {
        return (Contact)this.tryReturn(() -> {
            ContactType contactType = ((ContactTypeDao)((Object)((Object)this.contactTypeDaoHolder.get()))).get(dispatch.getContactTypeId());
            if (contactType != null && contactType.getPid() > 0) {
                Contact contact = new Contact();
                contact.setContactTypeId(dispatch.getContactTypeId());
                contact.setContractId(cid);
                contact.setValue("");
                this.updateContact(contact);
                return contact;
            }
            return null;
        });
    }

    private void addSubscriptionOnContract(Dispatch dispatch, int contractId, List<Contact> contacts) throws BGException {
        Subscription subscription = new Subscription().setActive(true).setContractId(contractId).setDispatch(dispatch).setPreferences(new Preferences()).setComment("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0430 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u043e\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438").setContacts(contacts).setSubscriptionPeriod(new Period(new Date(), null));
        this.updateSubscriptions(subscription);
    }

    public List<SenderType> getSenderTypes() throws BGException {
        return (List)this.tryReturn(() -> ((SenderTypeDao)((Object)((Object)this.senderTypeDaoHolder.get()))).getList());
    }

    public String getSenderIfaceClassName() {
        return Sender.class.getCanonicalName();
    }

    public void updateSenderType(SenderType current) throws BGException {
        this.tryCall(() -> {
            if (current.getId() < 0) {
                throw new BGIllegalArgumentException();
            }
            ((SenderTypeDao)((Object)((Object)this.senderTypeDaoHolder.get()))).update(current);
        });
    }

    public void deleteSenderType(int id) throws BGException {
        this.tryCall(() -> {
            if (id <= 0) {
                throw new BGIllegalArgumentException();
            }
            ((SenderTypeDao)((Object)((Object)this.senderTypeDaoHolder.get()))).delete(id);
        });
    }

    @Deprecated
    public List<IdTitle> getAddressParamList() throws BGException {
        return (List)this.tryReturn(() -> new ContractParameterPrefDao(this.getConnection()).getContractParameterPrefIdTitleList(2));
    }

    public String getCustomConditionCheckerIfaceName() {
        return CustomDyncodeChecker.class.getName();
    }

    public void setEventForSubscription(int dispatchId, int contractId) throws BGException {
        for (Subscription subscription : this.getSubscriptions(dispatchId, contractId)) {
            subscription.getPreferences().set("event.occured.flag", "1");
            this.updateSubscriptions(subscription);
        }
    }

    public SearchResult<DispatchMessageStatistic> getMessageStatisticList(int contractId, int dispatchId, int messageId, int contactId, Period period, Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(period, page);
            ((DispatchMessageDao)((Object)((Object)this.messageDaoHolder.get()))).getMessageStatisticList(contractId, dispatchId, messageId, contactId, (SearchResult<DispatchMessageStatistic>)searchResult);
            return searchResult;
        });
    }

    public List<String> installedModuleList() throws BGException {
        return (List)this.tryReturn(() -> this.moduleService.installedModuleList().stream().map(BGInstalledModule::getName).collect(Collectors.toList()));
    }

    public String getContactDefaultValue(int contactTypeId, int contractId) throws BGException {
        return (String)this.tryReturn(() -> ((ContactDao)((Object)((Object)this.contactDaoHolder.get()))).getDefaultValue(contactTypeId, contractId));
    }
}

