/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.card.server.bean.CardAction;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class CardActionManager
extends AbstarctDaoConstant {
    private final String TABLE_CARD_DEALER;

    public CardActionManager(Connection con, int moduleId) {
        super(con, "card_action", moduleId);
        this.TABLE_CARD_DEALER = "card_dealer_" + moduleId;
    }

    public void updateAction(CardAction action) throws SQLException {
        Objects.requireNonNull(action, "action must be not null");
        boolean update = action.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET type=?, dtime=?, dealer_id=?, count=?, summ=?, cost=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setInt(1, action.getType());
            ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)action.getTime()));
            ps.setInt(3, action.getDealerId());
            ps.setInt(4, action.getCardCount());
            ps.setFloat(5, action.getCardSumma());
            ps.setFloat(6, action.getCost());
            if (update) {
                ps.setInt(7, action.getId());
            }
            ps.executeUpdate();
            if (!update) {
                action.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public CardAction getActionById(int id) {
        CardAction result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getActionFromRs(rs, false);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public List<CardAction> getActionList(int dealerId, Date fromDate, Date toDate, int type) {
        return this.getActionList(dealerId, new Period(fromDate, toDate), type);
    }

    public List<CardAction> getActionList(int dealerId, Period period, int type) {
        ArrayList<CardAction> result = new ArrayList<CardAction>();
        try {
            int index = 1;
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT action.*, dealer.title FROM ").append(this.tableName).append(" AS action ").append(" LEFT JOIN ").append(this.TABLE_CARD_DEALER).append(" AS dealer ON action.dealer_id=dealer.id").append(" WHERE true");
            if (dealerId > 0) {
                query.append(" AND action.dealer_id=?");
            }
            if (type > 0) {
                query.append(" AND action.type=?");
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND action.dtime>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND action.dtime<?");
                }
            }
            query.append(" ORDER BY dtime");
            ps = this.con.prepareStatement(query.toString());
            if (dealerId > 0) {
                ps.setInt(index++, dealerId);
            }
            if (type > 0) {
                ps.setInt(index++, type);
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                if (period.getDateTo() != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                }
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getActionFromRs(rs, true));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteAction(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    private CardAction getActionFromRs(ResultSet rs, boolean loadDealerTitle) throws Exception {
        return new CardAction().setId(rs.getInt("id")).setDealerId(rs.getInt("dealer_id")).setDealerTitle(loadDealerTitle ? rs.getString("title") : "").setType(rs.getInt("type")).setTime(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("dtime"))).setCardCount(rs.getInt("count")).setCardSumma(rs.getFloat("summ")).setCost(rs.getFloat("cost"));
    }
}

