/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SenderTypeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.ScheduleTime;

public class DispatchDao
extends AbstractIdDao<Dispatch> {
    public DispatchDao(Connection con) {
        super(con, "dispatch_dispatch");
    }

    protected void updateImpl(Dispatch dispatch) throws SQLException {
        Objects.requireNonNull(dispatch);
        boolean update = dispatch.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, sender_type_id=?, repeat_time=?, contact_type_id=?, conditions=?, active=?, personal=?, do_not_mark_sended=?, only_one_contact=?, wo_contact_type=?, user=?, last_modify_date=NOW()" + (update ? " WHERE id=?" : ", create_date=NOW()");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            byte[] bytes = this.serializeDispatchConditions(dispatch);
            int index = 1;
            ps.setString(index++, dispatch.getTitle());
            ps.setInt(index++, dispatch.getSenderType().getId());
            ps.setString(index++, ScheduleTime.serialize((ScheduleTime)dispatch.getRepeatTime()));
            ps.setInt(index++, dispatch.getContactTypeId());
            ps.setBytes(index++, bytes);
            ps.setBoolean(index++, dispatch.isActive());
            ps.setBoolean(index++, dispatch.isPersonal());
            ps.setBoolean(index++, dispatch.isDoNotMarkSended());
            ps.setBoolean(index++, dispatch.isOnlyOneContact());
            ps.setBoolean(index++, dispatch.isWoContactType());
            ps.setInt(index++, dispatch.getUserId());
            if (update) {
                ps.setInt(index++, dispatch.getId());
            }
            ps.executeUpdate();
            if (!update) {
                dispatch.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    private byte[] serializeDispatchConditions(Dispatch dispatch) {
        Objects.requireNonNull(dispatch);
        Document doc = XMLUtils.newDocument();
        Element items = XMLUtils.createElement((Document)doc, (String)"items");
        for (DispatchCondition cond : dispatch.getConditions()) {
            cond.serialize(XMLUtils.createElement((Element)items, (String)"item"));
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtils.serialize((Node)doc, (OutputStream)baos, (String)"UTF-8");
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new BGRuntimeException((Throwable)ex);
        }
    }

    protected Dispatch getFromRS(ResultSet rs) throws SQLException {
        Dispatch dispatch = new Dispatch();
        dispatch.setId(rs.getInt(this.tableName + ".id"));
        dispatch.setSenderType(SenderTypeDao.getSenderTypeFromRS(rs, this.tableName));
        dispatch.setRepeatTime(ScheduleTime.deserialize((String)rs.getString(this.tableName + ".repeat_time")));
        dispatch.setContactTypeId(rs.getInt(this.tableName + ".contact_type_id"));
        dispatch.setTitle(rs.getString(this.tableName + ".title"));
        dispatch.setActive(rs.getBoolean(this.tableName + ".active"));
        dispatch.setPersonal(rs.getBoolean(this.tableName + ".personal"));
        dispatch.setDoNotMarkSended(rs.getBoolean(this.tableName + ".do_not_mark_sended"));
        dispatch.setOnlyOneContact(rs.getBoolean(this.tableName + ".only_one_contact"));
        dispatch.setWoContactType(rs.getBoolean(this.tableName + ".wo_contact_type"));
        dispatch.setUserId(rs.getInt(this.tableName + ".user"));
        dispatch.setCreateDispatchDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(this.tableName + ".create_date")));
        dispatch.setLastModifyDispatchDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(this.tableName + ".last_modify_date")));
        try {
            dispatch.setConditions(this.deserializeConditions(rs));
        }
        catch (Exception ex) {
            throw new BGRuntimeException((Throwable)ex);
        }
        return dispatch;
    }

    private List<DispatchCondition> deserializeConditions(ResultSet rs) throws SQLException {
        byte[] bytes = rs.getBytes(this.tableName + ".conditions");
        ArrayList<DispatchCondition> conditions = new ArrayList<DispatchCondition>();
        if (bytes.length == 0) {
            return conditions;
        }
        Document doc = XMLUtils.parseDocument((byte[])bytes);
        for (Element item : XMLUtils.selectElements((Node)doc, (String)"//items/item")) {
            try {
                String className = item.getAttribute("class");
                DispatchCondition condition = (DispatchCondition)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                condition.deserialize(item);
                conditions.add(condition);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return conditions;
    }

    public Dispatch getDispatchFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs);
    }

    public List<Dispatch> getList() throws SQLException {
        ArrayList<Dispatch> list = new ArrayList<Dispatch>();
        String query = "SELECT * FROM " + this.tableName + " LEFT JOIN dispatch_sender_type ON " + this.tableName + ".sender_type_id=dispatch_sender_type.id ORDER BY " + this.tableName + ".title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                list.add(this.getDispatchFromRS(rs));
            }
        }
        return list;
    }

    protected Dispatch getImpl(int id) throws SQLException {
        Dispatch result = null;
        String query = "SELECT * FROM " + this.tableName + " LEFT JOIN dispatch_sender_type ON " + this.tableName + ".sender_type_id=dispatch_sender_type.id WHERE " + this.tableName + ".id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        return result;
    }

    public boolean checkByContactType(int contactTypeId) throws SQLException {
        boolean result = false;
        String query = "SELECT id FROM " + this.tableName + " WHERE contact_type_id=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contactTypeId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean isOnlyOneContact(int id) throws SQLException {
        boolean result = false;
        String query = "SELECT only_one_contact FROM " + this.tableName + " WHERE id = ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next() && rs.getInt("only_one_contact") == 1) {
                    result = true;
                }
            }
        }
        return result;
    }
}

